/*
 * Copyright (c) 2025.  Interloc Solutions Inc.  All rights reserved.
 * Unauthorized copying, modification, or distribution of this file, via
 * any medium is strictly prohibited.  Proprietary and confidential.
 *
 * File: pushqueue_mysql.sql
 */

CREATE TABLE ispushqueue (
    active             INTEGER NOT NULL,
    catalog            VARCHAR(50),
    errorcount         INTEGER,
    errormsg           TEXT,
    host               VARCHAR(100 ),
    inerror            INTEGER,
    langcode           VARCHAR(4),
    node               VARCHAR(100),
    notifynum          VARCHAR(20),
    partitionname      VARCHAR(30),
    pushdeviceid       INT,
    pushqueueid        BIGINT NOT NULL AUTO_INCREMENT,
    pushtype           VARCHAR(50),
    threadname         VARCHAR(100),
    trackingid         INT,
    triggerobject      VARCHAR(30),
    triggerobjectid    BIGINT,
    PRIMARY KEY (pushqueueid)
);

CREATE INDEX ispushqueue_ndx10 ON ispushqueue (inerror,active);
CREATE INDEX ispushqueue_ndx11 ON ispushqueue (pushtype,pushdeviceid,active);
CREATE INDEX ispushqueue_ndx12 ON ispushqueue (active,host,node,threadname,pushqueueid);
