/*
 * Copyright (c) 2025.  Interloc Solutions Inc.  All rights reserved.
 * Unauthorized copying, modification, or distribution of this file, via
 * any medium is strictly prohibited.  Proprietary and confidential.
 *
 * File: pushqueue_mssql.sql
 */

CREATE TABLE "ispushqueue" (
    "active"             INTEGER NOT NULL,
    "catalog"            VARCHAR(50),
    "errorcount"         INTEGER,
    "errormsg"           VARCHAR(max),
    "host"               VARCHAR(100 ),
    "inerror"            INTEGER,
    "langcode"           VARCHAR(4),
    "node"               VARCHAR(100),
    "notifynum"          VARCHAR(20),
    "partitionname"      VARCHAR(30),
    "pushdeviceid"       INT,
    "pushqueueid"        BIGINT NOT NULL IDENTITY,
    "pushtype"           VARCHAR(50),
    "threadname"         VARCHAR(100),
    "trackingid"         INT,
    "triggerobject"      VARCHAR(30),
    "triggerobjectid"    BIGINT,
    CONSTRAINT "ispushqueue_ndx6" PRIMARY KEY CLUSTERED ("pushqueueid" ASC)
    WITH (ALLOW_PAGE_LOCKS = OFF, ALLOW_ROW_LOCKS = ON)
);

CREATE INDEX "ispushqueue_ndx10" ON
    "ispushqueue" ("inerror","active")
    WITH (ALLOW_PAGE_LOCKS = OFF, ALLOW_ROW_LOCKS = ON);

CREATE INDEX "ispushqueue_ndx11" ON
    "ispushqueue" ("pushtype","pushdeviceid","active")
    WITH (ALLOW_PAGE_LOCKS = OFF, ALLOW_ROW_LOCKS = ON);

CREATE INDEX "ispushqueue_ndx12" ON
    "ispushqueue" ("active","host","node","threadname","pushqueueid")
    WITH (ALLOW_PAGE_LOCKS = OFF, ALLOW_ROW_LOCKS = ON);

ALTER TABLE ispushqueue SET (LOCK_ESCALATION = DISABLE);
