/*
 * Copyright (c) 2025.  Interloc Solutions Inc.  All rights reserved.
 * Unauthorized copying, modification, or distribution of this file, via
 * any medium is strictly prohibited.  Proprietary and confidential.
 *
 * File: droptables_oracle.sql
 */

-- DELIMITER /
DECLARE
    PROCEDURE drop_table_if_exists (table_name IN VARCHAR2)
    IS
    BEGIN
        EXECUTE IMMEDIATE 'DROP TABLE ' || table_name;
    EXCEPTION
       WHEN OTHERS THEN
          IF SQLCODE != -942 THEN
             RAISE;
          END IF;
    END drop_table_if_exists;

    PROCEDURE drop_sequence_if_exists (sequence_name IN VARCHAR2)
    IS
    BEGIN
        EXECUTE IMMEDIATE 'DROP SEQUENCE ' || sequence_name;
    EXCEPTION
       WHEN OTHERS THEN
          IF SQLCODE != -2289 THEN
             RAISE;
          END IF;
    END drop_sequence_if_exists;
BEGIN
    drop_table_if_exists('ISRAWSCHEMAVERSION');

    drop_table_if_exists('ISCATALOGJOBQUEUE');
    drop_sequence_if_exists('ISCATALOGJOBQUEUEID_SEQ');

    drop_table_if_exists('ISNOTIFYREFRESHQUEUE');
    drop_sequence_if_exists('ISNOTIFYREFRESHQUEUID_SEQ');

    drop_table_if_exists('ISPUSHQUEUE');
    drop_sequence_if_exists('ISPUSHQUEUEID_SEQ');

    drop_table_if_exists('ISQUEUEPROCESSORSTATE');
END;
/

