#!/bin/bash

#
# Copyright (c) 2025.  Interloc Solutions Inc.  All rights reserved.
# Unauthorized copying, modification, or distribution of this file, via
# any medium is strictly prohibited.  Proprietary and confidential.
#
# File: postpreprocessor.sh
#

set -euo pipefail

# Make sure all the informer-*.sh scripts are executable
if ! find . -type f -name "informer-*.sh" -exec chmod -v 777 {} \; ; then
  echo "Failed to set execute permissions on informer-*.sh scripts."
  exit 1
fi

# Run installer to apply changes on web.xml on boh maximo-ui and maximo-all
./informer-install.sh -x ../../deployment/was-liberty-default/config-deployment-descriptors/maximo-all/maximouiweb/webmodule/WEB-INF/web.xml
./informer-install.sh -x ../../deployment/was-liberty-default/config-deployment-descriptors/maximo-ui/webmodule/WEB-INF/web.xml

# Update jvm.options for each maximo-*-server directory
find ../../deployment/was-liberty-default/config-servers -type d -name 'maximo-*-server' -print0 |
while IFS= read -r -d '' serverdir; do
  optionfile="$serverdir/jvm.options"
  tmpfile="$optionfile.$$"

  if [ -e "$optionfile" ] ; then
    # delete any webservices.unify.faults, then add our own.
    if ! sed '/-Dwebservices.unify.faults/d ; $ i -Dwebservices.unify.faults=false' "$optionfile" > "$tmpfile"; then
      echo "Failed to update $optionfile"
      exit 1
    fi
    mv "$tmpfile" "$optionfile" || {
      echo "Failed to move $tmpfile to $optionfile"
      exit 1
    }
  else
    echo "-Dwebservices.unify.faults=false" > "$optionfile" || {
      echo "Failed to create $optionfile"
      exit 1
    }
  fi
done
