/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util.hash;

import com.interlocsolutions.maximo.notify.util.License;
import com.interlocsolutions.maximo.notify.util.hash.AbstractLicenseHashGenerator;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class LicenseV2HashGenerator
extends AbstractLicenseHashGenerator {
    public LicenseV2HashGenerator() {
        super(64);
    }

    @Override
    protected MessageDigest newMessageDigest() throws NoSuchAlgorithmException, NoSuchProviderException {
        return MessageDigest.getInstance("SHA512");
    }

    @Override
    protected byte[] generateDigest(MessageDigest digest, License license) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream das = new DataOutputStream(byteStream);
        try {
            das.writeInt(0);
            das.writeUTF(license.getApplicationList());
            das.writeInt(0);
            das.writeInt(license.getUserCount());
            das.writeInt(0);
            das.writeInt(license.getDeviceCount());
            das.writeInt(0);
            if (license.getExpDate() != null) {
                das.writeLong(license.getExpDate().getTimeInMillis());
            }
            das.writeInt(0);
            if (license.getDevelopment() != null) {
                das.writeUTF(license.getDevelopment());
            }
            das.writeInt(0);
            if (license.getLicensee() != null) {
                das.writeUTF(license.getLicensee());
            }
            das.writeInt(0);
            das.close();
            return digest.digest(byteStream.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

