/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util.hash;

import com.interlocsolutions.maximo.notify.util.License;
import com.interlocsolutions.maximo.notify.util.hash.AbstractLicenseHashGenerator;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class LicenseV1HashGenerator
extends AbstractLicenseHashGenerator {
    public LicenseV1HashGenerator() {
        super(20);
    }

    @Override
    protected MessageDigest newMessageDigest() throws NoSuchAlgorithmException, NoSuchProviderException {
        return MessageDigest.getInstance("SHA1", "BC");
    }

    @Override
    protected byte[] generateDigest(MessageDigest digest, License license) {
        LicenseV1 v1 = new LicenseV1(license);
        return digest.digest(v1.toString().getBytes());
    }

    @XmlRootElement(name="license", namespace="http://www.interlocsolutions.com/maximo/notify")
    @XmlType(propOrder={"userCount", "expDate", "applications", "development", "licensee", "hash"}, namespace="http://www.interlocsolutions.com/maximo/notify")
    private static class LicenseV1 {
        @XmlElementWrapper(name="applications", namespace="http://www.interlocsolutions.com/maximo/notify")
        @XmlElement(name="application", namespace="http://www.interlocsolutions.com/maximo/notify")
        public List<String> applications = null;
        @XmlElement(name="usercount", namespace="http://www.interlocsolutions.com/maximo/notify")
        public int userCount = -1;
        @XmlElement(name="expires", namespace="http://www.interlocsolutions.com/maximo/notify")
        @XmlJavaTypeAdapter(value=CalendarAdapter.class)
        public Calendar expDate = null;
        @XmlElement(name="development", namespace="http://www.interlocsolutions.com/maximo/notify")
        public String development = null;
        @XmlElement(name="hash", namespace="http://www.interlocsolutions.com/maximo/notify")
        public String hash = null;
        @XmlElement(name="licensee", namespace="http://www.interlocsolutions.com/maximo/notify")
        public String licensee = null;

        public LicenseV1() {
        }

        public LicenseV1(License license) {
            this.applications = license.getApplications();
            this.userCount = license.getUserCount();
            this.expDate = license.getExpDate();
            this.development = license.getDevelopment();
            this.licensee = license.getLicensee();
        }

        public String toString() {
            try {
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{LicenseV1.class});
                Marshaller marshaller = jc.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                StringWriter writer = new StringWriter();
                marshaller.marshal((Object)this, (Writer)writer);
                return writer.toString();
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class CalendarAdapter
    extends XmlAdapter<String, Calendar> {
        private final String TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssX";

        private CalendarAdapter() {
        }

        public String marshal(Calendar dateTime) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
            dateFormat.setTimeZone(dateTime.getTimeZone());
            return dateFormat.format(dateTime.getTime());
        }

        public Calendar unmarshal(String dateTime) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
            try {
                Calendar c = Calendar.getInstance();
                c.setTime(dateFormat.parse(dateTime));
                return c;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

