/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.util.License;
import com.interlocsolutions.maximo.notify.util.LicenseSigner;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.stringparsers.DateStringParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

public class LicenseGen {
    public static void main(String[] args) {
        try {
            Object[] applist;
            JSAP jsap = new JSAP();
            FlaggedOption opt1 = new FlaggedOption("applications").setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('a').setLongFlag("applications").setList(true).setListSeparator(',');
            opt1.setHelp("A comma delimited list of applications that will be valid for use with Informer.");
            jsap.registerParameter((Parameter)opt1);
            FlaggedOption opt2 = new FlaggedOption("development").setStringParser((StringParser)JSAP.BOOLEAN_PARSER).setRequired(false).setShortFlag('d').setLongFlag("development").setDefault("false");
            opt2.setHelp("Flag to inidcate that the license is indended for development purposes.");
            jsap.registerParameter((Parameter)opt2);
            DateStringParser dsp = DateStringParser.getParser();
            dsp.setProperty("format", "M/d/yyyy");
            FlaggedOption opt3 = new FlaggedOption("expdate").setRequired(false).setShortFlag('e').setLongFlag("expires").setStringParser((StringParser)dsp);
            opt3.setHelp("Date when the license will expire.");
            jsap.registerParameter((Parameter)opt3);
            FlaggedOption opt4 = new FlaggedOption("licensee").setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setShortFlag('l').setLongFlag("licensee");
            opt4.setHelp("The name of the licensee.");
            jsap.registerParameter((Parameter)opt4);
            FlaggedOption opt5 = new FlaggedOption("users").setStringParser((StringParser)JSAP.INTEGER_PARSER).setRequired(false).setShortFlag('c').setLongFlag("usercount").setDefault("-1");
            opt5.setHelp("The number of named users that can be used with Informer.");
            jsap.registerParameter((Parameter)opt5);
            FlaggedOption opt6 = new FlaggedOption("path").setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setShortFlag('p').setLongFlag("path");
            opt5.setHelp("The output path for the license, if not specified the result is printed to the console.");
            jsap.registerParameter((Parameter)opt6);
            FlaggedOption opt7 = new FlaggedOption("devices").setStringParser((StringParser)JSAP.INTEGER_PARSER).setRequired(false).setShortFlag('m').setLongFlag("devicecount").setDefault("-1");
            jsap.registerParameter((Parameter)opt7);
            JSAPResult config = jsap.parse(args);
            if (!config.success()) {
                System.err.println();
                Iterator i = config.getErrorMessageIterator();
                while (i.hasNext()) {
                    System.err.println(i.next());
                }
                System.err.println();
                System.err.println("Usage: java " + LicenseGen.class.getName());
                System.err.println("                " + jsap.getUsage());
                System.err.println();
                System.err.println(jsap.getHelp());
                System.exit(1);
            }
            License lic = new License();
            if (config.getString("applications") != null && (applist = config.getObjectArray("applications")) != null) {
                for (Object app : applist) {
                    lic.addApplication(app.toString());
                }
            }
            if (config.getBoolean("development")) {
                lic.setDevelopment(config.getBoolean("development"));
            }
            if (config.getDate("expdate") != null) {
                lic.setExpDate(config.getDate("expdate"));
            }
            lic.setLicensee(config.getString("licensee"));
            lic.setUserCount(config.getInt("users"));
            lic.setDeviceCount(config.getInt("devices"));
            OutputStream os = System.out;
            if (config.getString("path") != null) {
                File f = new File(config.getString("path"));
                if (!f.getParentFile().exists()) {
                    f.mkdirs();
                }
                os = new FileOutputStream(f);
            }
            LicenseSigner.signLicense(lic);
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{License.class});
            Marshaller m = ctx.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.marshal((Object)lic, os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

