/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jdom.Content;
import org.jdom.Element;
import psdi.iface.mic.StructureData;
import psdi.iface.mic.StructureObject;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

public class StructureDataIterator
implements Iterator<StructureObject> {
    private final StructureData sd;
    private int index;
    private StructureObject currentElement;

    public StructureDataIterator(StructureData data) throws MXException {
        data.breakData();
        this.index = -1;
        this.sd = data;
    }

    @Override
    public boolean hasNext() {
        return this.index + 1 < this.sd.getSize();
    }

    @Override
    public StructureObject next() {
        if (this.index + 1 >= this.sd.getSize()) {
            throw new NoSuchElementException();
        }
        ++this.index;
        this.currentElement = this.sd.getStructureObject(this.index);
        return this.currentElement;
    }

    @Override
    public void remove() {
        if (this.currentElement == null) {
            throw new NoSuchElementException();
        }
        Element parent = (Element)this.currentElement.getCurrentData().getParent();
        parent.removeContent((Content)this.currentElement.getCurrentData());
    }

    public void skip() throws MXException {
        if (!this.sd.isMultiObjectStructure()) {
            throw new MXApplicationException("iface", "SKIP_TRANSACTION");
        }
        this.remove();
    }
}

