/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.util;

import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.util.MXException;

public class MboSetConcatIterator<E extends MboRemote>
implements Iterator<E>,
Iterable<E> {
    private final LinkedList<MboSetRemote> mbosets = new LinkedList();
    private E nextElement;
    private int currentElement = -1;

    public MboSetConcatIterator(MboSetRemote ... mboSetRemotes) {
        Collections.addAll(this.mbosets, mboSetRemotes);
        this.advanceNextElement();
    }

    @Override
    public boolean hasNext() {
        return this.nextElement != null;
    }

    @Override
    public E next() {
        if (this.nextElement == null) {
            throw new NoSuchElementException();
        }
        E rc = this.nextElement;
        this.advanceNextElement();
        return rc;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }

    public void addMboSet(MboSetRemote mboset) {
        if (!this.hasNext()) {
            throw new IllegalStateException("Unable to add an mboset once it has completed.");
        }
        this.mbosets.add(mboset);
    }

    private void advanceNextElement() {
        try {
            ++this.currentElement;
            this.nextElement = this.mbosets.peekFirst().getMbo(this.currentElement);
            while (this.nextElement == null && this.mbosets.size() > 1) {
                this.mbosets.removeFirst();
                this.currentElement = 0;
                this.nextElement = this.mbosets.peekFirst().getMbo(this.currentElement);
            }
        }
        catch (RemoteException | MXException e) {
            throw new RuntimeException(e);
        }
    }
}

