/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.webclient.beans.notifyadm;

import com.interlocsolutions.maximo.notify.push.PushQueueManager;
import java.rmi.RemoteException;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.server.MXServerRemote;
import psdi.util.MXApplicationException;
import psdi.util.MXApplicationYesNoCancelException;
import psdi.util.MXException;
import psdi.webclient.system.beans.DataBean;

public class ManageDeviceDataBean
extends DataBean {
    protected MboSetRemote getMboSetRemote() throws MXException, RemoteException {
        MboSetRemote set = super.getMboSetRemote();
        if (set != null) {
            String notifynum = this.getParent().getMbo().getString("NOTIFYNUM");
            set.setWhere("profiles like '%|" + notifynum + "|%'");
        }
        return set;
    }

    public int deleteselected() throws RemoteException, MXException {
        MboSetRemote set = this.getMboSet();
        if (set != null && !set.isEmpty()) {
            if (this.getSelection().size() > 0) {
                MboRemote mbo = set.moveFirst();
                while (mbo != null) {
                    if (mbo.isSelected()) {
                        mbo.delete();
                    }
                    mbo = set.moveNext();
                }
            } else {
                this.creatingEvent.getWebClientSession().showMessageBox(this.creatingEvent, "informer", "noDeviceSelectedforDelete", null);
            }
        }
        this.refreshTable();
        return 1;
    }

    public int createasset() throws RemoteException, MXException {
        if (this.getMbo() != null) {
            if (!this.getMbo().isNull("ASSETID")) {
                throw new MXApplicationException("informer", "assetAlreadyExists");
            }
            UserInfo userInfo = this.getMbo().getUserInfo();
            if (userInfo.isInteractive()) {
                int userInput = MXApplicationYesNoCancelException.getUserInput((String)"informer.createasset()", (MXServerRemote)MXServer.getMXServer(), (UserInfo)userInfo);
                switch (userInput) {
                    case -1: {
                        throw new MXApplicationYesNoCancelException("informer.createasset()", "informer", "confirmAssetCreate");
                    }
                    case 8: {
                        break;
                    }
                    case 16: {
                        return 1;
                    }
                    case 4: {
                        return 1;
                    }
                }
            }
        }
        this.clientSession.loadDialog("createassetform");
        return 1;
    }

    public int reqinst() throws RemoteException, MXException {
        MboSetRemote set = this.getMboSet();
        boolean reqSent = false;
        if (set != null && !set.isEmpty()) {
            if (this.getSelection().size() > 0) {
                MboRemote mbo = set.moveFirst();
                while (mbo != null) {
                    if (mbo.isSelected()) {
                        mbo.setValue("INSTRUMENTREQPENDING", true);
                        MboSetRemote pushDeviceSet = mbo.getMboSet("PUSHDEVICE");
                        MboRemote dev = pushDeviceSet.moveFirst();
                        while (dev != null) {
                            if (dev.getString("PUSHREG.NOTIFY.NOTIFYNUM").equalsIgnoreCase(this.getParent().getMbo().getString("NOTIFYNUM"))) {
                                PushQueueManager.getInstance().addQueuedItem(dev.getUniqueIDValue(), PushQueueManager.PushType.INSTRUMENTATION);
                                reqSent = true;
                            }
                            dev = pushDeviceSet.moveNext();
                        }
                    }
                    mbo = set.moveNext();
                }
            } else {
                MboRemote mbo = this.getMbo();
                if (mbo != null) {
                    mbo.setValue("INSTRUMENTREQPENDING", true);
                    MboSetRemote pushDeviceSet = mbo.getMboSet("PUSHDEVICE");
                    MboRemote dev = pushDeviceSet.moveFirst();
                    while (dev != null) {
                        if (dev.getString("PUSHREG.NOTIFY.NOTIFYNUM").equalsIgnoreCase(this.getParent().getMbo().getString("NOTIFYNUM"))) {
                            PushQueueManager.getInstance().addQueuedItem(dev.getUniqueIDValue(), PushQueueManager.PushType.INSTRUMENTATION);
                            reqSent = true;
                        }
                        dev = pushDeviceSet.moveNext();
                    }
                }
            }
            if (reqSent) {
                this.creatingEvent.getWebClientSession().showMessageBox(this.creatingEvent, "informer", "instRequestSent", null);
            } else {
                this.creatingEvent.getWebClientSession().showMessageBox(this.creatingEvent, "informer", "instRequestQueued", null);
            }
        } else {
            this.creatingEvent.getWebClientSession().showMessageBox(this.creatingEvent, "informer", "noDeviceSelectedForRefresh", null);
        }
        this.refresh();
        return 1;
    }

    public int refresh() throws MXException, RemoteException {
        this.save();
        this.getMboSet().reset();
        this.refreshTable();
        this.app.getDataBean("log").reloadTable();
        this.app.getDataBean("sc").reloadTable();
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestscreenshot() throws MXException, RemoteException {
        block4: {
            this.refresh();
            DataBean logDataBean = this.app.getDataBean("sc");
            MboSetRemote logSet = logDataBean.getMboSet();
            String currentWhere = logSet.getWhere();
            try {
                logSet.setWhere("status = 'PENDING' and type = 'SCREENSHOT'");
                if (logSet.isEmpty()) {
                    MboRemote logRequest = logSet.add();
                    logRequest.setValue("STATUS", "PENDING");
                    logRequest.setValue("TYPE", "SCREENSHOT");
                    logRequest.setValue("REQUESTLOGDATE", MXServer.getMXServer().getDate());
                    this.refresh();
                    break block4;
                }
                throw new MXApplicationException("informer", "requestScreenshotPending");
            }
            finally {
                logSet.setWhere(currentWhere);
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestlog() throws MXException, RemoteException {
        block4: {
            this.refresh();
            DataBean logDataBean = this.app.getDataBean("log");
            MboSetRemote logSet = logDataBean.getMboSet();
            String currentWhere = logSet.getWhere();
            try {
                logSet.setWhere("status = 'PENDING' and type = 'LOG'");
                logSet.reset();
                if (logSet.isEmpty()) {
                    MboRemote logRequest = logSet.add();
                    logRequest.setValue("STATUS", "PENDING");
                    logRequest.setValue("TYPE", "LOG");
                    logRequest.setValue("REQUESTLOGDATE", MXServer.getMXServer().getDate());
                    this.refresh();
                    break block4;
                }
                throw new MXApplicationException("informer", "requestLogPending");
            }
            finally {
                logSet.setWhere(currentWhere);
            }
        }
        return 1;
    }

    public int applyloglevel() throws MXException, RemoteException {
        MboRemote device = this.getMbo();
        if (device != null) {
            device.setValue("LOGFETCHEDBYPOLL", false);
            MboSetRemote pushDeviceSet = device.getMboSet("PUSHDEVICE");
            if (!pushDeviceSet.isEmpty()) {
                MboRemote pushDevice = pushDeviceSet.moveFirst();
                while (pushDevice != null) {
                    if (pushDevice.getString("PUSHREG.NOTIFY.NOTIFYNUM").equalsIgnoreCase(this.getParent().getMbo().getString("NOTIFYNUM"))) {
                        PushQueueManager.getInstance().addQueuedItem(pushDevice.getUniqueIDValue(), PushQueueManager.PushType.LOG_LEVEL);
                    }
                    pushDevice = pushDeviceSet.moveNext();
                }
            }
            this.save();
        }
        this.clientSession.addWarning((MXException)new MXApplicationException("informer", "logLevelApplied"));
        return 1;
    }
}

