/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.webclient.beans.notify;

import com.interlocsolutions.maximo.notify.CatalogRemote;
import com.interlocsolutions.maximo.notify.NotifyRemote;
import com.interlocsolutions.maximo.notify.NotifyService;
import com.interlocsolutions.maximo.notify.classloader.InformerClassesService;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalFlags;
import com.interlocsolutions.maximo.notify.queue.notification.JobSpecUserExpand;
import com.interlocsolutions.maximo.notify.queue.notification.NotificationJobManager;
import com.interlocsolutions.maximo.notify.util.IOUtils;
import com.interlocsolutions.maximo.notify.util.InformerClassUtils;
import com.interlocsolutions.maximo.notify.util.InformerObjectSerializer;
import com.interlocsolutions.maximo.notify.util.License;
import com.interlocsolutions.maximo.notify.util.LicenseManager;
import com.interlocsolutions.maximo.notify.util.MboUtil;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.PropUtils;
import com.interlocsolutions.maximo.notify.util.codec.Base64;
import com.interlocsolutions.maximo.notify.xml.AppManifest;
import com.interlocsolutions.maximo.notify.xml.NotifyXMLUtils;
import com.interlocsolutions.maximo.notify.xml.export.NotifyExport;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.codec.binary.Base64OutputStream;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.server.MXServerRemote;
import psdi.util.MXApplicationException;
import psdi.util.MXApplicationYesNoCancelException;
import psdi.util.MXException;
import psdi.webclient.system.beans.AppBean;
import psdi.webclient.system.beans.DataBean;
import psdi.webclient.system.beans.ResultsBean;
import psdi.webclient.system.controller.ControlInstance;
import psdi.webclient.system.controller.MPFormData;
import psdi.webclient.system.controller.UploadFile;
import psdi.webclient.system.controller.WebClientEvent;
import psdi.webclient.system.session.WebClientSession;

public class NotifyAppBean
extends AppBean {
    private final NotificationJobManager notificationJobManager = NotificationJobManager.INSTANCE;
    private NotifyExport export = null;
    private String lastType = null;
    private String lastVersion = null;
    private long lastID = -1L;
    private String lastAppName = null;

    public int REFRESH() throws RemoteException, MXException {
        UserInfo userInfo = this.getMbo().getUserInfo();
        if (userInfo.isInteractive()) {
            int userInput = MXApplicationYesNoCancelException.getUserInput((String)"informer.REFRESH()", (MXServerRemote)MXServer.getMXServer(), (UserInfo)userInfo);
            switch (userInput) {
                case -1: {
                    throw new MXApplicationYesNoCancelException("informer.REFRESH()", "informer", "confirmRefresh");
                }
                case 8: {
                    break;
                }
                case 16: {
                    return 1;
                }
                case 4: {
                    return 1;
                }
            }
        }
        this.notificationJobManager.enqueue(new JobSpecUserExpand(this.getMbo().getUniqueIDValue()));
        ((NotifyService)MXServer.getMXServer().lookup("NOTIFY")).wakeQueue();
        DataBean table = this.app.getDataBean("active_notifications");
        if (table != null) {
            table.refreshTable();
        }
        return 1;
    }

    public int REPRELOAD() throws RemoteException, MXException {
        UserInfo userInfo = this.getMbo().getUserInfo();
        if (userInfo.isInteractive()) {
            int userInput = MXApplicationYesNoCancelException.getUserInput((String)"informer.REPRELOAD()", (MXServerRemote)MXServer.getMXServer(), (UserInfo)userInfo);
            switch (userInput) {
                case -1: {
                    throw new MXApplicationYesNoCancelException("informer.REPRELOAD()", "informer", "confirmPreRefresh");
                }
                case 8: {
                    break;
                }
                case 16: {
                    return 1;
                }
                case 4: {
                    return 1;
                }
            }
        }
        MboSetRemote catalogSet = this.getMbo().getMboSet("CATALOG");
        EvalContext evalContext = new EvalContext().setFlag(EvalFlags.USER_WAITING);
        MboRemote mbo = catalogSet.moveFirst();
        while (mbo != null) {
            CatalogRemote catalog = (CatalogRemote)mbo;
            if (catalog.getBoolean("PRELOAD")) {
                catalog.preload(evalContext);
            }
            mbo = catalogSet.moveNext();
        }
        catalogSet.save();
        String[] args = new String[]{""};
        this.creatingEvent.getWebClientSession().showMessageBox(this.creatingEvent, "informer", "preloadStarted", args);
        return 1;
    }

    public int INSERT() throws RemoteException, MXException {
        License lic = LicenseManager.INSTANCE.getLicense();
        if (lic == null || !lic.isValid()) {
            throw new MXApplicationException("informer", "invalidLicense");
        }
        return super.INSERT();
    }

    public int IMPORT() throws RemoteException, MXException {
        License lic = LicenseManager.INSTANCE.getLicense();
        if (lic == null || !lic.isValid()) {
            throw new MXApplicationException("informer", "invalidLicense");
        }
        if (this.resultsBean != null && !this.hasTableData && this.saveYesNoInteractionCheck()) {
            this.gotoTab(this.clientSession, "list");
            this.clientSession.loadDialog("import");
        }
        return 1;
    }

    public int importapplication() throws RemoteException, MXException {
        block45: {
            Object[] args;
            UserInfo userInfo = this.getMbo().getUserInfo();
            if (userInfo.isInteractive()) {
                int userInput = MXApplicationYesNoCancelException.getUserInput((String)"informer.importapplication()", (MXServerRemote)MXServer.getMXServer(), (UserInfo)userInfo);
                switch (userInput) {
                    case -1: {
                        break;
                    }
                    case 8: {
                        MboSetRemote appSet = this.getMXSession().getMboSet("ISAPPDEPLOY");
                        SqlFormat sqlf = new SqlFormat("notifyid = :1 and name = :2 and type = :3");
                        sqlf.setLong(1, this.getMbo().getUniqueIDValue());
                        sqlf.setObject(2, "ISAPPDEPLOY", "NAME", this.lastAppName);
                        sqlf.setObject(3, "ISAPPDEPLOY", "TYPE", this.lastType);
                        appSet.setWhere(sqlf.format());
                        appSet.reset();
                        MboRemote mbo = appSet.moveFirst();
                        while (mbo != null) {
                            mbo.setValue("ACTIVE", mbo.getUniqueIDValue() == this.lastID);
                            mbo = appSet.moveNext();
                        }
                        appSet.save();
                        String[] args2 = new String[]{this.lastType, this.lastAppName, this.lastVersion};
                        this.creatingEvent.getWebClientSession().showMessageBox(this.creatingEvent, "informer", "appimported", args2);
                        this.lastType = null;
                        this.lastVersion = null;
                        this.lastID = -1L;
                        this.lastAppName = null;
                        return 1;
                    }
                    case 16: {
                        String[] args3 = new String[]{this.lastType, this.lastAppName, this.lastVersion};
                        this.creatingEvent.getWebClientSession().showMessageBox(this.creatingEvent, "informer", "appimported", args3);
                        this.lastType = null;
                        this.lastVersion = null;
                        this.lastID = -1L;
                        this.lastAppName = null;
                        return 1;
                    }
                }
            }
            WebClientSession wcs = this.getCreator().getWebClientSession();
            WebClientEvent wce = wcs.getCurrentEvent();
            HttpServletRequest request = wcs.getRequest();
            MPFormData mpData = null;
            ZipFile zip = null;
            try {
                if (!MPFormData.isRequestMultipart((HttpServletRequest)request)) break block45;
                try {
                    ControlInstance uploadfileControl = wce.getSourceControlInstance();
                    String maxfilesize = uploadfileControl.getProperty("maxfilesize");
                    mpData = new MPFormData(request, Integer.parseInt(maxfilesize));
                }
                catch (MXException mxe) {
                    wcs.addWarning(mxe);
                }
                if (mpData != null) {
                    String fName = "";
                    fName = mpData.getFullFileName();
                    if (fName.equals("")) {
                        wcs.showMessageBox(wce, "jspmessages", "nouploadfile", null);
                        int maxfilesize = 0;
                        return maxfilesize;
                    }
                    UploadFile uf = new UploadFile(mpData.getFileName(), mpData.getFullFileName(), mpData.getFileContentType(), mpData.getFileOutputStream());
                    if (uf != null) {
                        if (!uf.getFileName().endsWith(".zip")) {
                            Object[] args4 = new String[]{uf.getFileName()};
                            throw new MXApplicationException("informer", "invalidAppFile", args4);
                        }
                        File tmpFile = File.createTempFile("appzip", ".zip");
                        uf.getFileOutputStream().writeTo(new FileOutputStream(tmpFile));
                        zip = new ZipFile(tmpFile);
                        ZipEntry ze = zip.getEntry("manifest.xml");
                        Enumeration<? extends ZipEntry> entries = zip.entries();
                        if (ze == null && (ze = zip.getEntry(".\\manifest.xml")) == null) {
                            Object[] args5 = new String[]{uf.getFileName()};
                            throw new MXApplicationException("informer", "missingManifest", args5);
                        }
                        AppManifest am = (AppManifest)NotifyXMLUtils.deserializeCustom(AppManifest.class, (Object)zip.getInputStream(ze), (InformerObjectSerializer.UnmarshallingPolicy)InformerObjectSerializer.UNMARSHAL_BASIC_STREAM);
                        entries = zip.entries();
                        String appDataB64 = null;
                        byte[] imgData = null;
                        byte[] profileData = null;
                        String appName = am.getName();
                        String type = null;
                        String releaseNotes = null;
                        String fileName = null;
                        if (appName == null || appName.trim().length() == 0) {
                            throw new MXApplicationException("informer", "missingAppName");
                        }
                        while (entries.hasMoreElements()) {
                            String line;
                            byte[] appData;
                            int length;
                            byte[] buffer;
                            ByteArrayOutputStream baos;
                            InputStream is;
                            String name;
                            ZipEntry entry = entries.nextElement();
                            if (entry.isDirectory() || (name = entry.getName()).startsWith(".") || name.contains("/") || name.contains("\\")) continue;
                            if (name.endsWith(".png")) {
                                is = zip.getInputStream(entry);
                                BufferedImage image = ImageIO.read(is);
                                ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
                                ImageIO.write((RenderedImage)this.resizeImage(image, 48, 48), "png", baos2);
                                imgData = baos2.toByteArray();
                                continue;
                            }
                            if (name.endsWith("ipa") && PropUtils.getBooleanMaxProp((String)"informer.deploy.streamapp", (boolean)false)) {
                                appDataB64 = this.fileToB64(zip, entry);
                                fileName = name;
                                type = "IOS";
                                continue;
                            }
                            if (name.endsWith("ipa")) {
                                is = zip.getInputStream(entry);
                                baos = new ByteArrayOutputStream();
                                buffer = new byte[1024];
                                length = 0;
                                while ((length = is.read(buffer)) != -1) {
                                    baos.write(buffer, 0, length);
                                }
                                appData = baos.toByteArray();
                                appDataB64 = Base64.encodeBase64String((byte[])appData);
                                fileName = name;
                                type = "IOS";
                                continue;
                            }
                            if (name.endsWith("apk") && PropUtils.getBooleanMaxProp((String)"informer.deploy.streamapp", (boolean)false)) {
                                appDataB64 = this.fileToB64(zip, entry);
                                fileName = name;
                                type = "ANDROID";
                                continue;
                            }
                            if (name.endsWith("apk")) {
                                is = zip.getInputStream(entry);
                                baos = new ByteArrayOutputStream();
                                buffer = new byte[1024];
                                length = 0;
                                while ((length = is.read(buffer)) != -1) {
                                    baos.write(buffer, 0, length);
                                }
                                appData = baos.toByteArray();
                                appDataB64 = Base64.encodeBase64String((byte[])appData);
                                fileName = name;
                                type = "ANDROID";
                                continue;
                            }
                            if (name.endsWith("mobileprovision")) {
                                is = zip.getInputStream(entry);
                                byte[] data = new byte[is.available()];
                                is.read(data);
                                profileData = data;
                                continue;
                            }
                            if (!name.endsWith(".html")) continue;
                            BufferedReader br = new BufferedReader(new InputStreamReader(zip.getInputStream(entry)));
                            StringBuffer sb = new StringBuffer();
                            while ((line = br.readLine()) != null) {
                                sb.append(line).append("\n");
                            }
                            releaseNotes = sb.toString();
                        }
                        if (appDataB64 == null) {
                            throw new MXApplicationException("informer", "missingApplication");
                        }
                        if (imgData == null) {
                            throw new MXApplicationException("informer", "missingIcon");
                        }
                        MboSetRemote appSet = this.getMXSession().getMboSet("ISAPPDEPLOY");
                        SqlFormat sqlf = new SqlFormat("notifyid = :1 and name = :2 and type = :3 and version = :4");
                        sqlf.setLong(1, this.getMbo().getUniqueIDValue());
                        sqlf.setObject(2, "ISAPPDEPLOY", "NAME", appName);
                        sqlf.setObject(3, "ISAPPDEPLOY", "TYPE", type);
                        sqlf.setInt(4, am.getVersion());
                        appSet.setWhere(sqlf.format());
                        appSet.reset();
                        MboRemote app = null;
                        if (appSet.isEmpty()) {
                            app = appSet.add();
                            app.setValue("NAME", appName);
                            app.setValue("TYPE", type);
                            app.setValue("NOTIFYID", this.getMbo().getUniqueIDValue());
                        } else {
                            app = appSet.getMbo(0);
                        }
                        app.setValue("VERSIONNAME", am.getVersionname());
                        app.setValue("BUNDLE", am.getBundle());
                        app.setValue("DESCRIPTION", am.getDescription());
                        app.setValue("TITLE", am.getTitle());
                        app.setValue("ICON", imgData);
                        app.setValue("APPLICATION", appDataB64);
                        app.setValue("PROVISIONPROFILE", profileData);
                        app.setValue("FILENAME", fileName);
                        app.setValue("VERSION", am.getVersion());
                        if (releaseNotes != null) {
                            app.setValue("DESCRIPTION_LONGDESCRIPTION", releaseNotes);
                        }
                        appSet.save();
                        this.lastType = type;
                        this.lastVersion = am.getVersionname();
                        this.lastID = app.getUniqueIDValue();
                        this.lastAppName = am.getName();
                        throw new MXApplicationYesNoCancelException("informer.importapplication()", "informer", "setUploadActive");
                    }
                }
            }
            catch (IOException e) {
                args = new String[]{e.getMessage()};
                throw new MXApplicationException("informer", "importJarError", args);
            }
            catch (JAXBException e) {
                args = new String[]{e.getMessage()};
                throw new MXApplicationException("informer", "importJarError", args);
            }
            catch (XMLStreamException e) {
                args = new String[]{e.getMessage()};
                throw new MXApplicationException("informer", "importJarError", args);
            }
            finally {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fileToB64(ZipFile zip, ZipEntry entry) throws IOException {
        String fileB64;
        File swapFile = File.createTempFile("fileextract", ".tmp");
        try {
            try (InputStream is = zip.getInputStream(entry);
                 Base64OutputStream b64SwapOut = new Base64OutputStream((OutputStream)new FileOutputStream(swapFile, false), true);){
                IOUtils.streamCopy((InputStream)is, (OutputStream)b64SwapOut, (int)1024);
            }
            StringWriter sw = new StringWriter();
            try (FileReader b64SwapIn = new FileReader(swapFile);){
                IOUtils.streamCopy((Reader)b64SwapIn, (Writer)sw, (int)1024);
                fileB64 = sw.toString();
            }
        }
        finally {
            swapFile.delete();
        }
        return fileB64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importcmd() throws RemoteException, MXException {
        block22: {
            InformerClassesService infClassSvc = InformerClassUtils.getInformerClassesServiceOrFail();
            WebClientSession wcs = this.getCreator().getWebClientSession();
            WebClientEvent wce = wcs.getCurrentEvent();
            HttpServletRequest request = wcs.getRequest();
            MPFormData mpData = null;
            Object commands = null;
            ZipFile jar = null;
            try {
                if (!MPFormData.isRequestMultipart((HttpServletRequest)request)) break block22;
                try {
                    ControlInstance uploadfileControl = wce.getSourceControlInstance();
                    String maxfilesize = uploadfileControl.getProperty("maxfilesize");
                    mpData = new MPFormData(request, Integer.parseInt(maxfilesize));
                }
                catch (MXException mxe) {
                    wcs.addWarning(mxe);
                }
                if (mpData == null) break block22;
                String fName = "";
                fName = mpData.getFullFileName();
                if (fName.equals("")) {
                    wcs.showMessageBox(wce, "jspmessages", "nouploadfile", null);
                    int maxfilesize = 0;
                    return maxfilesize;
                }
                UploadFile uf = new UploadFile(mpData.getFileName(), mpData.getFullFileName(), mpData.getFileContentType(), mpData.getFileOutputStream());
                if (uf == null) break block22;
                if (!uf.getFileName().endsWith(".jar")) {
                    Object[] args = new String[]{uf.getFileName()};
                    throw new MXApplicationException("informer", "invalidCmdJar", args);
                }
                File tmpFile = File.createTempFile("cmdjar", ".jar");
                try {
                    uf.getFileOutputStream().writeTo(new FileOutputStream(tmpFile));
                    jar = new JarFile(tmpFile);
                    JarEntry je = ((JarFile)jar).getJarEntry("META-INF/informer-commands.xml");
                    if (je == null && (je = ((JarFile)jar).getJarEntry("META-INF\\informer-commands.xml")) == null) {
                        Object[] args = new String[]{uf.getFileName()};
                        throw new MXApplicationException("informer", "invalidCmdJar", args);
                    }
                    SqlFormat sf = new SqlFormat("name = :1");
                    sf.setObject(1, "ISNOTIFYJARS", "NAME", uf.getFileName());
                    MboSetRemote jarsSet = this.getMXSession().getMboSet("ISNOTIFYJARS");
                    jarsSet.setWhere(sf.format());
                    MboRemote jarMbo = jarsSet.getMbo(0);
                    if (jarMbo == null) {
                        jarMbo = jarsSet.add();
                        jarMbo.setValue("NAME", uf.getFileName());
                        jarMbo.setValue("ACTIVE", true);
                        jarMbo.setValue("SEQUENCE", 1);
                    }
                    jarMbo.setValue("DATA", Files.readAllBytes(tmpFile.toPath()));
                    jarsSet.save();
                    String[] args = new String[]{uf.getFileName()};
                    this.clientSession.showMessageBox("informer", "importJarSuccess", args);
                }
                finally {
                    tmpFile.delete();
                }
            }
            catch (Exception e) {
                Object[] args = new String[]{e.getMessage()};
                throw new MXApplicationException("informer", "importJarError", args);
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importresource() throws RemoteException, MXException {
        block15: {
            MPFormData mpData;
            block16: {
                WebClientSession wcs = this.getCreator().getWebClientSession();
                WebClientEvent wce = wcs.getCurrentEvent();
                HttpServletRequest request = wcs.getRequest();
                mpData = null;
                if (!MPFormData.isRequestMultipart((HttpServletRequest)request)) break block15;
                try {
                    ControlInstance uploadfileControl = wce.getSourceControlInstance();
                    String maxfilesize = uploadfileControl.getProperty("maxfilesize");
                    mpData = new MPFormData(request, Integer.parseInt(maxfilesize));
                }
                catch (MXException mxe) {
                    wcs.addWarning(mxe);
                }
                if (mpData == null) break block15;
                String fName = "";
                fName = mpData.getFullFileName();
                if (!fName.equals("")) break block16;
                wcs.showMessageBox(wce, "jspmessages", "nouploadfile", null);
                int maxfilesize = 0;
                return maxfilesize;
            }
            try {
                UploadFile uf = new UploadFile(mpData.getFileName(), mpData.getFullFileName(), mpData.getFileContentType(), mpData.getFileOutputStream());
                if (uf != null) {
                    DataBean resourcesBean = this.clientSession.getDataBean("resources");
                    if (resourcesBean != null) {
                        String fn;
                        resourcesBean.addrow();
                        String name = fn = uf.getFileName();
                        String extension = null;
                        if (name.contains(".")) {
                            int indexOfDot = name.lastIndexOf(".");
                            extension = name.substring(indexOfDot + 1);
                            name = name.substring(0, indexOfDot);
                        }
                        MboRemote mbo = resourcesBean.getMbo();
                        mbo.setValue("NAME", name);
                        if (extension != null && !extension.trim().isEmpty()) {
                            mbo.setValue("EXTENSION", extension);
                        }
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        uf.getFileOutputStream().writeTo(baos);
                        String fnLower = fn.toLowerCase();
                        if (fnLower.endsWith("jpg") || fnLower.endsWith("jpeg") || fnLower.endsWith("bmp") || fnLower.endsWith("png") || fnLower.endsWith("gif")) {
                            mbo.setValue("RESOURCETYPE", "IMAGE");
                        } else if (fnLower.endsWith("txt") || fnLower.endsWith("doc") || fnLower.endsWith("docx") || fnLower.endsWith("pdf") || fnLower.endsWith("rtf")) {
                            mbo.setValue("RESOURCETYPE", "DOCUMENT");
                        } else {
                            mbo.setValue("RESOURCETYPE", "OTHER");
                        }
                        mbo.setValue("NOTIFYID", this.app.getAppBean().getMbo().getUniqueIDValue());
                        mbo.setValue("DATA", Base64.encodeBase64String((byte[])baos.toByteArray()));
                    }
                    String[] args = new String[]{uf.getFileName()};
                    this.clientSession.showMessageBox("informer", "importJarSuccess", args);
                }
            }
            catch (IOException e) {
                NotifyConstants.INFORMER_LOGGER.error((Object)e);
            }
        }
        return 1;
    }

    private BufferedImage resizeImage(Image originalImage, int scaledWidth, int scaledHeight) {
        int imageType = 2;
        BufferedImage scaledBI = new BufferedImage(scaledWidth, scaledHeight, imageType);
        Graphics2D g = scaledBI.createGraphics();
        g.drawImage(originalImage, 0, 0, scaledWidth, scaledHeight, null);
        g.dispose();
        return scaledBI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importcfg() throws RemoteException, MXException {
        block31: {
            WebClientSession wcs = this.getCreator().getWebClientSession();
            WebClientEvent wce = wcs.getCurrentEvent();
            HttpServletRequest request = wcs.getRequest();
            UserInfo userInfo = this.clientSession.getUserInfo();
            MPFormData mpData = null;
            if (userInfo.isInteractive()) {
                int userInput = MXApplicationYesNoCancelException.getUserInput((String)"informer.importcfg()", (MXServerRemote)MXServer.getMXServer(), (UserInfo)userInfo);
                switch (userInput) {
                    case -1: {
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 16: {
                        return 1;
                    }
                    case 4: {
                        return 1;
                    }
                }
            }
            try {
                if (MPFormData.isRequestMultipart((HttpServletRequest)request)) {
                    try {
                        ControlInstance uploadfileControl = wce.getSourceControlInstance();
                        String maxfilesize = uploadfileControl.getProperty("maxfilesize");
                        mpData = new MPFormData(request, Integer.parseInt(maxfilesize));
                    }
                    catch (MXException mxe) {
                        wcs.addWarning(mxe);
                    }
                    if (mpData != null) {
                        String fName = "";
                        fName = mpData.getFullFileName();
                        if (fName.equals("")) {
                            wcs.showMessageBox(wce, "jspmessages", "nouploadfile", null);
                            return 0;
                        }
                        UploadFile uf = new UploadFile(mpData.getFileName(), mpData.getFullFileName(), mpData.getFileContentType(), mpData.getFileOutputStream());
                        if (uf != null) {
                            String s = new String(uf.getFileOutputStream().toByteArray());
                            this.export = (NotifyExport)InformerObjectSerializer.getInstance().deserialize((Reader)new StringReader(s));
                            List commands = this.export.getCommands();
                            if (commands != null) {
                                MboSetRemote commandSet;
                                block30: {
                                    commandSet = null;
                                    try {
                                        commandSet = this.getMXSession().getMboSet("ISNOTIFYCOMMAND");
                                        String results = null;
                                        for (String command : commands) {
                                            SqlFormat cSqlf = new SqlFormat("name = :1");
                                            cSqlf.setObject(1, "ISNOTIFYCOMMAND", "NAME", command);
                                            commandSet.setWhere(cSqlf.format());
                                            commandSet.reset();
                                            if (!commandSet.isEmpty()) continue;
                                            results = results == null ? command : results + "\n" + command;
                                        }
                                        if (results == null) break block30;
                                        Object[] args = new String[]{results};
                                        throw new MXApplicationYesNoCancelException("informer.importcfg()", "informer", "commandDoesNotExist", args);
                                    }
                                    catch (Throwable throwable) {
                                        NotifyUtil.closeAndCleanup(commandSet);
                                        throw throwable;
                                    }
                                }
                                NotifyUtil.closeAndCleanup((MboSetRemote)commandSet);
                            }
                        }
                    }
                }
                if (this.export == null) break block31;
                this.export.validate();
                ResultsBean resultsBean = this.app.getResultsBean();
                this.gotoTab(this.clientSession, "list");
                resultsBean.clearBean();
                resultsBean.setQbe("NOTIFYNUM", "=" + this.export.getNotifynum());
                resultsBean.reset();
                if (resultsBean.isEmpty()) {
                    this.INSERT();
                } else {
                    this.gotoTab(this.clientSession, "insert");
                }
                NotifyRemote notify = (NotifyRemote)this.getMbo();
                try {
                    notify.importConfiguration(this.export);
                    if (this.hasSaveAccess()) {
                        WebClientEvent event = this.clientSession.getCurrentEvent();
                        this.save();
                        this.clientSession.showMessageBox(event, "system", "saverecord", (String[])null);
                    }
                }
                catch (MXException e) {
                    NotifyConstants.INFORMER_LOGGER.error((Object)e);
                    if (this.isNewRow()) {
                        this.delete();
                    }
                    this.reset();
                    this.gotoTab(this.clientSession, "list");
                    wcs.addWarning(e);
                    this.getResultsBean().reset();
                }
                DataBean table = this.app.getDataBean("active_notifications");
                if (table != null) {
                    table.refreshTable();
                }
                this.export = null;
            }
            catch (MXApplicationYesNoCancelException e) {
                throw e;
            }
            catch (MXException e) {
                wcs.addWarning(e);
                return 0;
            }
            catch (RemoteException e) {
                NotifyConstants.INFORMER_LOGGER.error((Object)e);
            }
            catch (JAXBException e) {
                NotifyConstants.INFORMER_LOGGER.error((Object)e);
                throw new MXApplicationException("informer", "invalidConfigFormat");
            }
            catch (XMLStreamException e) {
                NotifyConstants.INFORMER_LOGGER.error((Object)e);
                throw new MXApplicationException("informer", "invalidConfigFormat");
            }
        }
        return 1;
    }

    public int EXPORT() throws RemoteException, MXException {
        String exportUrl = this.clientSession.getContextPath();
        try {
            if (this.saveYesNoCheck()) {
                this.SAVE();
                exportUrl = exportUrl + "/notifyexport/" + this.getMbo().getString("NOTIFYNUM") + ".xml?id=" + this.getMbo().getUniqueIDValue();
                this.app.openURL(exportUrl, true, "_download", null);
            }
        }
        catch (MXException mxe) {
            this.clientSession.showMessageBox(mxe);
        }
        return 1;
    }

    public int ACTIVATE() throws RemoteException, MXException {
        DataBean appBean = this.app.getAppBean();
        if (appBean.getBoolean("ACTIVE")) {
            Object[] args = new String[]{appBean.getString("NOTIFYNUM")};
            throw new MXApplicationException("informer", "appActive", args);
        }
        if (appBean.toBeSaved()) {
            throw new MXApplicationException("informer", "mustSaveProfileBeforeUse");
        }
        if (appBean.getMbo() != null) {
            EvalContext evalContext = new EvalContext().setFlag(EvalFlags.USER_WAITING).setFlag(EvalFlags.PROFILE_ACTIVATION);
            SqlFormat sqlf = new SqlFormat(appBean.getMbo(), "notifyid = :notifyid");
            boolean[] foundNotInitialized = new boolean[]{false};
            MboUtil.visitMbosReadOnly((UserInfo)MXServer.getMXServer().getSystemUserInfo(), (String)"ISCATALOG", (String)sqlf.format(), catalog -> {
                if (!catalog.getBoolean("INITIALIZED")) {
                    if ("ISPROPERTIES".equalsIgnoreCase(catalog.getString("CATALOG"))) {
                        ((CatalogRemote)catalog).initCatalog(evalContext.duplicate());
                    } else {
                        foundNotInitialized[0] = true;
                    }
                }
            });
            if (foundNotInitialized[0]) {
                WebClientEvent event = new WebClientEvent("cataloginitialize", this.app.getCurrentPageId(), null, this.clientSession);
                this.clientSession.queueEvent(event);
            } else {
                String noReconcileProp = MXServer.getMXServer().getProperty("informer.dev.noreconcileonactivation");
                boolean skipReconcile = "true".equalsIgnoreCase(noReconcileProp) || "1".equals(noReconcileProp);
                MboUtil.visitMbosReadOnly((UserInfo)MXServer.getMXServer().getSystemUserInfo(), (String)"ISCATALOG", (String)sqlf.format(), catalog -> {
                    if (!skipReconcile && catalog instanceof CatalogRemote) {
                        ((CatalogRemote)catalog).reload(evalContext.duplicate());
                    }
                });
                appBean.getMbo().setValue("ACTIVE", true, 2L);
                this.SAVE();
            }
        }
        return 1;
    }

    public int DEACTIVATE() throws RemoteException, MXException {
        DataBean appBean = this.app.getAppBean();
        if (!appBean.getBoolean("ACTIVE")) {
            Object[] args = new String[]{appBean.getString("NOTIFYNUM")};
            throw new MXApplicationException("informer", "appNotActive", args);
        }
        appBean.getMbo().setValue("ACTIVE", false, 2L);
        appBean.getMbo().setFlag(7L, false);
        appBean.refreshTable();
        this.SAVE();
        return 1;
    }

    public int GENSQLITE() throws RemoteException, MXException {
        DataBean appBean = this.app.getAppBean();
        MboSetRemote catalogs = appBean.getMbo().getMboSet("$cataloginit", "ISCATALOG", "notifyid = :notifyid and catalog != 'ISPROPERTIES' and initialized = 0");
        catalogs.reset();
        if (!catalogs.isEmpty()) {
            Object[] args = new String[]{appBean.getString("NOTIFYNUM")};
            throw new MXApplicationException("informer", "genSqlNotInitialized", args);
        }
        if (!appBean.getBoolean("GENERATESQLITE")) {
            throw new MXApplicationException("informer", "notGenerateSqlite");
        }
        ((NotifyRemote)this.app.getAppBean().getMbo()).queueSqlDatabaseGeneration();
        this.creatingEvent.getWebClientSession().showMessageBox("informer", "queuedGenerateSqlite", new String[0]);
        return 1;
    }
}

