/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.webclient.beans.notify;

import com.interlocsolutions.maximo.notify.CatalogRemote;
import com.interlocsolutions.maximo.notify.NotifyService;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalFlags;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import java.rmi.RemoteException;
import java.util.Vector;
import psdi.mbo.MboRemote;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.webclient.system.beans.DataBean;
import psdi.webclient.system.session.WebClientSession;

public class BaseCatalogDataBean
extends DataBean {
    public int toggledeleterow() throws MXException {
        try {
            if (this.app.getAppBean().getBoolean("ACTIVE")) {
                throw new MXApplicationException("informer", "cannotDeleteWhileActive");
            }
            if (this.getMbo() != null && "ISPROPERTIES".equals(this.getMbo().getString("CATALOG"))) {
                throw new MXApplicationException("informer", "syspropnodelete");
            }
            return super.toggledeleterow();
        }
        catch (RemoteException e) {
            return super.toggledeleterow();
        }
    }

    public int genpreload() throws RemoteException, MXException {
        if (this.app.getAppBean().toBeSaved()) {
            throw new MXApplicationException("informer", "mustSaveProfileBeforeUse");
        }
        Vector selected = this.getSelection();
        if (selected.isEmpty()) {
            throw new MXApplicationException("informer", "needCatalogSelectedPregen");
        }
        EvalContext evalContext = new EvalContext().setFlag(EvalFlags.USER_WAITING);
        for (MboRemote mbo : selected) {
            CatalogRemote catalog = (CatalogRemote)mbo;
            if (catalog == null || !catalog.getBoolean("PRELOAD")) continue;
            catalog.preload(evalContext);
            catalog.getThisMboSet().save();
            String[] param = new String[]{catalog.getString("CATALOG")};
            this.creatingEvent.getWebClientSession().showMessageBox(this.creatingEvent, "informer", "catalogPreloaded", param);
        }
        this.wakeCatalogQueue();
        this.refreshTable();
        return 1;
    }

    public int initcatalog() throws RemoteException, MXException {
        if (this.app.getAppBean().toBeSaved()) {
            throw new MXApplicationException("informer", "mustSaveProfileBeforeUse");
        }
        if (this.app.getAppBean().getBoolean("ACTIVE")) {
            throw new MXApplicationException("informer", "cannotInitActiveCat");
        }
        Vector selected = this.getSelection();
        if (selected.isEmpty()) {
            throw new MXApplicationException("informer", "needCatalogSelectedInit");
        }
        for (Object catalog : selected) {
            if (!catalog.getBoolean("INITIALIZED")) continue;
            catalog.setValue("INITIALIZED", false);
        }
        this.save();
        EvalContext evalContext = new EvalContext().setFlag(EvalFlags.USER_WAITING);
        for (MboRemote mbo : selected) {
            CatalogRemote catalog;
            if (!(mbo instanceof CatalogRemote) || "ISPROPERTIES".equals((catalog = (CatalogRemote)mbo).getString("CATALOG"))) continue;
            catalog.initCatalog(evalContext);
        }
        if (this.toBeSaved()) {
            this.save();
        }
        this.wakeCatalogQueue();
        WebClientSession wcs = this.getCreator().getWebClientSession();
        String[] param = new String[]{};
        wcs.showMessageBox(this.creatingEvent, "informer", "catalogInitStarted", param);
        return 1;
    }

    public int refresh() throws MXException, RemoteException {
        if (this.app.getAppBean().toBeSaved()) {
            throw new MXApplicationException("informer", "mustSaveProfileBeforeUse");
        }
        this.getMboSet().reset();
        this.refreshTable();
        DataBean bean = this.app.getDataBean("1322004814515");
        if (bean != null) {
            bean.reset();
            bean.refreshTable();
        }
        return 1;
    }

    public int reloadcatalog() throws MXException, RemoteException {
        if (this.app.getAppBean().toBeSaved()) {
            throw new MXApplicationException("informer", "mustSaveProfileBeforeUse");
        }
        WebClientSession wcs = this.getCreator().getWebClientSession();
        Vector selected = this.getSelection();
        if (selected.isEmpty()) {
            throw new MXApplicationException("informer", "needCatalogSelectedReload");
        }
        EvalContext evalContext = new EvalContext().setFlag(EvalFlags.USER_WAITING);
        for (MboRemote mbo : selected) {
            CatalogRemote catalog = (CatalogRemote)mbo;
            if (catalog == null) continue;
            catalog.reload(evalContext);
            catalog.getThisMboSet().save();
            String[] param = new String[]{catalog.getString("CATALOG")};
            wcs.showMessageBox(this.creatingEvent, "informer", "catalogReloaded", param);
        }
        this.wakeCatalogQueue();
        this.refreshTable();
        return 1;
    }

    public int addrow() throws MXException {
        try {
            if (this.app.getAppBean().getBoolean("ACTIVE")) {
                throw new MXApplicationException("informer", "cannotAddWhileActive");
            }
        }
        catch (RemoteException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)("Remote Error:" + e.getMessage()), (Throwable)e);
        }
        return super.addrow();
    }

    protected void wakeCatalogQueue() throws MXException {
        try {
            NotifyService notify = (NotifyService)MXServer.getMXServer().lookup("NOTIFY");
            if (notify != null) {
                notify.wakeCatalogQueue();
            }
        }
        catch (RemoteException e) {
            throw new MXApplicationException("system", "remoteError", (Throwable)e);
        }
    }
}

