/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LongAccumulator {
    private final int chunkSize;
    private final Deque<long[]> chunkList = new LinkedList<long[]>();
    private long[] finalChunk;
    private int finalChunkIdx;

    public LongAccumulator(long[] startingValues, int chunkSize) {
        this(chunkSize);
        for (long value : startingValues) {
            this.add(value);
        }
    }

    public LongAccumulator(int chunkSize) {
        this.chunkSize = chunkSize;
        this.finalChunk = new long[this.chunkSize];
        this.finalChunkIdx = 0;
        this.chunkList.addLast(this.finalChunk);
    }

    public void add(long value) {
        this.finalChunk[this.finalChunkIdx++] = value;
        if (this.finalChunkIdx == this.chunkSize) {
            this.finalChunk = new long[this.chunkSize];
            this.chunkList.addLast(this.finalChunk);
            this.finalChunkIdx = 0;
        }
    }

    public Iterator<Long> flushToIterator() {
        return new SingleUseLongIterator(this.flushToPrimitiveIterator());
    }

    @NotNull
    private SingleUsePrimitiveLongIterator flushToPrimitiveIterator() {
        return new SingleUsePrimitiveLongIterator();
    }

    public long[] flushToArray() {
        int i;
        long[] fullChunk;
        this.chunkList.removeLast();
        int totalCount = this.chunkList.size() * this.chunkSize + this.finalChunkIdx;
        long[] result = new long[totalCount];
        int destIdx = 0;
        while ((fullChunk = this.chunkList.pollFirst()) != null) {
            for (i = 0; i < this.chunkSize; ++i) {
                result[destIdx++] = fullChunk[i];
            }
        }
        for (i = 0; i < this.finalChunkIdx; ++i) {
            result[destIdx++] = this.finalChunk[i];
        }
        this.finalChunk = null;
        if (destIdx != totalCount) {
            throw new RuntimeException("Logic error; Counts do not match");
        }
        return result;
    }

    public long[] flushToSortedArray() {
        long[] result = this.flushToArray();
        Arrays.sort(result);
        return result;
    }

    public long[] flushToUniqueSortedArray() {
        long[] result;
        long[] source = this.flushToSortedArray();
        long[] dest = null;
        int destIdx = 0;
        long previousValue = 0L;
        for (int i = 0; i < source.length; ++i) {
            long thisValue = source[i];
            if (i > 0 && thisValue == previousValue) {
                if (dest == null) {
                    dest = new long[source.length];
                    System.arraycopy(source, 0, dest, 0, i);
                    destIdx = i;
                }
            } else if (dest != null) {
                dest[destIdx++] = thisValue;
            }
            previousValue = thisValue;
        }
        int sourceLength = source.length;
        if (dest == null) {
            result = source;
        } else {
            source = null;
            result = Arrays.copyOf(dest, destIdx);
        }
        return result;
    }

    static /* synthetic */ long[] access$202(LongAccumulator x0, long[] x1) {
        x0.finalChunk = x1;
        return x1;
    }

    private class SingleUseLongIterator
    implements Iterator<Long> {
        private SingleUsePrimitiveLongIterator wrappedItr;

        public SingleUseLongIterator(SingleUsePrimitiveLongIterator wrappedItr) {
            this.wrappedItr = wrappedItr;
        }

        @Override
        public boolean hasNext() {
            return this.wrappedItr.hasNext();
        }

        @Override
        public Long next() {
            return this.wrappedItr.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private class SingleUsePrimitiveLongIterator {
        @Nullable
        private long[] currentFullChunk;
        private int idx;

        public SingleUsePrimitiveLongIterator() {
            LongAccumulator.this.chunkList.removeLast();
            if (LongAccumulator.this.finalChunkIdx == 0) {
                LongAccumulator.access$202(LongAccumulator.this, null);
            }
            this.currentFullChunk = (long[])LongAccumulator.this.chunkList.pollFirst();
            this.idx = 0;
        }

        boolean hasNext() {
            return LongAccumulator.this.finalChunk != null || this.currentFullChunk != null;
        }

        public long next() {
            long nextValue;
            if (this.currentFullChunk != null) {
                nextValue = this.currentFullChunk[this.idx++];
                if (this.idx == LongAccumulator.this.chunkSize) {
                    this.currentFullChunk = (long[])LongAccumulator.this.chunkList.pollFirst();
                    this.idx = 0;
                }
            } else if (LongAccumulator.this.finalChunk != null) {
                nextValue = LongAccumulator.this.finalChunk[this.idx++];
                if (this.idx == LongAccumulator.this.finalChunkIdx) {
                    LongAccumulator.access$202(LongAccumulator.this, null);
                }
            } else {
                throw new NoSuchElementException("End of stream");
            }
            return nextValue;
        }
    }
}

