/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.util.LongAccumulator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class ImmutableLongSet
implements Iterable<Long> {
    @NotNull
    private final long[] sortedUniqueArray;

    protected ImmutableLongSet(@NotNull long[] sortedUniqueArray) {
        this.sortedUniqueArray = sortedUniqueArray;
    }

    public boolean contains(long value) {
        return Arrays.binarySearch(this.sortedUniqueArray, value) >= 0;
    }

    public long size() {
        return this.sortedUniqueArray.length;
    }

    public boolean isEmpty() {
        return this.sortedUniqueArray.length < 1;
    }

    public long[] asArray() {
        return Arrays.copyOf(this.sortedUniqueArray, this.sortedUniqueArray.length);
    }

    public ImmutableLongSet union(ImmutableLongSet other) {
        long[] thisArray = this.sortedUniqueArray;
        int thisIdx = 0;
        long[] thatArray = other.sortedUniqueArray;
        int thatIdx = 0;
        if (thisArray.length < 1) {
            return new ImmutableLongSet(thatArray);
        }
        if (thatArray.length < 1) {
            return new ImmutableLongSet(thisArray);
        }
        LongAccumulator mergedList = new LongAccumulator(1024);
        while (thisIdx < thisArray.length) {
            if (thatIdx < thatArray.length) {
                if (thisArray[thisIdx] < thatArray[thatIdx]) {
                    mergedList.add(thisArray[thisIdx]);
                    ++thisIdx;
                    continue;
                }
                if (thisArray[thisIdx] > thatArray[thatIdx]) {
                    mergedList.add(thatArray[thatIdx]);
                    ++thatIdx;
                    continue;
                }
                mergedList.add(thisArray[thisIdx]);
                ++thisIdx;
                ++thatIdx;
                continue;
            }
            mergedList.add(thisArray[thisIdx]);
            ++thisIdx;
        }
        while (thatIdx < thatArray.length) {
            mergedList.add(thatArray[thatIdx]);
            ++thatIdx;
        }
        return new ImmutableLongSet(mergedList.flushToArray());
    }

    public ImmutableLongSet intersection(ImmutableLongSet other) {
        long[] thisArray = this.sortedUniqueArray;
        int thisIdx = 0;
        long[] thatArray = other.sortedUniqueArray;
        int thatIdx = 0;
        if (thisArray.length < 1) {
            return new ImmutableLongSet(thisArray);
        }
        if (thatArray.length < 1) {
            return new ImmutableLongSet(thatArray);
        }
        LongAccumulator mergedList = new LongAccumulator(1024);
        while (thisIdx < thisArray.length && thatIdx < thatArray.length) {
            if (thatArray[thatIdx] < thisArray[thisIdx]) {
                ++thatIdx;
                continue;
            }
            if (thisArray[thisIdx] < thatArray[thatIdx]) {
                ++thisIdx;
                continue;
            }
            mergedList.add(thisArray[thisIdx]);
            ++thisIdx;
            ++thatIdx;
        }
        return new ImmutableLongSet(mergedList.flushToArray());
    }

    public ImmutableLongSet minus(ImmutableLongSet other) {
        long[] thisArray = this.sortedUniqueArray;
        int thisIdx = 0;
        long[] thatArray = other.sortedUniqueArray;
        int thatIdx = 0;
        if (thatArray.length < 1) {
            return new ImmutableLongSet(thisArray);
        }
        if (thisArray.length < 1) {
            return new ImmutableLongSet(thisArray);
        }
        LongAccumulator mergedList = new LongAccumulator(1024);
        while (thisIdx < thisArray.length && thatIdx < thatArray.length) {
            if (thatArray[thatIdx] < thisArray[thisIdx]) {
                ++thatIdx;
                continue;
            }
            if (thisArray[thisIdx] < thatArray[thatIdx]) {
                mergedList.add(thisArray[thisIdx]);
                ++thisIdx;
                continue;
            }
            ++thisIdx;
            ++thatIdx;
        }
        while (thisIdx < thisArray.length) {
            mergedList.add(thisArray[thisIdx]);
            ++thisIdx;
        }
        return new ImmutableLongSet(mergedList.flushToArray());
    }

    @Override
    public Iterator<Long> iterator() {
        return new LongIterator();
    }

    public String toString() {
        if (this.sortedUniqueArray.length == 0) {
            return String.format("%1$s(empty)", this.getClass().getSimpleName());
        }
        return String.format("%1$s(%2$d values, from %3$d to %4$d)", this.getClass().getSimpleName(), this.sortedUniqueArray.length, this.sortedUniqueArray[0], this.sortedUniqueArray[this.sortedUniqueArray.length - 1]);
    }

    private class LongIterator
    implements Iterator<Long> {
        int idx = 0;

        private LongIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.idx < ImmutableLongSet.this.sortedUniqueArray.length;
        }

        @Override
        public Long next() {
            if (this.idx < ImmutableLongSet.this.sortedUniqueArray.length) {
                return ImmutableLongSet.this.sortedUniqueArray[this.idx++];
            }
            throw new NoSuchElementException("End of stream");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    public static class Builder {
        private final LongAccumulator valueAccumulator = new LongAccumulator(1024);

        public Builder() {
            this(1024);
        }

        public Builder(int chunkSize) {
        }

        public void add(long value) {
            this.valueAccumulator.add(value);
        }

        public ImmutableLongSet build() {
            return new ImmutableLongSet(this.valueAccumulator.flushToUniqueSortedArray());
        }
    }
}

