/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.xml.export;

import com.interlocsolutions.maximo.notify.util.MboUtilKt;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.xml.export.NotifyAssociatedApplicationExport;
import com.interlocsolutions.maximo.notify.xml.export.NotifyAttributeExport;
import com.interlocsolutions.maximo.notify.xml.export.NotifyCatalogAttributeExport;
import com.interlocsolutions.maximo.notify.xml.export.NotifyCatalogExport;
import com.interlocsolutions.maximo.notify.xml.export.NotifyCustomPropExport;
import com.interlocsolutions.maximo.notify.xml.export.NotifyGroupExport;
import com.interlocsolutions.maximo.notify.xml.export.NotifyObjectExport;
import com.interlocsolutions.maximo.notify.xml.export.NotifyOptionExport;
import com.interlocsolutions.maximo.notify.xml.export.NotifyProperty;
import com.interlocsolutions.maximo.notify.xml.export.ObjectComparator;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

@XmlRootElement(name="notify", namespace="http://www.interlocsolutions.com/maximo/notify")
@XmlType(propOrder={"notifynum", "description", "app", "clauseName", "clauseDescription", "clauseValue", "processName", "altTrigRoot", "version", "applications", "objects", "catalogs", "commands", "anonCommands", "properties", "options", "groups", "customProps", "gensqlite", "anonaccess", "anonuser"}, namespace="http://www.interlocsolutions.com/maximo/notify")
public class NotifyExport {
    private String notifynum = null;
    private String description = null;
    private String app = null;
    private String clauseName = null;
    private String clauseValue = null;
    private String clauseDescription = null;
    private String processName = null;
    private String altTrigRoot = null;
    private String version = null;
    private boolean gensqlite = false;
    private boolean anonaccess = false;
    private String anonuser = null;
    private List<NotifyObjectExport> objects = new LinkedList<NotifyObjectExport>();
    private List<NotifyCatalogExport> catalogs = new LinkedList<NotifyCatalogExport>();
    private List<NotifyProperty> properties = new LinkedList<NotifyProperty>();
    private List<NotifyOptionExport> options = new LinkedList<NotifyOptionExport>();
    private List<NotifyCustomPropExport> customProps = new LinkedList<NotifyCustomPropExport>();
    private List<NotifyGroupExport> groups = new LinkedList<NotifyGroupExport>();
    private List<String> commands = new LinkedList<String>();
    private List<String> anonCommands = new LinkedList<String>();
    private List<NotifyAssociatedApplicationExport> applications = new LinkedList<NotifyAssociatedApplicationExport>();

    @XmlElement(name="notifynum", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getNotifynum() {
        return this.notifynum;
    }

    public void setNotifynum(String notifynum) {
        this.notifynum = notifynum;
    }

    @XmlElement(name="alttrigroot", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getAltTrigRoot() {
        return this.altTrigRoot;
    }

    public void setAltTrigRoot(String altTrigRoot) {
        this.altTrigRoot = altTrigRoot;
    }

    @XmlElement(name="description", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElement(name="app", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    @XmlElement(name="clausename", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getClauseName() {
        return this.clauseName;
    }

    public void setClauseName(String clauseName) {
        this.clauseName = clauseName;
    }

    @XmlElementWrapper(name="commands", namespace="http://www.interlocsolutions.com/maximo/notify")
    @XmlElement(name="command", namespace="http://www.interlocsolutions.com/maximo/notify")
    public List<String> getCommands() {
        Collections.sort(this.commands);
        return this.commands;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    public void addCommand(String command) {
        this.commands.add(command);
    }

    @XmlElementWrapper(name="anonymouscommands", namespace="http://www.interlocsolutions.com/maximo/notify")
    @XmlElement(name="command", namespace="http://www.interlocsolutions.com/maximo/notify")
    public List<String> getAnonCommands() {
        Collections.sort(this.anonCommands);
        return this.anonCommands;
    }

    public void setAnonCommands(List<String> commands) {
        this.anonCommands = commands;
    }

    public void addAnonCommand(String command) {
        this.anonCommands.add(command);
    }

    @XmlElementWrapper(name="properties", namespace="http://www.interlocsolutions.com/maximo/notify")
    @XmlElement(name="property", namespace="http://www.interlocsolutions.com/maximo/notify")
    public List<NotifyProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<NotifyProperty> properties) {
        this.properties = properties;
    }

    public void addProperty(NotifyProperty property) {
        this.properties.add(property);
    }

    @XmlElementWrapper(name="objects", namespace="http://www.interlocsolutions.com/maximo/notify")
    @XmlElement(name="object", namespace="http://www.interlocsolutions.com/maximo/notify")
    public List<NotifyObjectExport> getObjects() {
        Collections.sort(this.objects, new ObjectComparator());
        return this.objects;
    }

    public void setObjects(List<NotifyObjectExport> objects) {
        this.objects = objects;
    }

    public void addObject(NotifyObjectExport object) {
        this.objects.add(object);
    }

    @XmlElementWrapper(name="catalogs", namespace="http://www.interlocsolutions.com/maximo/notify")
    @XmlElement(name="catalog", namespace="http://www.interlocsolutions.com/maximo/notify")
    @NotNull
    public List<NotifyCatalogExport> getCatalogs() {
        if (this.catalogs == null) {
            this.catalogs = new ArrayList<NotifyCatalogExport>();
        }
        return this.catalogs;
    }

    public void setCatalogs(List<NotifyCatalogExport> catalogs) {
        this.catalogs = catalogs;
    }

    @XmlElementWrapper(name="options", namespace="http://www.interlocsolutions.com/maximo/notify")
    @XmlElement(name="option", namespace="http://www.interlocsolutions.com/maximo/notify")
    public List<NotifyOptionExport> getOptions() {
        return this.options;
    }

    public void setOptions(List<NotifyOptionExport> options) {
        this.options = options;
    }

    public void addOption(NotifyOptionExport option) {
        this.options.add(option);
    }

    @XmlElementWrapper(name="customprops", namespace="http://www.interlocsolutions.com/maximo/notify")
    @XmlElement(name="customprop", namespace="http://www.interlocsolutions.com/maximo/notify")
    public List<NotifyCustomPropExport> getCustomProps() {
        return this.customProps;
    }

    public void setCustomProps(List<NotifyCustomPropExport> customProps) {
        this.customProps = customProps;
    }

    public void addCustomProp(NotifyCustomPropExport customProp) {
        this.customProps.add(customProp);
    }

    @XmlElementWrapper(name="groups", namespace="http://www.interlocsolutions.com/maximo/notify")
    @XmlElement(name="group", namespace="http://www.interlocsolutions.com/maximo/notify")
    public List<NotifyGroupExport> getGroups() {
        return this.groups;
    }

    public void setGroups(List<NotifyGroupExport> groups) {
        this.groups = groups;
    }

    public void addGroup(NotifyGroupExport group) {
        this.groups.add(group);
    }

    @XmlElementWrapper(name="applications", namespace="http://www.interlocsolutions.com/maximo/notify")
    @XmlElement(name="application", namespace="http://www.interlocsolutions.com/maximo/notify")
    public List<NotifyAssociatedApplicationExport> getApplications() {
        return this.applications;
    }

    public void setApplications(List<NotifyAssociatedApplicationExport> applications) {
        this.applications = applications;
    }

    public void addApplication(NotifyAssociatedApplicationExport application) {
        this.applications.add(application);
    }

    @XmlElement(name="processname", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public void addCatalog(NotifyCatalogExport catalog) {
        this.catalogs.add(catalog);
    }

    @XmlElement(name="clausevalue", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getClauseValue() {
        return this.clauseValue;
    }

    public void setClauseValue(String clauseValue) {
        this.clauseValue = clauseValue;
    }

    @XmlElement(name="clausedescription", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getClauseDescription() {
        return this.clauseDescription;
    }

    public void setClauseDescription(String clauseDescription) {
        this.clauseDescription = clauseDescription;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @XmlElement(name="gensqlite", namespace="http://www.interlocsolutions.com/maximo/notify")
    public boolean isGensqlite() {
        return this.gensqlite;
    }

    public void setGensqlite(boolean gensqlite) {
        this.gensqlite = gensqlite;
    }

    @XmlElement(name="anonymous", namespace="http://www.interlocsolutions.com/maximo/notify")
    public boolean isAnonaccess() {
        return this.anonaccess;
    }

    public void setAnonaccess(boolean anonaccess) {
        this.anonaccess = anonaccess;
    }

    @XmlElement(name="anonymoususer", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getAnonuser() {
        return this.anonuser;
    }

    public void setAnonuser(String anonuser) {
        this.anonuser = anonuser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws RemoteException, MXException {
        List<Object> attributes;
        String objectName;
        if (this.objects != null) {
            for (NotifyObjectExport object : this.objects) {
                objectName = object.getObjectName();
                this.validateObject(objectName);
                if (object.getParent() != null && object.getRelationship() != null) {
                    this.validateRelationship(objectName, object.getParent(), object.getRelationship());
                }
                if ((attributes = object.getAttributes()) == null) continue;
                for (Object attribute : attributes) {
                    this.validateAttribute(objectName, ((NotifyAttributeExport)attribute).getAttributeName());
                }
            }
        }
        if (this.catalogs != null) {
            for (NotifyCatalogExport catalog : this.catalogs) {
                objectName = catalog.getObjectName();
                this.validateObject(objectName);
                attributes = catalog.getAttributes();
                if (attributes == null) continue;
                for (Object attribute : attributes) {
                    this.validateAttribute(objectName, ((NotifyCatalogAttributeExport)attribute).getAttributeName());
                }
            }
        }
        if (this.anonuser != null && this.anonuser.trim().length() > 0) {
            MboSetRemote maxuserSet;
            block10: {
                maxuserSet = null;
                try {
                    maxuserSet = MXServer.getMXServer().getMboSet("MAXUSER", MXServer.getMXServer().getSystemUserInfo());
                    SqlFormat sqlf = new SqlFormat("userid = :1 and status = :2");
                    sqlf.setObject(1, "MAXUSER", "USERID", this.anonuser);
                    sqlf.setObject(2, "MAXUSER", "STATUS", "ACTIVE");
                    maxuserSet.setWhere(sqlf.format());
                    if (!maxuserSet.isEmpty()) break block10;
                    Object[] args = new String[]{this.anonuser};
                    throw new MXApplicationException("informer", "missingAnonUser", args);
                }
                catch (Throwable throwable) {
                    NotifyUtil.closeAndCleanup(maxuserSet);
                    throw throwable;
                }
            }
            NotifyUtil.closeAndCleanup(maxuserSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateObject(String object) throws MXException, RemoteException {
        MboSetRemote objSet = null;
        try {
            objSet = MXServer.getMXServer().getMboSet("MAXOBJECT", MXServer.getMXServer().getSystemUserInfo());
            SqlFormat sqlf = new SqlFormat("objectname = :1");
            sqlf.setObject(1, "MAXOBJECT", "OBJECTNAME", object);
            objSet.setWhere(sqlf.format());
            objSet.reset();
            if (objSet.isEmpty()) {
                Object[] args = new String[]{object};
                throw new MXApplicationException("informer", "missingImpObject", args);
            }
        }
        catch (Throwable throwable) {
            NotifyUtil.closeAndCleanup(objSet);
            throw throwable;
        }
        NotifyUtil.closeAndCleanup(objSet);
    }

    private void validateAttribute(String object, String attribute) throws MXException, RemoteException {
        if (object != null && object.trim().length() > 0 && attribute != null && attribute.trim().length() > 0 && MboUtilKt.getNaryMboValueInfo(object, attribute) == null) {
            Object[] args = new String[]{object, attribute};
            throw new MXApplicationException("informer", "missingImpAttr", args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateRelationship(String object, String parent, String relationship) throws MXException, RemoteException {
        MboSetRemote relSet = null;
        if (object != null && object.trim().length() > 0 && parent != null && parent.trim().length() > 0 && relationship != null && relationship.trim().length() > 0) {
            block3: {
                try {
                    relSet = MXServer.getMXServer().getMboSet("MAXRELATIONSHIP", MXServer.getMXServer().getSystemUserInfo());
                    SqlFormat sqlf = new SqlFormat("name = :1 and parent = :2 and child = :3");
                    sqlf.setObject(1, "MAXRELATIONSHIP", "NAME", relationship);
                    sqlf.setObject(2, "MAXRELATIONSHIP", "PARENT", parent);
                    sqlf.setObject(3, "MAXRELATIONSHIP", "CHILD", object);
                    relSet.setWhere(sqlf.format());
                    relSet.reset();
                    if (!relSet.isEmpty()) break block3;
                    Object[] args = new String[]{relationship, parent, object};
                    throw new MXApplicationException("informer", "missingImpRel", args);
                }
                catch (Throwable throwable) {
                    NotifyUtil.closeAndCleanup(relSet);
                    throw throwable;
                }
            }
            NotifyUtil.closeAndCleanup(relSet);
        }
    }
}

