/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.xml;

import com.interlocsolutions.maximo.notify.util.ISO8601Formatter;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import java.rmi.RemoteException;
import java.util.Date;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import psdi.mbo.MboRemote;
import psdi.util.MXException;

@XmlRootElement(name="resource", namespace="http://www.interlocsolutions.com/maximo/notify")
public class ProfileResourceListValue {
    private String name;
    private int version;
    private String description;
    private Date createDate;
    private String type;
    private long recordid;
    private String langCode;

    public ProfileResourceListValue() {
    }

    public ProfileResourceListValue(MboRemote mbo) {
        try {
            if (mbo.isBasedOn("ISNOTIFYRESOURCE")) {
                this.name = mbo.getString("NAME");
                this.description = mbo.getString("DESCRIPTION");
                this.version = mbo.getInt("VERSION");
                this.createDate = mbo.getDate("CREATEDATE");
                this.type = mbo.getString("RESOURCETYPE");
                this.recordid = mbo.getUniqueIDValue();
                this.langCode = mbo.getString("LANGCODE");
            }
        }
        catch (RemoteException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
        }
        catch (MXException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
        }
    }

    public ProfileResourceListValue(String name, String description, int version, Date createDate, String type, long recordid, String langCode) {
        this.name = name;
        this.description = description;
        this.version = version;
        this.createDate = createDate;
        this.type = type;
        this.recordid = recordid;
        this.langCode = langCode;
    }

    @XmlElement(name="name", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="version", namespace="http://www.interlocsolutions.com/maximo/notify")
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @XmlElement(name="description", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElement(name="createdate", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getCreateDate() {
        return ISO8601Formatter.format(this.createDate);
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @XmlElement(name="type", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @XmlElement(name="langcode", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getLangCode() {
        return this.langCode;
    }

    public void setLangCode(String langCode) {
        this.langCode = langCode;
    }

    @XmlAttribute(name="resourceid")
    public long getRecordid() {
        return this.recordid;
    }

    public void setRecordid(long recordid) {
        this.recordid = recordid;
    }
}

