/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.xml;

import com.interlocsolutions.maximo.notify.NotificationEventListenerManager;
import com.interlocsolutions.maximo.notify.NotifyCommandRemote;
import com.interlocsolutions.maximo.notify.NotifyEvent;
import com.interlocsolutions.maximo.notify.NotifyEventComparator;
import com.interlocsolutions.maximo.notify.UserNotification;
import com.interlocsolutions.maximo.notify.commands.Command;
import com.interlocsolutions.maximo.notify.err.InformerException;
import com.interlocsolutions.maximo.notify.err.NoSuchRecordException;
import com.interlocsolutions.maximo.notify.util.CachedNotifyAttribute;
import com.interlocsolutions.maximo.notify.util.CachedNotifyObject;
import com.interlocsolutions.maximo.notify.util.ISO8601Formatter;
import com.interlocsolutions.maximo.notify.util.InformerObjectSerializer;
import com.interlocsolutions.maximo.notify.util.InformerProp;
import com.interlocsolutions.maximo.notify.util.MboUtil;
import com.interlocsolutions.maximo.notify.util.MboUtilKt;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import com.interlocsolutions.maximo.notify.util.codec.Base64;
import com.interlocsolutions.maximo.notify.xml.CatalogObjects;
import com.interlocsolutions.maximo.notify.xml.CatalogSQLiteDatabase;
import com.interlocsolutions.maximo.notify.xml.Notification;
import com.interlocsolutions.maximo.notify.xml.NotificationAttribute;
import com.interlocsolutions.maximo.notify.xml.NotificationContent;
import com.interlocsolutions.maximo.notify.xml.NotificationDefinition;
import com.interlocsolutions.maximo.notify.xml.NotificationDefinitions;
import com.interlocsolutions.maximo.notify.xml.NotificationDomain;
import com.interlocsolutions.maximo.notify.xml.NotificationDomainValue;
import com.interlocsolutions.maximo.notify.xml.NotificationEvent;
import com.interlocsolutions.maximo.notify.xml.NotificationEvents;
import com.interlocsolutions.maximo.notify.xml.NotificationId;
import com.interlocsolutions.maximo.notify.xml.NotificationIds;
import com.interlocsolutions.maximo.notify.xml.NotificationObject;
import com.interlocsolutions.maximo.notify.xml.NotificationRelationship;
import com.interlocsolutions.maximo.notify.xml.NotificationSession;
import com.interlocsolutions.maximo.notify.xml.SupportedLanguages;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.rmi.RemoteException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MaxLookupMapCache;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetInfo;
import psdi.mbo.MboSetRemote;
import psdi.mbo.MboValueInfo;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

public class NotifyXMLUtils {
    public static final int BIGINT = 19;
    public static final String PREFIX_MAPPER = "com.sun.xml.bind.namespacePrefixMapper";
    public static int VALUELIST_MAX_COUNT = 20;
    private static ThreadLocal<MessageDigest> threadLocalMessageDigest = new ThreadLocal();
    private static ThreadLocal<NumberFormat> threadLocalNumberFormat = new ThreadLocal();

    public static String serializeCustom(Object o) throws JAXBException {
        return NotifyXMLUtils.serializeCustom(o, InformerObjectSerializer.MARSHAL_BASIC);
    }

    public static <OutType> OutType serializeCustom(Object o, InformerObjectSerializer.MarshallingPolicy<OutType> policy) throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{o.getClass()});
        Marshaller m = ctx.createMarshaller();
        policy.configureMarshaller(m);
        return policy.useMarshaller(m, o);
    }

    public static <OutType> OutType serializeCustom(Object o, Class[] classesToBeBound, InformerObjectSerializer.MarshallingPolicy<OutType> policy) throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])classesToBeBound);
        Marshaller m = ctx.createMarshaller();
        policy.configureMarshaller(m);
        return policy.useMarshaller(m, o);
    }

    public static <OutType> OutType deserializeCustom(Class<OutType> clazz, Reader o) throws JAXBException, XMLStreamException {
        return NotifyXMLUtils.deserializeCustom(clazz, o, InformerObjectSerializer.UNMARSHAL_BASIC);
    }

    public static <OutType, InType, InParam extends InType> OutType deserializeCustom(Class<OutType> clazz, InParam o, InformerObjectSerializer.UnmarshallingPolicy<InType> policy) throws JAXBException, XMLStreamException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller um = ctx.createUnmarshaller();
        policy.configureUnmarshaller(um);
        return (OutType)policy.useUnmarshaller(um, o);
    }

    @NotNull
    public static MessageDigest getMD5Digest() throws MXException {
        MessageDigest md = threadLocalMessageDigest.get();
        if (md == null) {
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new MXApplicationException("informer", "missingRequiredAlgorithm", (Object[])new String[]{"MD5"}, (Throwable)e);
            }
            threadLocalMessageDigest.set(md);
        }
        return md;
    }

    private static NumberFormat getNumberFormat() {
        NumberFormat nf = threadLocalNumberFormat.get();
        if (nf == null) {
            nf = NumberFormat.getNumberInstance(Locale.US);
            nf.setGroupingUsed(false);
            nf.setMaximumFractionDigits(4);
            threadLocalNumberFormat.set(nf);
        }
        return nf;
    }

    public static String getDomainValues(MboRemote obj, MboSetRemote listValues, String attributeName, String whereClause, int start, int count) throws MXException, RemoteException {
        NotificationDomain domain = new NotificationDomain();
        MaxLookupMapCache cache = (MaxLookupMapCache)MXServer.getMXServer().getFromMaximoCache("LookupKeyMap");
        Object[] keys = cache.getLookupKeyMap(obj.getName(), listValues.getName(), attributeName);
        if (keys != null && keys.length > 0) {
            String source = null;
            for (Object key : keys) {
                Object[] keyValues = (Object[])key;
                if (keyValues.length <= 1 || !keyValues[0].toString().equalsIgnoreCase(attributeName)) continue;
                source = keyValues[1].toString();
                break;
            }
            if (source != null) {
                int maxvalues;
                if (whereClause != null) {
                    listValues.setWhere(whereClause);
                    listValues.reset();
                    if (listValues.isEmpty()) {
                        return null;
                    }
                }
                if (listValues.count() < start) {
                    return null;
                }
                listValues.moveTo(start - 1);
                MboRemote domainValue = null;
                int i = 0;
                int n = maxvalues = count > VALUELIST_MAX_COUNT ? VALUELIST_MAX_COUNT : count;
                while ((domainValue = listValues.moveNext()) != null && i++ < maxvalues) {
                    String value = domainValue.getString(source);
                    String description = null;
                    MboSetInfo setInfo = MXServer.getMXServer().getMaximoDD().getMboSetInfo(domainValue.getName());
                    if (setInfo.getMboValueInfo("DESCRIPTION") != null) {
                        description = domainValue.getString("DESCRIPTION");
                    } else if (setInfo.getMboValueInfo("NAME") != null) {
                        description = domainValue.getString("NAME");
                    }
                    domain.addValue(new NotificationDomainValue(value, description));
                }
            } else {
                return null;
            }
            domain.setCount(listValues.count());
            try {
                return InformerObjectSerializer.getInstance().serialize(domain, InformerObjectSerializer.MARSHAL_PPRINT_STRIPCONTROL);
            }
            catch (JAXBException e) {
                Object[] args = new String[]{"Domain Values", e.getMessage()};
                throw new MXApplicationException("informer", "jaxberror", args);
            }
        }
        return null;
    }

    public static String createEventNotification(NotifyEvent[] events) throws MXException {
        Arrays.sort(events, new NotifyEventComparator());
        NotificationEvents nEvents = new NotificationEvents();
        for (NotifyEvent event : events) {
            NotificationEvent nEvent = new NotificationEvent(event);
            nEvents.addEvent(nEvent);
        }
        try {
            return InformerObjectSerializer.getInstance().serialize(nEvents, InformerObjectSerializer.MARSHAL_PPRINT);
        }
        catch (JAXBException e) {
            Object[] args = new String[]{"Event Notification", e.getMessage()};
            throw new MXApplicationException("informer", "jaxberror", args);
        }
    }

    public static String getNotificationIds(MboSetRemote userNotificationSet) throws MXException, RemoteException {
        MboSetRemote deviceSet;
        userNotificationSet.setOrderBy("SEQUENCE");
        NotificationIds ids = new NotificationIds();
        MboRemote lastNotification = null;
        MboRemote n = userNotificationSet.moveFirst();
        while (n != null) {
            ids.addId(new NotificationId(n.getUniqueIDValue(), ISO8601Formatter.format(n.getDate("LASTUPDATE")), n.getLong("SEQUENCE"), n.getString("OBJECTNAME"), n.getLong("RECORDID")));
            lastNotification = n;
            n = userNotificationSet.moveNext();
        }
        String retVal = null;
        try {
            retVal = InformerObjectSerializer.getInstance().serialize(ids, InformerObjectSerializer.MARSHAL_PPRINT);
        }
        catch (JAXBException e) {
            Object[] args = new String[]{"Notification Ids", e.getMessage()};
            throw new MXApplicationException("informer", "jaxberror", args);
        }
        if (retVal == null) {
            return null;
        }
        if (lastNotification != null && (deviceSet = lastNotification.getMboSet("PUSHDEVICE")) != null) {
            MboRemote device = deviceSet.moveFirst();
            while (device != null) {
                device.setValue("LASTSEQUENCE", lastNotification.getLong("SEQUENCE"));
                device = deviceSet.moveNext();
            }
            deviceSet.save();
        }
        return retVal;
    }

    public static String getNotificationDefinitions(MboSetRemote set) throws MXException, RemoteException {
        NotificationDefinitions definitions = new NotificationDefinitions();
        MboRemote n = null;
        while ((n = set.getMbo(0)) != null) {
            if (!n.getMboSet("NOTIFY").isEmpty()) {
                definitions.addDefinition(new NotificationDefinition(n.getString("NOTIFY.NOTIFYNUM"), n.getString("NOTIFY.DESCRIPTION")));
            }
            set.remove(0);
        }
        try {
            return InformerObjectSerializer.getInstance().serialize(definitions, InformerObjectSerializer.MARSHAL_PPRINT);
        }
        catch (JAXBException e) {
            Object[] args = new String[]{"Notification Definition", e.getMessage()};
            throw new MXApplicationException("informer", "jaxberror", args);
        }
    }

    @Deprecated
    public static String getNotification(MboRemote userNotification) throws MXException, RemoteException {
        return NotifyXMLUtils.getNotificationXml(userNotification);
    }

    @Deprecated
    public static String getNotification(MboRemote userNotification, boolean isForXmlHashComparison) throws MXException, RemoteException {
        if (isForXmlHashComparison) {
            String notificationContentXml;
            long notifyId = userNotification.getLong("NOTIFYID");
            long recordId = userNotification.getLong("RECORDID");
            String userId = userNotification.getString("MAXUSER.USERID");
            UserInfo evalUserInfo = NotifyUtil.getLocalUserInfo(userId);
            NotificationContent notificationContent = NotifyXMLUtils.getNotificationContent(evalUserInfo, notifyId, recordId);
            try {
                notificationContentXml = InformerObjectSerializer.getInstance().serialize(notificationContent, InformerObjectSerializer.MARSHAL_BASIC);
            }
            catch (JAXBException e) {
                Object[] args = new String[]{"Notification", e.getMessage()};
                throw new InformerException("jaxberror", args, e);
            }
            return notificationContentXml;
        }
        return NotifyXMLUtils.getNotificationXml(userNotification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String getNotificationXml(MboRemote userNotification) throws MXException, RemoteException {
        long start = System.currentTimeMillis();
        long notifyId = userNotification.getLong("NOTIFYID");
        long recordId = userNotification.getLong("RECORDID");
        String userId = userNotification.getString("MAXUSER.USERID");
        try {
            String notificationXml;
            UserInfo evalUserInfo = NotifyUtil.getLocalUserInfo(userId);
            NotificationContent notificationContent = NotifyXMLUtils.getNotificationContent(evalUserInfo, notifyId, recordId);
            Notification notification = new Notification();
            notification.setNotificationId(userNotification.getUniqueIDValue());
            notification.setName(userNotification.getString("NOTIFY.NOTIFYNUM"));
            notification.setSequence(userNotification.getLong("SEQUENCE"));
            notification.setLastUpdateDate(userNotification.getDate("LASTUPDATE"));
            if (NotifyConstants.INFORMER_NRQP_XML_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_NRQP_XML_LOGGER.debug((Object)("Generating XML for record: " + recordId));
            }
            notification.setContent(notificationContent);
            try {
                InformerProp globalProp;
                String globalPropertyName = "informer.notify.xml.includecommanddata";
                InformerProp includeCommandData = PropUtil.INSTANCE.getProp("informer.notify.xml.includecommanddata." + userNotification.getString("NOTIFY.NOTIFYNUM").toLowerCase());
                boolean includeCommands = includeCommandData != null ? includeCommandData.asBoolean(false) : ((globalProp = PropUtil.INSTANCE.getProp("informer.notify.xml.includecommanddata")) != null ? globalProp.asBoolean(false) : false);
                if (includeCommands) {
                    if (NotifyConstants.INFORMER_NRQP_XML_LOGGER.isDebugEnabled()) {
                        NotifyConstants.INFORMER_NRQP_XML_LOGGER.debug((Object)("Generating command XML for record: " + recordId));
                    }
                    ArrayList classesToBind = new ArrayList();
                    classesToBind.add(Notification.class);
                    MboSetRemote commands = userNotification.getMboSet("NOTIFY").getMbo(0).getMboSet("NOTIFYCOMMAND");
                    commands.setOrderBy("name asc");
                    commands.reset();
                    NotifyCommandRemote cmd = (NotifyCommandRemote)commands.moveFirst();
                    while (cmd != null) {
                        Command c = cmd.getCommand();
                        c.setNotifyMbo((UserNotification)userNotification);
                        notification.addCommand(c);
                        classesToBind.add(c.getClass());
                        cmd = (NotifyCommandRemote)commands.moveNext();
                    }
                    notificationXml = NotifyXMLUtils.serializeCustom(notification, classesToBind.toArray(new Class[classesToBind.size()]), InformerObjectSerializer.MARSHAL_PPRINT_STRIPCONTROL);
                } else {
                    notificationXml = InformerObjectSerializer.getInstance().serialize(notification, InformerObjectSerializer.MARSHAL_PPRINT_STRIPCONTROL);
                }
            }
            catch (JAXBException e) {
                Object[] args = new String[]{"Notification", e.getMessage()};
                throw new MXApplicationException("informer", "jaxberror", args);
            }
            String string = notificationXml;
            return string;
        }
        finally {
            if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)("Created Notification in " + (System.currentTimeMillis() - start) + "ms"));
            }
        }
    }

    @NotNull
    public static String getNotificationContentHash(@NotNull UserInfo userInfo, long notifyId, long recordId) throws MXException, RemoteException {
        try {
            NotificationContent notificationContent = NotifyXMLUtils.getNotificationContent(userInfo, notifyId, recordId);
            String notificationContentXml = InformerObjectSerializer.getInstance().serialize(notificationContent, InformerObjectSerializer.MARSHAL_BASIC);
            if (NotifyConstants.INFORMER_NRQP_XML_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_NRQP_XML_LOGGER.debug((Object)("Notification content xml (userId: " + userInfo.getUserName() + ", notifyId: " + notifyId + ", recordId:" + recordId + "): " + notificationContentXml));
            }
            String calculatedHash = NotifyXMLUtils.calculateHash(notificationContentXml);
            if (NotifyConstants.INFORMER_NRQP_XML_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_NRQP_XML_LOGGER.debug((Object)("Calculated hash for notification content xml (userId: " + userInfo.getUserName() + ", notifyId: " + notifyId + ", recordId:" + recordId + "): " + calculatedHash));
            }
            return calculatedHash;
        }
        catch (JAXBException e) {
            Object[] args = new String[]{"Notification", e.getMessage()};
            throw new MXApplicationException("informer", "jaxberror", args);
        }
    }

    @NotNull
    public static NotificationContent getNotificationContent(@NotNull UserInfo userInfo, long notifyId, long recordId) throws MXException, RemoteException {
        final CachedNotifyObject cachedNotificationObject = NotificationEventListenerManager.getCachedNotificationObject(notifyId);
        if (cachedNotificationObject == null) {
            throw new NoSuchRecordException("ISNOTIFY", "notifyid = " + notifyId + " (in the cache)");
        }
        String objName = cachedNotificationObject.getObjectName();
        final NotificationContent content = new NotificationContent();
        final NotificationObject object = new NotificationObject();
        object.setName(objName.toLowerCase());
        object.setRecordid(recordId);
        MboUtil.visitSingleMboReadOnlyOrThrow(userInfo, objName, recordId, new NotifyUtil.MboVisitor(){

            @Override
            public void visit(@NotNull MboRemote obj) throws RemoteException, MXException {
                NotifyXMLUtils.addAttributes(obj, cachedNotificationObject, object);
                content.addObject(object);
            }
        });
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAttributes(MboRemote obj, CachedNotifyObject objConfig, NotificationObject parent) throws RemoteException, MXException {
        long start = System.currentTimeMillis();
        if (NotifyConstants.INFORMER_NRQP_XML_LOGGER.isDebugEnabled()) {
            NotifyConstants.INFORMER_NRQP_XML_LOGGER.debug((Object)("Adding attributes for object type: " + obj.getName() + " with id " + obj.getUniqueIDName() + " and parent: " + (parent != null ? parent.getName() + ":" + parent.getRecordid() : "")));
        }
        MboSetRemote relationSet = null;
        try {
            boolean hasRecordID = false;
            String uniqueIdName = obj.getUniqueIDName();
            List<CachedNotifyAttribute> attributes = objConfig.getAttributes();
            for (CachedNotifyAttribute attribute : attributes) {
                NotificationAttribute attr;
                block38: {
                    String attributeName = attribute.getName();
                    String value = "";
                    if (!obj.isNull(attributeName)) {
                        long attrStart = System.currentTimeMillis();
                        MboValueInfo valueInfo = MboUtilKt.getNaryMboValueInfo(obj.getName(), attributeName);
                        if (valueInfo == null) {
                            Object[] args = new String[]{attributeName, obj.getName()};
                            throw new InformerException(MXServer.getMXServer().getMaxMessageCache().getTaggedMessage("informer", "invalidObjectAttribute").getMessage(args));
                        }
                        switch (valueInfo.getTypeAsInt()) {
                            case 0: 
                            case 1: 
                            case 2: {
                                value = obj.getString(attributeName);
                                break;
                            }
                            case 14: 
                            case 17: {
                                value = obj.getString(attributeName);
                                break;
                            }
                            case 12: {
                                value = obj.getBoolean(attributeName) ? NotifyConstants.TRUE : NotifyConstants.FALSE;
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                if (!obj.isNull(attributeName)) {
                                    value = ISO8601Formatter.format(obj.getDate(attributeName));
                                    break;
                                }
                                value = null;
                                break;
                            }
                            case 6: {
                                value = NotifyXMLUtils.getNumberFormat().format(obj.getLong(attributeName));
                                break;
                            }
                            case 19: {
                                value = NotifyXMLUtils.getNumberFormat().format(obj.getLong(attributeName));
                                break;
                            }
                            case 7: {
                                value = NotifyXMLUtils.getNumberFormat().format(obj.getInt(attributeName));
                                break;
                            }
                            case 8: {
                                value = NotifyXMLUtils.getNumberFormat().format(obj.getFloat(attributeName));
                                break;
                            }
                            case 9: 
                            case 10: 
                            case 11: {
                                value = NotifyXMLUtils.getNumberFormat().format(obj.getDouble(attributeName));
                                break;
                            }
                            case 18: {
                                value = Base64.encodeBase64String(obj.getBytes(attributeName));
                                break;
                            }
                            default: {
                                value = obj.getString(attributeName);
                            }
                        }
                        if (NotifyConstants.INFORMER_NRQP_XML_LOGGER.isDebugEnabled()) {
                            NotifyConstants.INFORMER_NRQP_XML_LOGGER.debug((Object)("Added attribute " + attributeName + " from object type: " + obj.getName() + " with id " + obj.getUniqueIDName() + " and parent: " + (parent != null ? parent.getName() + ":" + parent.getRecordid() : "") + " in " + (System.currentTimeMillis() - attrStart) + "ms"));
                        }
                    } else {
                        value = null;
                    }
                    attr = new NotificationAttribute();
                    attr.setName(attributeName.toLowerCase());
                    attr.setReadonly(attribute.isCanEdit() ? "true" : null);
                    if (value != null) {
                        attr.setValue(value);
                    }
                    if (attributeName.equalsIgnoreCase(uniqueIdName)) {
                        hasRecordID = true;
                        attr.setIsuniqueid("true");
                    }
                    if (attributeName.indexOf(".") <= 0) {
                        try {
                            MboSetRemote listValues;
                            if (obj instanceof Mbo) {
                                if (!((Mbo)obj).getMboValue(attributeName).hasList()) break block38;
                                try {
                                    listValues = obj.getList(attributeName);
                                    if (listValues != null && !attributeName.equalsIgnoreCase("SITEID")) {
                                        attr.setHasDomain("true");
                                    }
                                    break block38;
                                }
                                catch (Exception listValues2) {}
                                break block38;
                            }
                            listValues = obj.getList(attributeName);
                            if (listValues != null && !attributeName.equalsIgnoreCase("SITEID")) {
                                attr.setHasDomain("true");
                            }
                        }
                        catch (NullPointerException listValues) {
                            // empty catch block
                        }
                    }
                }
                parent.addAttribute(attr);
            }
            if (!hasRecordID) {
                NotificationAttribute attr = new NotificationAttribute();
                attr.setName(uniqueIdName.toLowerCase());
                attr.setValue(NotifyXMLUtils.getNumberFormat().format(obj.getUniqueIDValue()));
                attr.setReadonly("true");
                attr.setIsuniqueid("true");
                parent.addAttribute(attr);
            }
            List<CachedNotifyObject> children = objConfig.getChildren();
            for (CachedNotifyObject child : children) {
                if (NotifyConstants.INFORMER_NRQP_XML_LOGGER.isDebugEnabled()) {
                    NotifyConstants.INFORMER_NRQP_XML_LOGGER.debug((Object)("Adding child for object type: " + obj.getName() + " with id " + obj.getUniqueIDName() + " child is " + child.getObjectName() + " with relationship " + child.getRelationship()));
                }
                NotificationRelationship relationship = new NotificationRelationship();
                String relationshipName = child.getRelationship();
                relationship.setName(relationshipName);
                relationSet = obj.getMboSet(relationshipName);
                if (NotifyConstants.INFORMER_NRQP_XML_LOGGER.isDebugEnabled()) {
                    NotifyConstants.INFORMER_NRQP_XML_LOGGER.debug((Object)("Retrieved child set for object type: " + obj.getName() + " with id " + obj.getUniqueIDName() + " child is " + child.getObjectName() + " with relationship " + child.getRelationship()));
                }
                relationSet.reset();
                MboRemote relation = relationSet.moveFirst();
                while (relation != null) {
                    NotificationObject object = new NotificationObject();
                    object.setName(child.getObjectName());
                    object.setRecordid(relation.getUniqueIDValue());
                    NotifyXMLUtils.addAttributes(relation, child, object);
                    relationship.addObject(object);
                    relation = relationSet.moveNext();
                }
                NotifyUtil.closeAndCleanup(relationSet);
                parent.addRelationship(relationship);
            }
        }
        finally {
            NotifyUtil.closeAndCleanup(relationSet);
        }
        if (NotifyConstants.INFORMER_NRQP_XML_LOGGER.isDebugEnabled()) {
            NotifyConstants.INFORMER_NRQP_XML_LOGGER.debug((Object)("Added attributes for object type: " + obj.getName() + " with id " + obj.getUniqueIDName() + " and parent: " + (parent != null ? parent.getName() + ":" + parent.getRecordid() : "") + " in " + (System.currentTimeMillis() - start) + "ms"));
        }
    }

    public static String getCatalog(CatalogObjects objects) throws MXException, RemoteException {
        try {
            return InformerObjectSerializer.getInstance().serialize(objects, InformerObjectSerializer.MARSHAL_PPRINT_STRIPCONTROL);
        }
        catch (JAXBException e) {
            Object[] args = new String[]{"Catalog", e.getMessage()};
            throw new MXApplicationException("informer", "jaxberror", args);
        }
    }

    public static String getCatalog(CatalogSQLiteDatabase objects) throws MXException, RemoteException {
        try {
            return InformerObjectSerializer.getInstance().serialize(objects, InformerObjectSerializer.MARSHAL_PPRINT);
        }
        catch (JAXBException e) {
            Object[] args = new String[]{"Catalog", e.getMessage()};
            throw new MXApplicationException("informer", "jaxberror", args);
        }
    }

    public static String getLanguages(SupportedLanguages languages) throws MXException {
        try {
            return InformerObjectSerializer.getInstance().serialize(languages, InformerObjectSerializer.MARSHAL_PPRINT);
        }
        catch (JAXBException e) {
            Object[] args = new String[]{"Languages", e.getMessage()};
            throw new MXApplicationException("informer", "jaxberror", args);
        }
    }

    public static String getSession(NotificationSession session) throws MXException, RemoteException {
        try {
            return InformerObjectSerializer.getInstance().serialize(session, InformerObjectSerializer.MARSHAL_PPRINT);
        }
        catch (JAXBException e) {
            Object[] args = new String[]{"Session", e.getMessage()};
            throw new MXApplicationException("informer", "jaxberror", args);
        }
    }

    public static String compressMessage(String xml) throws MXException, RemoteException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BufferedOutputStream bufos = new BufferedOutputStream(new GZIPOutputStream(bos));
            bufos.write(xml.getBytes("UTF8"));
            bufos.close();
            byte[] retval = bos.toByteArray();
            bos.close();
            return Base64.encodeBase64String(retval);
        }
        catch (IOException e) {
            Object[] args = new String[]{e.getMessage()};
            throw new MXApplicationException("informer", "compressionError", args);
        }
    }

    public static byte[] decompressMessage(byte[] data) throws MXException {
        try {
            GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(data));
            byte[] retVal = new byte[]{};
            int res = 0;
            byte[] buffer = new byte[1024];
            while ((res = gzip.read(buffer)) > 0) {
                byte[] existingData = retVal;
                retVal = new byte[existingData.length + res];
                System.arraycopy(existingData, 0, retVal, 0, existingData.length);
                System.arraycopy(buffer, 0, retVal, existingData.length, res);
            }
            return retVal;
        }
        catch (IOException e) {
            Object[] args = new String[]{e.getMessage()};
            throw new MXApplicationException("informer", "compressionError", args);
        }
    }

    public static String decompressMessage(String xml) throws MXException {
        byte[] data = Base64.decodeBase64(xml);
        try {
            return IOUtils.toString((InputStream)new GZIPInputStream(new ByteArrayInputStream(data)), (String)"UTF-8");
        }
        catch (IOException e) {
            Object[] args = new String[]{e.getMessage()};
            throw new MXApplicationException("informer", "compressionError", args);
        }
    }

    public static String calculateHash(@NotNull String input) throws MXException {
        return NotifyXMLUtils.calculateHash(input.getBytes());
    }

    public static String calculateHash(@NotNull byte[] input) throws MXException {
        return Base64.encodeBase64String(NotifyXMLUtils.getMD5Digest().digest(input)).trim();
    }

    public static enum MaximoType {
        ALN("ALN"),
        AMOUNT("AMOUNT"),
        BLOB("BLOB"),
        CLOB("CLOB"),
        CRYPTO("CRYPTO"),
        DATE("DATE"),
        DATETIME("DATETIME"),
        DECIMAL("DECIMAL"),
        DURATION("DURATION"),
        FLOAT("FLOAT"),
        GL("GL"),
        INTEGER("INTEGER"),
        LONGALN("LONGALN"),
        LOWER("LOWER"),
        SMALLINT("SMALLINT"),
        TIME("TIME"),
        UPPER("UPPER"),
        YORN("YORN");

        private String value;

        private MaximoType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

