/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.xml;

import com.interlocsolutions.maximo.notify.util.ISO8601Formatter;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import java.rmi.RemoteException;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import psdi.server.MXServer;

@XmlRootElement(name="session", namespace="http://www.interlocsolutions.com/maximo/notify")
@XmlType(propOrder={"sessionId", "authenticated", "errorCode", "serverErrorMessage", "expires", "userId", "firstLogin", "serverTime"}, namespace="http://www.interlocsolutions.com/maximo/notify")
public class NotificationSession {
    private String sessionId = null;
    private boolean authenticated = false;
    private String errorCode = null;
    private String serverErrorMessage = null;
    private Date expires = null;
    private String userId = null;
    private boolean firstLogin = false;
    private Date serverTime = null;

    @XmlElement(name="sessionid", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @XmlElement(name="authenticated", namespace="http://www.interlocsolutions.com/maximo/notify")
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    @XmlElement(name="errorcode", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @XmlElement(name="servererrormessage", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getServerErrorMessage() {
        return this.serverErrorMessage;
    }

    public void setServerErrorMessage(String serverErrorMessage) {
        this.serverErrorMessage = serverErrorMessage;
    }

    @XmlElement(name="expires", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getExpires() {
        if (this.expires != null) {
            return ISO8601Formatter.format(this.expires);
        }
        return null;
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }

    @XmlElement(name="userid", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @XmlElement(name="initialdevicelogin", namespace="http://www.interlocsolutions.com/maximo/notify")
    public boolean isFirstLogin() {
        return this.firstLogin;
    }

    public void setFirstLogin(boolean firstLogin) {
        this.firstLogin = firstLogin;
    }

    @XmlElement(name="servertime", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getServerTime() {
        if (this.expires != null) {
            return ISO8601Formatter.format(this.serverTime);
        }
        try {
            return ISO8601Formatter.format(MXServer.getMXServer().getDate());
        }
        catch (RemoteException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            return null;
        }
    }

    public void setServerTime(Date serverTime) {
        this.serverTime = serverTime;
    }
}

