/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.xml;

import com.interlocsolutions.maximo.notify.util.ISO8601Formatter;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import java.rmi.RemoteException;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import psdi.server.MXServer;

@XmlRootElement(name="loginresponse", namespace="http://www.interlocsolutions.com/maximo/notify")
public class LoginPublicResponse {
    private LoginResponse response;
    private String responseMessage;
    private String sessionId = null;
    private Date expires = null;
    private Date serverTime = null;

    public LoginPublicResponse() {
    }

    public LoginPublicResponse(LoginResponse response, String sessionId) {
        this(response, sessionId, null);
    }

    public LoginPublicResponse(LoginResponse response, String sessionId, String responseMessage) {
        this.response = response;
        this.sessionId = sessionId;
        this.responseMessage = responseMessage;
    }

    @XmlElement(name="responsecode", namespace="http://www.interlocsolutions.com/maximo/notify")
    public LoginResponse getResponse() {
        return this.response;
    }

    public void setResponse(LoginResponse response) {
        this.response = response;
    }

    @XmlElement(name="sessionid", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @XmlElement(name="message", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    @XmlElement(name="expires", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getExpires() {
        if (this.expires != null) {
            return ISO8601Formatter.format(this.expires);
        }
        return null;
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }

    @XmlElement(name="servertime", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getServerTime() {
        if (this.serverTime != null) {
            return ISO8601Formatter.format(this.serverTime);
        }
        try {
            return ISO8601Formatter.format(MXServer.getMXServer().getDate());
        }
        catch (RemoteException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
            return null;
        }
    }

    public void setServerTime(Date serverTime) {
        this.serverTime = serverTime;
    }

    public static enum LoginResponse {
        SUCCESS,
        INVALID_CREDENTIALS,
        ERROR,
        ADMIN_MODE;

    }
}

