/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.xml;

import com.interlocsolutions.maximo.notify.util.ISO8601Formatter;
import java.text.ParseException;
import java.util.Date;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;

@XmlRootElement(name="reading", namespace="http://www.interlocsolutions.com/maximo/notify")
public class InstrumentReading {
    private String key = null;
    private String value = null;

    public InstrumentReading() {
    }

    public InstrumentReading(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @XmlAttribute(name="name")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @XmlValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @XmlTransient
    public Integer getValueAsInt() throws NumberFormatException {
        if (this.value != null) {
            return Integer.parseInt(this.value);
        }
        return null;
    }

    @XmlTransient
    public Double getValueAsDouble() throws NumberFormatException {
        if (this.value != null) {
            return Double.parseDouble(this.value);
        }
        return null;
    }

    @XmlTransient
    public Date getValueAsDate() throws ParseException {
        if (this.value != null) {
            return ISO8601Formatter.parse(this.value);
        }
        return null;
    }

    @XmlTransient
    public Boolean getValueAsBoolean() {
        if (this.value != null) {
            return "1".equals(this.value) || "true".equalsIgnoreCase(this.value) || "y".equalsIgnoreCase(this.value) || "yes".equalsIgnoreCase(this.value);
        }
        return null;
    }
}

