/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.xml;

import com.interlocsolutions.maximo.notify.xml.CatalogObject;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="catalogstream", namespace="http://www.interlocsolutions.com/maximo/notify")
@XmlType(propOrder={"objects"}, namespace="http://www.interlocsolutions.com/maximo/notify")
public class CatalogStream
implements Serializable {
    private static final long serialVersionUID = 3937861356457316472L;
    private final long sequenceLowerBound;
    private String name = null;
    private String partition;
    private boolean more = false;
    private List<CatalogObject> objects = new LinkedList<CatalogObject>();

    public CatalogStream() {
        this(-1L);
    }

    public CatalogStream(long sequenceLowerBound) {
        this.sequenceLowerBound = sequenceLowerBound;
    }

    @XmlAttribute(name="partition")
    public String getPartition() {
        return this.partition;
    }

    public void setPartition(String partition) {
        this.partition = partition;
    }

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="object", namespace="http://www.interlocsolutions.com/maximo/notify")
    public List<CatalogObject> getObjects() {
        return this.objects;
    }

    public void setObjects(List<CatalogObject> objects) {
        if (objects == null) {
            this.objects.clear();
        } else {
            this.objects = objects;
        }
    }

    public void addObject(CatalogObject object) {
        this.objects.add(object);
    }

    @XmlAttribute(name="more")
    public boolean isMoreToFetch() {
        return this.more;
    }

    public void setMoreToFetch(boolean hasMore) {
        this.more = hasMore;
    }

    @XmlAttribute(name="sequence")
    public long getHighSeqNum() {
        long highest = this.sequenceLowerBound;
        for (CatalogObject obj : this.objects) {
            long seqNum = obj.getSeqeunce();
            if (seqNum <= highest) continue;
            highest = seqNum;
        }
        return highest;
    }
}

