/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.xml;

import com.interlocsolutions.maximo.notify.err.InformerException;
import com.interlocsolutions.maximo.notify.util.ISO8601Formatter;
import com.interlocsolutions.maximo.notify.util.MboUtilKt;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.codec.Base64;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.Locale;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import psdi.mbo.MboRemote;
import psdi.mbo.MboValueInfo;
import psdi.server.MXServer;
import psdi.util.MXException;

@XmlRootElement(name="attribute", namespace="http://www.interlocsolutions.com/maximo/notify")
@XmlType(namespace="http://www.interlocsolutions.com/maximo/notify")
public class CatalogAttribute
implements Serializable {
    private static final long serialVersionUID = -4299190048996482062L;
    private static ThreadLocal<NumberFormat> threadLocalNumberFormat = new ThreadLocal();
    private String name = null;
    private String value = null;
    private String type = null;

    public CatalogAttribute() {
    }

    public CatalogAttribute(String attributeName, MboRemote obj, String langCode) throws RemoteException, MXException {
        this.name = attributeName;
        if (obj == null || obj.isNull(attributeName)) {
            return;
        }
        MboValueInfo valueInfo = MboUtilKt.getNaryMboValueInfo(obj.getName(), attributeName);
        if (valueInfo == null) {
            Object[] args = new String[]{attributeName, obj.getName()};
            throw new InformerException(MXServer.getMXServer().getMaxMessageCache().getTaggedMessage("informer", "invalidObjectAttribute").getMessage(args));
        }
        switch (valueInfo.getTypeAsInt()) {
            case 0: 
            case 1: 
            case 2: {
                this.value = obj.getString(attributeName);
                this.type = CatalogType.STRING.toString();
                break;
            }
            case 12: {
                this.value = obj.getBoolean(attributeName) ? NotifyConstants.TRUE : NotifyConstants.FALSE;
                this.type = CatalogType.BOOLEAN.toString();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (!obj.isNull(attributeName)) {
                    this.value = ISO8601Formatter.format(obj.getDate(attributeName));
                }
                this.type = CatalogType.DATETIME.toString();
                break;
            }
            case 6: {
                this.value = CatalogAttribute.getNumberFormat().format(obj.getLong(attributeName));
                this.type = CatalogType.INTEGER.toString();
                break;
            }
            case 19: {
                this.value = CatalogAttribute.getNumberFormat().format(obj.getLong(attributeName));
                this.type = CatalogType.INTEGER.toString();
                break;
            }
            case 7: {
                this.value = CatalogAttribute.getNumberFormat().format(obj.getInt(attributeName));
                this.type = CatalogType.INTEGER.toString();
                break;
            }
            case 8: {
                this.value = CatalogAttribute.getNumberFormat().format(obj.getFloat(attributeName));
                this.type = CatalogType.DECIMAL.toString();
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                this.value = CatalogAttribute.getNumberFormat().format(obj.getDouble(attributeName));
                this.type = CatalogType.DECIMAL.toString();
                break;
            }
            case 18: {
                this.value = Base64.encodeBase64String(obj.getBytes(attributeName));
                this.type = CatalogType.BLOB.toString();
                break;
            }
            default: {
                this.value = obj.getString(attributeName);
                this.type = CatalogType.STRING.toString();
            }
        }
    }

    private static NumberFormat getNumberFormat() {
        NumberFormat nf = threadLocalNumberFormat.get();
        if (nf == null) {
            nf = NumberFormat.getInstance(Locale.US);
            nf.setGroupingUsed(false);
            nf.setMaximumFractionDigits(4);
            threadLocalNumberFormat.set(nf);
        }
        return nf;
    }

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @XmlAttribute(name="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @XmlRootElement(name="catalogType", namespace="http://www.interlocsolutions.com/maximo/notify")
    @XmlType(namespace="http://www.interlocsolutions.com/maximo/notify")
    public static enum CatalogType {
        STRING,
        DATETIME,
        INTEGER,
        DECIMAL,
        BLOB,
        BOOLEAN;

    }
}

