/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.virtual;

import com.interlocsolutions.maximo.notify.err.InformerSqlException;
import com.interlocsolutions.maximo.notify.push.PushQueueRepo;
import com.interlocsolutions.maximo.notify.push.QueueState;
import java.rmi.RemoteException;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboServerInterface;
import psdi.mbo.MboSet;
import psdi.mbo.NonPersistentMboSet;
import psdi.mbo.custapp.NonPersistentCustomMbo;
import psdi.server.MXServer;
import psdi.util.MXException;

public class MonitorPushQueueSet
extends NonPersistentMboSet {
    private final PushQueueRepo pushQueueRepo = PushQueueRepo.INSTANCE;

    public MonitorPushQueueSet(MboServerInterface ms) throws RemoteException {
        super(ms);
    }

    protected Mbo getMboInstance(MboSet set) throws MXException, RemoteException {
        return new NonPersistentCustomMbo(set);
    }

    public void init() throws RemoteException, MXException {
        QueueState data;
        super.init();
        try {
            data = this.pushQueueRepo.totalCounts();
        }
        catch (Exception e) {
            throw new InformerSqlException(e.getMessage(), e);
        }
        MboRemote mbo = this.add();
        mbo.setValue("TOTALCOUNT", data.getCountTotal());
        mbo.setValue("ACTIVECOUNT", data.getCountActive());
        mbo.setValue("ERRORCOUNT", data.getCountError());
        if (MXServer.getMXServer().isAdminModeOn(true)) {
            String msg = MXServer.getMXServer().getMaxMessageCache().getMessage("informer", "adminModeWarning").toString();
            mbo.setValue("ADMINWARNING", msg);
        }
    }
}

