/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.virtual;

import com.interlocsolutions.maximo.notify.virtual.CreateAsset;
import java.rmi.RemoteException;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboServerInterface;
import psdi.mbo.MboSet;
import psdi.mbo.MboSetRemote;
import psdi.mbo.NonPersistentMboSet;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

public class CreateAssetSet
extends NonPersistentMboSet {
    private static final long serialVersionUID = 2007230788032595439L;

    public CreateAssetSet(MboServerInterface ms) throws RemoteException {
        super(ms);
    }

    protected Mbo getMboInstance(MboSet set) throws MXException, RemoteException {
        return new CreateAsset(set);
    }

    public void execute() throws RemoteException, MXException {
        MboRemote asset = this.getMbo(0);
        if (asset != null) {
            MboRemote newAsset = asset.getMboSet("$asset", "ASSET", "").add();
            if (asset.isNull("ASSETNUM")) {
                newAsset.generateAutoKey();
                if (newAsset.isNull("ASSETNUM")) {
                    throw new MXApplicationException("informer", "assetNumberRequired");
                }
            } else {
                newAsset.setValue("ASSETNUM", asset.getString("ASSETNUM"));
            }
            newAsset.setValue("LOCATION", asset.getString("LOCATION"));
            if (!asset.isNull("ITEMNUM")) {
                newAsset.setValue("ITEMNUM", asset.getString("ITEMNUM"));
            }
            newAsset.setValue("DESCRIPTION", this.getOwner().getString("NAME"));
            newAsset.setValue("SERIALNUM", this.getOwner().getString("SERIALNUM"));
            String operatingStatus = MXServer.getMXServer().getMaximoDD().getTranslator().toExternalDefaultValue("LOCASSETSTATUS", "OPERATING", newAsset);
            newAsset.setValue("STATUS", operatingStatus, 2L);
            SqlFormat sqlf = new SqlFormat("personid in (select personid from maxuser where userid in (select userid from issessionhistory where deviceid = :1))");
            sqlf.setLong(1, this.getOwner().getUniqueIDValue());
            MboSetRemote personSet = asset.getMboSet("$person", "PERSON", sqlf.format());
            MboRemote person = personSet.moveFirst();
            while (person != null) {
                MboRemote assetCust = newAsset.getMboSet("ASSETUSERCUST").add();
                assetCust.setValue("PERSONID", person.getString("PERSONID"));
                assetCust.setValue("ISUSER", true);
                person = personSet.moveNext();
            }
            this.getOwner().setValue("ASSETID", newAsset.getUniqueIDValue());
            this.getOwner().getThisMboSet().save();
        }
    }
}

