/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.velocity;

import com.interlocsolutions.maximo.notify.velocity.VelocityMbo;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.util.MXException;

public class VelocityMboSet
implements Collection<VelocityMbo> {
    private MboSetRemote msr;

    public VelocityMboSet(MboSetRemote msr) {
        this.msr = msr;
    }

    public Object get(Object o) throws MXException, RemoteException {
        if (o instanceof Integer) {
            int i = (Integer)o;
            return new VelocityMbo(this.msr.getMbo(i));
        }
        if (o instanceof String) {
            String s = (String)o;
            if (s.startsWith("REL_")) {
                return this.getRelationship(s.substring(4));
            }
            return this.getString(s);
        }
        return null;
    }

    public String getString(String field) throws MXException, RemoteException {
        if (this.msr.getCurrentPosition() < 0) {
            this.msr.moveFirst();
        }
        return this.msr.getMbo().getString(field);
    }

    public VelocityMboSet getRelationship(String relationship) throws MXException, RemoteException {
        if (this.msr.getCurrentPosition() < 0) {
            this.msr.moveFirst();
        }
        VelocityMbo vm = new VelocityMbo(this.msr.getMbo());
        return vm.getRelationship(relationship);
    }

    @Override
    public boolean add(VelocityMbo o) {
        throw new UnsupportedOperationException("add");
    }

    @Override
    public boolean addAll(Collection<? extends VelocityMbo> c) {
        throw new UnsupportedOperationException("addAll");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear");
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException("contains");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("containsAll");
    }

    @Override
    public boolean isEmpty() {
        try {
            return this.msr.count() == 0;
        }
        catch (MXException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<VelocityMbo> iterator() {
        try {
            return new MboSetIterator();
        }
        catch (MXException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("removeAll");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll");
    }

    @Override
    public int size() {
        try {
            return this.msr.count();
        }
        catch (MXException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("toArray");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException("toArray");
    }

    private class MboSetIterator
    implements Iterator<VelocityMbo> {
        private VelocityMbo nextElement;

        public MboSetIterator() throws RemoteException, MXException {
            VelocityMboSet.this.msr.moveFirst();
            MboRemote mr = VelocityMboSet.this.msr.getMbo();
            this.nextElement = mr == null ? null : new VelocityMbo(mr);
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public VelocityMbo next() {
            try {
                VelocityMbo rc2 = this.nextElement;
                MboRemote mr = VelocityMboSet.this.msr.moveNext();
                this.nextElement = mr == null ? null : new VelocityMbo(mr);
                return rc2;
            }
            catch (MXException e) {
                throw new RuntimeException(e);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

