/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util.db;

import com.interlocsolutions.maximo.notify.err.InformerException;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.db.DbAccessorBase;
import com.interlocsolutions.maximo.notify.util.db.DbServerType;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import psdi.security.ConnectionKey;
import psdi.security.UserInfo;
import psdi.server.DBManager;
import psdi.server.MXServer;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class DefaultDbAccessor
extends DbAccessorBase {
    public static final MXLogger LOGGER = NotifyConstants.INFORMER_LOGGER;
    private final DbServerType dbServerType;
    private DBManager dbManager = MXServer.getMXServer().getDBManager();
    private LinkedList<ConnectionInfo> connections = new LinkedList();
    private UserInfo providedUserInfo;

    public DefaultDbAccessor() throws RemoteException {
        this.dbServerType = DefaultDbAccessor.identifyMaximoDbType();
        this.providedUserInfo = null;
    }

    public DefaultDbAccessor(@NotNull UserInfo userInfo) throws RemoteException {
        this.dbServerType = DefaultDbAccessor.identifyMaximoDbType();
        this.providedUserInfo = userInfo;
    }

    public static DbServerType identifyMaximoDbType() {
        int platformNum;
        try {
            platformNum = MXServer.getMXServer().getDBPlatform();
        }
        catch (RemoteException e) {
            NotifyConstants.INFORMER_LOGGER.warn((Object)"Failed to identify database type", (Throwable)e);
            return DbServerType.UNKNOWN;
        }
        if (platformNum == 1) {
            return DbServerType.ORACLE;
        }
        if (platformNum == 2) {
            return DbServerType.MSSQL;
        }
        if (platformNum == 3) {
            return DbServerType.DB2;
        }
        return DbServerType.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Connection obtain() throws SQLException {
        ConnectionKey connKey = this.providedUserInfo != null ? this.providedUserInfo.getConnectionKey() : this.dbManager.getSystemConnectionKey();
        ConnectionInfo newConnInfo = new ConnectionInfo(connKey, this.dbManager.getConnection(connKey));
        DefaultDbAccessor defaultDbAccessor = this;
        synchronized (defaultDbAccessor) {
            this.connections.add(newConnInfo);
        }
        return newConnInfo.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(@NotNull Connection conn) throws MXException {
        ConnectionInfo foundInfo = null;
        DefaultDbAccessor defaultDbAccessor = this;
        synchronized (defaultDbAccessor) {
            ListIterator connItr = this.connections.listIterator();
            while (connItr.hasNext()) {
                ConnectionInfo info = (ConnectionInfo)connItr.next();
                if (info.connection != conn) continue;
                foundInfo = info;
                connItr.remove();
            }
        }
        if (foundInfo == null) {
            throw new InformerException("connectionNotFound");
        }
        this.dbManager.freeConnection(foundInfo.connKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        DefaultDbAccessor defaultDbAccessor = this;
        synchronized (defaultDbAccessor) {
            ConnectionInfo info;
            if (this.dbManager == null) {
                return;
            }
            while ((info = this.connections.pollFirst()) != null) {
                try {
                    this.dbManager.freeConnection(info.connKey);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Error freeing Connection " + info.connKey), (Throwable)e);
                }
            }
            this.connections = null;
            this.dbManager = null;
        }
    }

    @Override
    public DbServerType getDbServerType() {
        return this.dbServerType;
    }

    @Override
    public boolean isMaximoDB() {
        return true;
    }

    private static class ConnectionInfo {
        @NotNull
        private final ConnectionKey connKey;
        @NotNull
        private final Connection connection;

        public ConnectionInfo(@NotNull ConnectionKey connectionKey, @NotNull Connection connection) {
            this.connKey = connectionKey;
            this.connection = connection;
        }
    }
}

