/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util.db;

import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.PropUtils;
import com.interlocsolutions.maximo.notify.util.db.DbAccessorBase;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionAccessor;
import com.interlocsolutions.maximo.notify.util.db.DbServerType;
import com.interlocsolutions.maximo.notify.util.db.DefaultDbAccessor;
import com.interlocsolutions.maximo.notify.util.db.SqliteDbConnectionAccessor;
import com.interlocsolutions.maximo.notify.util.db.TomcatPoolDbConnectionAccessor;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class DbConnectionManager {
    public static final MXLogger LOGGER = NotifyConstants.INFORMER_LOGGER;
    public static final String PROP_JDBC_URL = "informer.db.queue.url";
    public static final String PROP_JDBC_USERNAME = "informer.db.queue.user";
    public static final String PROP_JDBC_PASSWORD = "informer.db.queue.pw";
    public static final String PROP_JDBC_CONN_POOL_INIT = "informer.db.queue.pool.init";
    public static final String PROP_JDBC_CONN_POOL_MIN_IDLE = "informer.db.queue.pool.minIdle";
    public static final String PROP_JDBC_CONN_POOL_MAX_IDLE = "informer.db.queue.pool.maxIdle";
    public static final String PROP_JDBC_CONN_POOL_MAX_ACTIVE = "informer.db.queue.pool.maxActive";
    public static final String PROP_JDBC_CONN_POOL_VALIDATION = "informer.db.queue.validationquery";
    public static final String PROP_JDBC_DRIVER = "informer.db.queue.driver";
    private static DbConnectionManager singleton;
    private DbConnectionAccessor dbAccessor;
    private DbConnectionAccessor maximoAccessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DbConnectionManager getInstance() throws SQLException, MXException, RemoteException {
        if (singleton != null) return singleton;
        Class<DbConnectionManager> clazz = DbConnectionManager.class;
        synchronized (DbConnectionManager.class) {
            if (singleton != null) return singleton;
            DbConnectionManager newInstance = new DbConnectionManager();
            try {
                newInstance.startup();
                singleton = newInstance;
            }
            catch (Exception e) {
                LOGGER.error((Object)("Failed to initialize " + DbConnectionManager.class.getName()), (Throwable)e);
                try {
                    newInstance.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() throws MXException, IOException, SQLException {
        DbConnectionManager dbConnectionManager = this;
        synchronized (dbConnectionManager) {
            DbAccessorBase newDbAccessor;
            if (this.maximoAccessor == null) {
                this.maximoAccessor = new DefaultDbAccessor();
            }
            if (this.dbAccessor != null) {
                return;
            }
            String jdbcString = PropUtils.getMaxProp(PROP_JDBC_URL, null);
            String dbUser = PropUtils.getMaxProp(PROP_JDBC_USERNAME, null);
            String dbPass = PropUtils.getMaxProp(PROP_JDBC_PASSWORD, null);
            int poolInit = PropUtils.getIntMaxProp(PROP_JDBC_CONN_POOL_INIT, 5);
            int poolMinIdle = PropUtils.getIntMaxProp(PROP_JDBC_CONN_POOL_MIN_IDLE, 5);
            int poolMaxIdle = PropUtils.getIntMaxProp(PROP_JDBC_CONN_POOL_MAX_IDLE, 10);
            int poolMaxActive = PropUtils.getIntMaxProp(PROP_JDBC_CONN_POOL_MAX_ACTIVE, 20);
            String validationQuery = PropUtils.getMaxProp(PROP_JDBC_CONN_POOL_VALIDATION, null);
            boolean useMXDb = false;
            if (jdbcString == null) {
                newDbAccessor = new DefaultDbAccessor();
            } else if (jdbcString.startsWith("jdbc:sqlite:")) {
                String jdbcDriverClassName = PropUtils.getMaxProp(PROP_JDBC_DRIVER, "org.sqlite.JDBC");
                newDbAccessor = new SqliteDbConnectionAccessor(jdbcString, jdbcDriverClassName);
            } else if (jdbcString.startsWith("jdbc:oracle:")) {
                String jdbcDriverClassName = PropUtils.getMaxProp(PROP_JDBC_DRIVER, "oracle.jdbc.OracleDriver");
                newDbAccessor = new TomcatPoolDbConnectionAccessor(DbServerType.ORACLE, jdbcDriverClassName, jdbcString, dbUser, dbPass, poolInit, poolMinIdle, poolMaxIdle, poolMaxActive, validationQuery, true);
            } else if (jdbcString.startsWith("jdbc:db2:")) {
                String jdbcDriverClassName = PropUtils.getMaxProp(PROP_JDBC_DRIVER, "com.ibm.db2.jcc.DB2Driver");
                newDbAccessor = new TomcatPoolDbConnectionAccessor(DbServerType.DB2, jdbcDriverClassName, jdbcString, dbUser, dbPass, poolInit, poolMinIdle, poolMaxIdle, poolMaxActive, validationQuery, true);
            } else if (jdbcString.startsWith("jdbc:mysql:")) {
                String jdbcDriverClassName = PropUtils.getMaxProp(PROP_JDBC_DRIVER, "com.mysql.jdbc.Driver");
                newDbAccessor = new TomcatPoolDbConnectionAccessor(DbServerType.MYSQL, jdbcDriverClassName, jdbcString, dbUser, dbPass, poolInit, poolMinIdle, poolMaxIdle, poolMaxActive, validationQuery, true);
            } else if (jdbcString.startsWith("jdbc:sqlserver:")) {
                String jdbcDriverClassName = PropUtils.getMaxProp(PROP_JDBC_DRIVER, "com.microsoft.sqlserver.jdbc.SQLServerDriver");
                newDbAccessor = new TomcatPoolDbConnectionAccessor(DbServerType.MSSQL, jdbcDriverClassName, jdbcString, dbUser, dbPass, poolInit, poolMinIdle, poolMaxIdle, poolMaxActive, validationQuery, true);
            } else if (jdbcString.startsWith("jdbc:postgresql:")) {
                String jdbcDriverClassName = PropUtils.getMaxProp(PROP_JDBC_DRIVER, "org.postgresql.Driver");
                newDbAccessor = new TomcatPoolDbConnectionAccessor(DbServerType.POSTGRESQL, jdbcDriverClassName, jdbcString, dbUser, dbPass, poolInit, poolMinIdle, poolMaxIdle, poolMaxActive, validationQuery, true);
            } else {
                LOGGER.error((Object)("Database at " + jdbcString + " (specified via " + PROP_JDBC_URL + ") is of an unrecognized and unsupported type. Maximo's database will be used."));
                newDbAccessor = new DefaultDbAccessor();
            }
            this.dbAccessor = newDbAccessor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbConnectionAccessor getMaximoConnection() throws MXException, RemoteException, SQLException {
        if (this.maximoAccessor == null) {
            DbConnectionManager dbConnectionManager = this;
            synchronized (dbConnectionManager) {
                if (this.maximoAccessor == null) {
                    throw new SQLException("SQL connection has not been initialized");
                }
            }
        }
        return this.maximoAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbConnectionAccessor getQueueConnection() throws MXException, RemoteException, SQLException {
        if (this.dbAccessor == null) {
            DbConnectionManager dbConnectionManager = this;
            synchronized (dbConnectionManager) {
                if (this.dbAccessor == null) {
                    throw new SQLException("SQL connection has not been initialized");
                }
            }
        }
        return this.dbAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        DbConnectionManager dbConnectionManager = this;
        synchronized (dbConnectionManager) {
            if (this.maximoAccessor != null) {
                this.maximoAccessor.destroy();
                this.maximoAccessor = null;
            }
            if (this.dbAccessor != null) {
                this.dbAccessor.destroy();
                this.dbAccessor = null;
            }
        }
    }
}

