/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util.attachment;

import com.interlocsolutions.maximo.notify.FileFragment;
import com.interlocsolutions.maximo.notify.err.InformerException;
import com.interlocsolutions.maximo.notify.util.AttachedDocumentProvider;
import com.interlocsolutions.maximo.notify.util.InformerProp;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyFault;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import com.interlocsolutions.maximo.notify.util.attachment.IAttachmentService;
import com.interlocsolutions.maximo.notify.util.codec.Base64;
import com.interlocsolutions.maximo.notify.xml.AttachedDocumentFragment;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u001b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0012\u0010\u001c\u001a\u00020\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\tH\u0002J\u0018\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/interlocsolutions/maximo/notify/util/attachment/FileAttachmentService;", "Lcom/interlocsolutions/maximo/notify/util/attachment/IAttachmentService;", "()V", "logger", "Lpsdi/util/logging/MXLogger;", "kotlin.jvm.PlatformType", "createDirectoryIfNotExists", "", "path", "", "determineFilePath", "docTypeSet", "Lpsdi/mbo/MboSetRemote;", "defPath", "generateUniqueFilePath", "filePath", "fileFragment", "Lcom/interlocsolutions/maximo/notify/FileFragment;", "getAttachedDocument", "Lcom/interlocsolutions/maximo/notify/xml/AttachedDocumentFragment;", "docInfo", "Lpsdi/mbo/MboRemote;", "offset", "", "length", "", "getPreparedDestinationPath", "handleEmptyDocType", "mkdirOrThrow", "directory", "Ljava/io/File;", "moveFileToDestinationFilePath", "currentFilePath", "normalizeFilePaths", "basePath", "subPath", "writeFile", "destinationFilePath", "isinformer"})
public final class FileAttachmentService
implements IAttachmentService {
    private final MXLogger logger = NotifyConstants.INFORMER_LOGGER;

    @Override
    @NotNull
    public String getPreparedDestinationPath(@NotNull FileFragment fileFragment) {
        SqlFormat sqlFormat;
        Intrinsics.checkNotNullParameter((Object)fileFragment, (String)"fileFragment");
        Object object = PropUtil.INSTANCE.getProp("mxe.doclink.doctypes.defpath");
        if (object == null || (object = ((InformerProp)object).asString()) == null) {
            object = "";
        }
        Object filePath = object;
        SqlFormat $this$getPreparedDestinationPath_u24lambda_u240 = sqlFormat = new SqlFormat("doctype = :1");
        boolean bl = false;
        $this$getPreparedDestinationPath_u24lambda_u240.setObject(1, "DOCTYPES", "DOCTYPE", fileFragment.getString("DOCTYPE"));
        SqlFormat sqlFormat2 = sqlFormat;
        MboSetRemote mboSetRemote = fileFragment.getMboSet("$doctypes", "DOCTYPES", sqlFormat2.format());
        Intrinsics.checkNotNullExpressionValue((Object)mboSetRemote, (String)"fileFragment.getMboSet(\"\u2026PES\", sqlFormat.format())");
        MboSetRemote docTypeSet = mboSetRemote;
        MXLogger mXLogger = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
        MXLogger $this$debugLazy_u24default$iv = mXLogger;
        Object e$iv = null;
        boolean $i$f$debugLazy = false;
        if ($this$debugLazy_u24default$iv.isDebugEnabled()) {
            Object object2;
            try {
                boolean bl2 = false;
                object2 = Result.constructor-impl((Object)("Writing file from Informer, looking for doctype with where clause: " + docTypeSet.getCompleteWhere()));
            }
            catch (Throwable throwable) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            String string = "(Unable to form error msg)";
            String msg$iv = (String)(Result.isFailure-impl((Object)object2) ? string : object2);
            $this$debugLazy_u24default$iv.debug((Object)msg$iv);
        }
        if (docTypeSet.isEmpty()) {
            this.handleEmptyDocType(docTypeSet, fileFragment, (String)filePath);
        }
        filePath = this.determineFilePath(docTypeSet, (String)filePath);
        this.createDirectoryIfNotExists((String)filePath);
        return this.generateUniqueFilePath((String)filePath, fileFragment);
    }

    private final void handleEmptyDocType(MboSetRemote docTypeSet, FileFragment fileFragment, String filePath) {
        String msg$iv;
        Object object;
        MXLogger mXLogger = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
        MXLogger $this$debugLazy_u24default$iv = mXLogger;
        MboRemote e$iv = null;
        boolean $i$f$debugLazy = false;
        if ($this$debugLazy_u24default$iv.isDebugEnabled()) {
            Object $i$a$-debugLazy$default-FileAttachmentService$handleEmptyDocType$32;
            try {
                boolean $i$a$-debugLazy$default-FileAttachmentService$handleEmptyDocType$32 = false;
                $i$a$-debugLazy$default-FileAttachmentService$handleEmptyDocType$32 = Result.constructor-impl((Object)("Doctype " + fileFragment.getString("DOCTYPE") + " does not exist."));
            }
            catch (Throwable throwable) {
                $i$a$-debugLazy$default-FileAttachmentService$handleEmptyDocType$32 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object = "(Unable to form error msg)";
            msg$iv = (String)(Result.isFailure-impl((Object)$i$a$-debugLazy$default-FileAttachmentService$handleEmptyDocType$32) ? object : $i$a$-debugLazy$default-FileAttachmentService$handleEmptyDocType$32);
            $this$debugLazy_u24default$iv.debug((Object)msg$iv);
        }
        InformerProp informerProp = PropUtil.INSTANCE.getProp("informer.doctype.autocreate");
        boolean bl = informerProp != null ? !informerProp.asBoolean(false) : false;
        if (bl) {
            throw new InformerException("invalidDocType");
        }
        MXLogger mXLogger2 = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)mXLogger2, (String)"logger");
        $this$debugLazy_u24default$iv = mXLogger2;
        e$iv = null;
        $i$f$debugLazy = false;
        if ($this$debugLazy_u24default$iv.isDebugEnabled()) {
            Object $i$a$-debugLazy$default-FileAttachmentService$handleEmptyDocType$52;
            try {
                boolean $i$a$-debugLazy$default-FileAttachmentService$handleEmptyDocType$52 = false;
                $i$a$-debugLazy$default-FileAttachmentService$handleEmptyDocType$52 = Result.constructor-impl((Object)("Auto-creating document type for doctype " + fileFragment.getString("DOCTYPE")));
            }
            catch (Throwable throwable) {
                $i$a$-debugLazy$default-FileAttachmentService$handleEmptyDocType$52 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object = "(Unable to form error msg)";
            msg$iv = (String)(Result.isFailure-impl((Object)$i$a$-debugLazy$default-FileAttachmentService$handleEmptyDocType$52) ? object : $i$a$-debugLazy$default-FileAttachmentService$handleEmptyDocType$52);
            $this$debugLazy_u24default$iv.debug((Object)msg$iv);
        }
        String adjustedPath = StringsKt.endsWith$default((String)filePath, (String)"/", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath, (String)"\\", (boolean)false, (int)2, null) ? filePath : filePath + File.separator;
        MboRemote $this$handleEmptyDocType_u24lambda_u244 = e$iv = docTypeSet.add();
        boolean bl2 = false;
        $this$handleEmptyDocType_u24lambda_u244.setValue("DOCTYPE", fileFragment.getString("DOCTYPE"));
        $this$handleEmptyDocType_u24lambda_u244.setValue("DEFAULTFILEPATH", adjustedPath + fileFragment.getString("DOCTYPE"));
        docTypeSet.save();
        docTypeSet.reset();
        MXLogger mXLogger3 = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)mXLogger3, (String)"logger");
        MXLogger $this$debugLazy_u24default$iv2 = mXLogger3;
        Object e$iv2 = null;
        boolean $i$f$debugLazy2 = false;
        if ($this$debugLazy_u24default$iv2.isDebugEnabled()) {
            try {
                boolean bl3 = false;
                object = Result.constructor-impl((Object)("Document type created with file path " + adjustedPath));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            String string = "(Unable to form error msg)";
            String msg$iv2 = (String)(Result.isFailure-impl((Object)object) ? string : object);
            $this$debugLazy_u24default$iv2.debug((Object)msg$iv2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final String determineFilePath(MboSetRemote docTypeSet, String defPath) {
        docType = docTypeSet.getMbo(0);
        filePath = docType.getString("DEFAULTFILEPATH");
        if (new File(filePath).exists()) ** GOTO lbl-1000
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"filePath");
        if (!StringsKt.startsWith$default((String)filePath, (String)defPath, (boolean)false, (int)2, null)) {
            v0 = this.normalizeFilePaths(defPath, filePath);
        } else lbl-1000:
        // 2 sources

        {
            v0 = filePath;
        }
        finalPath = v0;
        Intrinsics.checkNotNullExpressionValue((Object)finalPath, (String)"finalPath");
        return StringsKt.endsWith$default((String)finalPath, (String)"/", (boolean)false, (int)2, null) != false || StringsKt.endsWith$default((String)finalPath, (String)"\\", (boolean)false, (int)2, null) != false ? finalPath : finalPath + File.separator;
    }

    private final String normalizeFilePaths(String basePath, String subPath) {
        String string;
        if (Intrinsics.areEqual((Object)File.separator, (Object)"/")) {
            if (StringsKt.endsWith$default((String)basePath, (String)"/", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)subPath, (String)"/", (boolean)false, (int)2, null)) {
                StringBuilder stringBuilder = new StringBuilder().append(basePath);
                String string2 = subPath.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                string = stringBuilder.append(string2).toString();
            } else {
                string = !StringsKt.endsWith$default((String)basePath, (String)"/", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)subPath, (String)"/", (boolean)false, (int)2, null) ? basePath + '/' + subPath : basePath + subPath;
            }
        } else if (StringsKt.endsWith$default((String)basePath, (String)"\\", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)subPath, (String)"\\", (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder = new StringBuilder().append(basePath);
            String string3 = subPath.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            string = stringBuilder.append(string3).toString();
        } else {
            string = !StringsKt.endsWith$default((String)basePath, (String)"\\", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)subPath, (String)"\\", (boolean)false, (int)2, null) ? basePath + '\\' + subPath : basePath + subPath;
        }
        return string;
    }

    private final void createDirectoryIfNotExists(String path) {
        File directory = new File(path);
        if (!directory.exists()) {
            MXLogger mXLogger = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
            MXLogger $this$debugLazy_u24default$iv = mXLogger;
            Object e$iv = null;
            boolean $i$f$debugLazy = false;
            if ($this$debugLazy_u24default$iv.isDebugEnabled()) {
                Object object;
                try {
                    boolean bl = false;
                    object = Result.constructor-impl((Object)("Creating directory: " + directory.getPath()));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                String string = "(Unable to form error msg)";
                String msg$iv = (String)(Result.isFailure-impl((Object)object) ? string : object);
                $this$debugLazy_u24default$iv.debug((Object)msg$iv);
            }
            directory.mkdirs();
        }
    }

    private final String generateUniqueFilePath(String filePath, FileFragment fileFragment) {
        String fullFilePath = filePath + fileFragment.getString("FILENAME");
        File file = null;
        file = new File(fullFilePath);
        if (file.exists()) {
            CharSequence charSequence;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            CharSequence charSequence2 = StringsKt.substringBeforeLast((String)string, (char)'.', (String)"");
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = file.getName();
            } else {
                charSequence = charSequence2;
            }
            String nameWithoutExt = (String)charSequence;
            String string2 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.name");
            String extension = StringsKt.substringAfterLast((String)string2, (char)'.', (String)"");
            String timestamp = "" + '_' + System.currentTimeMillis();
            String uniqueName = ((CharSequence)extension).length() > 0 ? nameWithoutExt + timestamp + '.' + extension : nameWithoutExt + timestamp;
            file = new File(file.getParent(), uniqueName);
        }
        file.getParentFile().mkdirs();
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFile(@NotNull String destinationFilePath, @NotNull FileFragment fileFragment) {
        Intrinsics.checkNotNullParameter((Object)destinationFilePath, (String)"destinationFilePath");
        Intrinsics.checkNotNullParameter((Object)fileFragment, (String)"fileFragment");
        Object object = new File(destinationFilePath);
        File $this$writeFile_u24lambda_u248 = object;
        boolean bl = false;
        this.mkdirOrThrow($this$writeFile_u24lambda_u248.getParentFile());
        File destFile = object;
        object = new FileOutputStream(destFile);
        Throwable throwable = null;
        try {
            FileOutputStream fos = (FileOutputStream)object;
            boolean bl2 = false;
            fos.write(fileFragment.getBytes("DATA"));
            fos.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public String moveFileToDestinationFilePath(@NotNull String currentFilePath, @NotNull FileFragment fileFragment) {
        Intrinsics.checkNotNullParameter((Object)currentFilePath, (String)"currentFilePath");
        Intrinsics.checkNotNullParameter((Object)fileFragment, (String)"fileFragment");
        File sourceFile = new File(currentFilePath);
        File destinationFile = new File(this.getPreparedDestinationPath(fileFragment));
        try {
            this.mkdirOrThrow(destinationFile.getParentFile());
            if (!sourceFile.renameTo(destinationFile)) {
                throw new IOException("Failed to move file from " + sourceFile + " to " + destinationFile);
            }
        }
        catch (IOException e) {
            Object[] objectArray = new String[]{"Failed to move file to " + destinationFile};
            throw new InformerException("fileFragmentIOError", objectArray, e);
        }
        String string = destinationFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"destinationFile.path");
        return string;
    }

    private final void mkdirOrThrow(File directory) {
        if (directory == null) {
            throw new IOException("Cannot create a null directory");
        }
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Failed to create directory: " + directory.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public AttachedDocumentFragment getAttachedDocument(@NotNull MboRemote docInfo, long offset, int length) {
        Object $this$getAttachedDocument_u24lambda_u2410;
        Intrinsics.checkNotNullParameter((Object)docInfo, (String)"docInfo");
        Object object = this;
        try {
            $this$getAttachedDocument_u24lambda_u2410 = object;
            boolean bl = false;
            $this$getAttachedDocument_u24lambda_u2410 = Result.constructor-impl((Object)new File(docInfo.getString("URLNAME")));
        }
        catch (Throwable bl) {
            $this$getAttachedDocument_u24lambda_u2410 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$getAttachedDocument_u24lambda_u2410;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable e = throwable;
            boolean bl = false;
            MXLogger mXLogger = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
            Object $this$errorLazy$iv = mXLogger;
            boolean $i$f$errorLazy = false;
            if ($this$errorLazy$iv.isErrorEnabled()) {
                Object $i$a$-errorLazy-FileAttachmentService$getAttachedDocument$file$2$22;
                try {
                    boolean $i$a$-errorLazy-FileAttachmentService$getAttachedDocument$file$2$22 = false;
                    $i$a$-errorLazy-FileAttachmentService$getAttachedDocument$file$2$22 = Result.constructor-impl((Object)("Failed to read file " + docInfo.getString("URLNAME") + '.'));
                }
                catch (Throwable throwable2) {
                    $i$a$-errorLazy-FileAttachmentService$getAttachedDocument$file$2$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                String string = "(Unable to form error msg)";
                String msg$iv = (String)(Result.isFailure-impl((Object)$i$a$-errorLazy-FileAttachmentService$getAttachedDocument$file$2$22) ? string : $i$a$-errorLazy-FileAttachmentService$getAttachedDocument$file$2$22);
                if (e != null) {
                    $this$errorLazy$iv.error((Object)msg$iv, e);
                } else {
                    $this$errorLazy$iv.error((Object)msg$iv);
                }
            }
            Object $this$getAttachedDocument_u24lambda_u2413_u24lambda_u2412 = $this$errorLazy$iv = new NotifyFault(AttachedDocumentProvider.ERROR_CODE.FILE_NOT_FOUND.toString());
            boolean bl2 = false;
            ((NotifyFault)((Object)$this$getAttachedDocument_u24lambda_u2413_u24lambda_u2412)).setErrorCode(AttachedDocumentProvider.ERROR_CODE.FILE_NOT_FOUND.toString());
            throw (Throwable)$this$errorLazy$iv;
        }
        File file = (File)object;
        if (!file.exists()) {
            MXLogger mXLogger = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
            MXLogger $this$errorLazy_u24default$iv = mXLogger;
            Object e$iv = null;
            boolean $i$f$errorLazy = false;
            if ($this$errorLazy_u24default$iv.isErrorEnabled()) {
                Object $i$a$-errorLazy$default-FileAttachmentService$getAttachedDocument$22;
                try {
                    boolean $i$a$-errorLazy$default-FileAttachmentService$getAttachedDocument$22 = false;
                    $i$a$-errorLazy$default-FileAttachmentService$getAttachedDocument$22 = Result.constructor-impl((Object)("File " + docInfo.getString("URLNAME") + " does not exist."));
                }
                catch (Throwable $this$getAttachedDocument_u24lambda_u2413_u24lambda_u2412) {
                    $i$a$-errorLazy$default-FileAttachmentService$getAttachedDocument$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$getAttachedDocument_u24lambda_u2413_u24lambda_u2412));
                }
                String $this$getAttachedDocument_u24lambda_u2413_u24lambda_u2412 = "(Unable to form error msg)";
                String msg$iv = (String)(Result.isFailure-impl((Object)$i$a$-errorLazy$default-FileAttachmentService$getAttachedDocument$22) ? $this$getAttachedDocument_u24lambda_u2413_u24lambda_u2412 : $i$a$-errorLazy$default-FileAttachmentService$getAttachedDocument$22);
                $this$errorLazy_u24default$iv.error((Object)msg$iv);
            }
            Object $this$getAttachedDocument_u24lambda_u2415 = object = new NotifyFault(AttachedDocumentProvider.ERROR_CODE.FILE_NOT_FOUND.toString());
            boolean bl = false;
            ((NotifyFault)((Object)$this$getAttachedDocument_u24lambda_u2415)).setErrorCode(AttachedDocumentProvider.ERROR_CODE.FILE_NOT_FOUND.toString());
            throw (Throwable)object;
        }
        object = new FileInputStream(file);
        Throwable throwable3 = null;
        try {
            byte[] byArray;
            FileInputStream fis = (FileInputStream)object;
            boolean bl = false;
            fis.skip(offset);
            byte[] result = new byte[length];
            int res = fis.read(result);
            if (res < 0) {
                byArray = new byte[]{};
            } else if (res < length) {
                byte[] byArray2 = Arrays.copyOf(result, res);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, newSize)");
            } else {
                byArray = result;
            }
            result = byArray;
            AttachedDocumentFragment attachedDocumentFragment = new AttachedDocumentFragment(docInfo.getUniqueIDValue(), file.length(), offset, result.length, Base64.encodeBase64String(result));
            return attachedDocumentFragment;
        }
        catch (Throwable throwable4) {
            throwable3 = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable3);
        }
    }
}

