/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util.attachment;

import com.ibm.tivoli.maximo.oslc.FileExtensionCache;
import com.ibm.tivoli.maximo.oslc.provider.COSAttachmentStorage;
import com.interlocsolutions.maximo.notify.FileFragment;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.attachment.IAttachmentService;
import com.interlocsolutions.maximo.notify.util.codec.Base64;
import com.interlocsolutions.maximo.notify.xml.AttachedDocumentFragment;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/interlocsolutions/maximo/notify/util/attachment/COSAttachmentService;", "Lcom/interlocsolutions/maximo/notify/util/attachment/IAttachmentService;", "()V", "cosAttachmentStorage", "Lcom/ibm/tivoli/maximo/oslc/provider/COSAttachmentStorage;", "logger", "Lpsdi/util/logging/MXLogger;", "kotlin.jvm.PlatformType", "getAttachedDocument", "Lcom/interlocsolutions/maximo/notify/xml/AttachedDocumentFragment;", "docInfo", "Lpsdi/mbo/MboRemote;", "offset", "", "length", "", "getContentType", "", "fileFragment", "Lcom/interlocsolutions/maximo/notify/FileFragment;", "getPreparedDestinationPath", "moveFileToDestinationFilePath", "currentFilePath", "writeFile", "", "destinationFilePath", "isinformer"})
public final class COSAttachmentService
implements IAttachmentService {
    @NotNull
    private final COSAttachmentStorage cosAttachmentStorage = new COSAttachmentStorage();
    private final MXLogger logger = NotifyConstants.INFORMER_LOGGER;

    @Override
    @NotNull
    public String getPreparedDestinationPath(@NotNull FileFragment fileFragment) {
        Intrinsics.checkNotNullParameter((Object)fileFragment, (String)"fileFragment");
        String string = this.cosAttachmentStorage.getAttachmentQualifiedName(null, fileFragment.getString("FILENAME"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cosAttachmentStorage.get\u2026nt.getString(\"FILENAME\"))");
        return string;
    }

    @Override
    public void writeFile(@NotNull String destinationFilePath, @NotNull FileFragment fileFragment) {
        Intrinsics.checkNotNullParameter((Object)destinationFilePath, (String)"destinationFilePath");
        Intrinsics.checkNotNullParameter((Object)fileFragment, (String)"fileFragment");
        this.cosAttachmentStorage.createAttachment(destinationFilePath, fileFragment.getBytes("DATA"), this.getContentType(fileFragment));
    }

    private final String getContentType(FileFragment fileFragment) {
        FileExtensionCache feCache = FileExtensionCache.getInstance();
        String contentTypeOnUrlName = feCache.forFileName(fileFragment.getString("FILENAME"));
        Intrinsics.checkNotNullExpressionValue((Object)contentTypeOnUrlName, (String)"contentTypeOnUrlName");
        return contentTypeOnUrlName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String moveFileToDestinationFilePath(@NotNull String currentFilePath, @NotNull FileFragment fileFragment) {
        String destinationFilePath;
        block7: {
            void $this$errorLazy$iv;
            Object object;
            Intrinsics.checkNotNullParameter((Object)currentFilePath, (String)"currentFilePath");
            Intrinsics.checkNotNullParameter((Object)fileFragment, (String)"fileFragment");
            destinationFilePath = this.getPreparedDestinationPath(fileFragment);
            File it = new File(currentFilePath);
            boolean bl = false;
            this.cosAttachmentStorage.createAttachment(destinationFilePath, FilesKt.readBytes((File)it), this.getContentType(fileFragment));
            Object object2 = this;
            try {
                COSAttachmentService $this$moveFileToDestinationFilePath_u24lambda_u243_u24lambda_u240 = object2;
                boolean bl2 = false;
                object = Result.constructor-impl((Object)it.delete());
            }
            catch (Throwable bl2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block7;
            Object e = object = throwable;
            boolean bl3 = false;
            MXLogger mXLogger = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)mXLogger, (String)"logger");
            MXLogger mXLogger2 = mXLogger;
            Throwable e$iv = e instanceof SecurityException ? (SecurityException)e : null;
            boolean $i$f$errorLazy = false;
            if ($this$errorLazy$iv.isErrorEnabled()) {
                Object object3;
                try {
                    boolean bl4 = false;
                    object3 = Result.constructor-impl((Object)("Failed to delete file " + currentFilePath));
                }
                catch (Throwable throwable2) {
                    object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                String string = "(Unable to form error msg)";
                String msg$iv = (String)(Result.isFailure-impl((Object)object3) ? string : object3);
                if (e$iv != null) {
                    $this$errorLazy$iv.error((Object)msg$iv, e$iv);
                } else {
                    $this$errorLazy$iv.error((Object)msg$iv);
                }
            }
        }
        return destinationFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public AttachedDocumentFragment getAttachedDocument(@NotNull MboRemote docInfo, long offset, int length) {
        Intrinsics.checkNotNullParameter((Object)docInfo, (String)"docInfo");
        byte[] attachmentBytes = this.cosAttachmentStorage.getAttachment(docInfo.getString("URLNAME"));
        Closeable closeable = new ByteArrayInputStream(attachmentBytes);
        Throwable throwable = null;
        try {
            byte[] byArray;
            ByteArrayInputStream attachmentStream = (ByteArrayInputStream)closeable;
            boolean bl = false;
            attachmentStream.skip(offset);
            byte[] result = new byte[length];
            int res = attachmentStream.read(result);
            if (res < 0) {
                byArray = new byte[]{};
            } else if (res < length) {
                byte[] byArray2 = Arrays.copyOf(result, res);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, newSize)");
            } else {
                byArray = result;
            }
            result = byArray;
            AttachedDocumentFragment attachedDocumentFragment = new AttachedDocumentFragment(docInfo.getUniqueIDValue(), attachmentBytes.length, offset, result.length, Base64.encodeBase64String(result));
            return attachedDocumentFragment;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

