/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WeakReferenceSet<T>
implements Set<T> {
    private final List<WeakReference<T>> weakRefs = new LinkedList<WeakReference<T>>();

    @Override
    public synchronized int size() {
        int count = 0;
        for (Object ignored : this) {
            ++count;
        }
        return count;
    }

    @Override
    public synchronized boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public synchronized boolean contains(Object o) {
        for (Object t : this) {
            if (!t.equals(o)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public WeakRefCleaningItr iterator() {
        return new WeakRefCleaningItr();
    }

    private synchronized List<T> toValList() {
        ArrayList valList = new ArrayList(this.weakRefs.size());
        ListIterator<WeakReference<T>> itr = this.weakRefs.listIterator();
        while (itr.hasNext()) {
            Object val = itr.next().get();
            if (val == null) {
                itr.remove();
                continue;
            }
            valList.add(val);
        }
        return valList;
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.toValList().toArray();
    }

    @Override
    @NotNull
    public <T1> T1[] toArray(@NotNull T1[] a) {
        return this.toValList().toArray(a);
    }

    @Override
    public synchronized boolean add(T t) {
        return t != null && !this.contains(t) && this.weakRefs.add(new WeakReference<T>(t));
    }

    @Override
    public synchronized boolean remove(Object o) {
        WeakRefCleaningItr itr = this.iterator();
        while (itr.hasNext()) {
            Object val = itr.next();
            if (!val.equals(o)) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean containsAll(@NotNull Collection<?> coll) {
        for (Object obj : coll) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean addAll(@NotNull Collection<? extends T> coll) {
        boolean changed = false;
        for (T obj : coll) {
            changed |= this.add(obj);
        }
        return changed;
    }

    @Override
    public synchronized boolean retainAll(@NotNull Collection<?> c) {
        boolean result = false;
        WeakRefCleaningItr itr = this.iterator();
        while (itr.hasNext()) {
            if (c.contains(itr.next())) continue;
            itr.remove();
            result = true;
        }
        return result;
    }

    @Override
    public synchronized boolean removeAll(@NotNull Collection<?> coll) {
        boolean result = false;
        WeakRefCleaningItr itr = this.iterator();
        while (itr.hasNext()) {
            Object val = itr.next();
            if (!coll.contains(val)) continue;
            itr.remove();
            result = true;
        }
        return result;
    }

    @Override
    public synchronized void clear() {
        this.weakRefs.clear();
    }

    private class WeakRefCleaningItr
    implements Iterator<T> {
        private ListIterator<WeakReference<T>> innerItr;
        private T nextVal;

        private WeakRefCleaningItr() {
            this.innerItr = WeakReferenceSet.this.weakRefs.listIterator();
        }

        @Override
        public boolean hasNext() {
            if (this.nextVal == null && this.innerItr.hasNext()) {
                try {
                    this.nextVal = this.next();
                }
                catch (NoSuchElementException e) {
                    this.nextVal = null;
                }
            }
            return this.nextVal != null;
        }

        @Override
        @NotNull
        public T next() {
            if (this.nextVal != null) {
                Object val = this.nextVal;
                this.nextVal = null;
                return val;
            }
            while (this.innerItr.hasNext()) {
                Object val = this.innerItr.next().get();
                if (val == null) {
                    this.innerItr.remove();
                    continue;
                }
                return val;
            }
            throw new NoSuchElementException("No more values");
        }

        @Override
        public void remove() {
            this.innerItr.remove();
        }
    }
}

