/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J/\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000f\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\u0011\u001a\u00020\u00032\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0013\u001a\u00020\u0003J\u001a\u0010\u0014\u001a\u00060\u0015R\u00020\u00002\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/interlocsolutions/maximo/notify/util/TimeReporter;", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "operations", "", "Lcom/interlocsolutions/maximo/notify/util/TimeReporter$Operation;", "measured", "R", "group", "label", "block", "Lkotlin/Function0;", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "report", "margin", "eachIndent", "timer", "Lcom/interlocsolutions/maximo/notify/util/TimeReporter$Timer;", "Operation", "Timer", "isinformer"})
public final class TimeReporter {
    @NotNull
    private final String name;
    @NotNull
    private List<Operation> operations;

    public TimeReporter(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.operations = new ArrayList();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Timer timer(@NotNull String group, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return new Timer(group, label);
    }

    public final <R> R measured(@NotNull String group, @NotNull String label, @NotNull Function0<? extends R> block) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        long mark = System.currentTimeMillis();
        Object value = block.invoke();
        long duration = System.currentTimeMillis() - mark;
        this.operations.add(new Operation(group, label, duration));
        return (R)value;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String report(@Nullable String margin, @NotNull String eachIndent) {
        void $this$groupByTo$iv$iv;
        void $this$newLine$iv;
        StringBuilder $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)eachIndent, (String)"eachIndent");
        StringBuilder sb = new StringBuilder();
        Iterable iterable = this.operations;
        long initial$iv = 0L;
        boolean $i$f$fold = false;
        long accumulator$iv = initial$iv;
        Iterator iterator = $this$fold$iv.iterator();
        while (iterator.hasNext()) {
            void operation;
            Object element$iv = iterator.next();
            Operation operation2 = (Operation)element$iv;
            long runningTotal = accumulator$iv;
            boolean bl = false;
            accumulator$iv = runningTotal + operation.getDuration();
        }
        long totalDuration = accumulator$iv;
        $this$fold$iv = sb;
        int indentLevel$iv = 0;
        boolean $i$f$newLine = false;
        $this$newLine$iv.append('\n');
        if (margin != null) {
            $this$newLine$iv.append(margin);
        }
        int n = indentLevel$iv;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            $this$newLine$iv.append(eachIndent);
        }
        $this$newLine$iv.append(this.name).append(" -- Total Duration: ").append(totalDuration).append("ms");
        Iterable $this$groupBy$iv = this.operations;
        boolean $i$f$groupBy = false;
        Iterable i$iv = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Operation it = (Operation)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getGroup();
            Map $this$getOrPut$iv$iv$iv22 = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv22.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv22.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map groups = destination$iv$iv;
        for (Map.Entry entry : groups.entrySet()) {
            void $this$newLine$iv2;
            StringBuilder $this$fold$iv2;
            String group = (String)entry.getKey();
            List groupOperations = (List)entry.getValue();
            Iterable element$iv$iv = groupOperations;
            long initial$iv2 = 0L;
            boolean $i$f$fold2 = false;
            long accumulator$iv2 = initial$iv2;
            Iterator $this$getOrPut$iv$iv$iv22 = $this$fold$iv2.iterator();
            while ($this$getOrPut$iv$iv$iv22.hasNext()) {
                void operation;
                Object element$iv = $this$getOrPut$iv$iv$iv22.next();
                Operation value$iv$iv$iv = (Operation)element$iv;
                long runningTotal = accumulator$iv2;
                boolean bl = false;
                accumulator$iv2 = runningTotal + operation.getDuration();
            }
            long groupTotalDuration = accumulator$iv2;
            $this$fold$iv2 = sb;
            int indentLevel$iv2 = 1;
            boolean $i$f$newLine22 = false;
            $this$newLine$iv2.append('\n');
            if (margin != null) {
                $this$newLine$iv2.append(margin);
            }
            int $this$getOrPut$iv$iv$iv22 = indentLevel$iv2;
            for (int i$iv2 = 0; i$iv2 < $this$getOrPut$iv$iv$iv22; ++i$iv2) {
                $this$newLine$iv2.append(eachIndent);
            }
            $this$newLine$iv2.append(group).append(": ").append(groupTotalDuration).append("ms");
            for (Operation operation : groupOperations) {
                void $this$newLine$iv3;
                StringBuilder $i$f$newLine22 = sb;
                int indentLevel$iv3 = 2;
                boolean $i$f$newLine3 = false;
                $this$newLine$iv3.append('\n');
                if (margin != null) {
                    $this$newLine$iv3.append(margin);
                }
                int n2 = indentLevel$iv3;
                for (int i$iv3 = 0; i$iv3 < n2; ++i$iv3) {
                    $this$newLine$iv3.append(eachIndent);
                }
                $this$newLine$iv3.append(operation.getLabel()).append(": ").append(operation.getDuration()).append("ms");
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public static /* synthetic */ String report$default(TimeReporter timeReporter, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = "\t";
        }
        return timeReporter.report(string, string2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/interlocsolutions/maximo/notify/util/TimeReporter$Operation;", "", "group", "", "label", "duration", "", "(Ljava/lang/String;Ljava/lang/String;J)V", "getDuration", "()J", "getGroup", "()Ljava/lang/String;", "getLabel", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "isinformer"})
    private static final class Operation {
        @NotNull
        private final String group;
        @NotNull
        private final String label;
        private final long duration;

        public Operation(@NotNull String group, @NotNull String label, long duration) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            this.group = group;
            this.label = label;
            this.duration = duration;
        }

        @NotNull
        public final String getGroup() {
            return this.group;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public final long getDuration() {
            return this.duration;
        }

        @NotNull
        public final String component1() {
            return this.group;
        }

        @NotNull
        public final String component2() {
            return this.label;
        }

        public final long component3() {
            return this.duration;
        }

        @NotNull
        public final Operation copy(@NotNull String group, @NotNull String label, long duration) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            return new Operation(group, label, duration);
        }

        public static /* synthetic */ Operation copy$default(Operation operation, String string, String string2, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = operation.group;
            }
            if ((n & 2) != 0) {
                string2 = operation.label;
            }
            if ((n & 4) != 0) {
                l = operation.duration;
            }
            return operation.copy(string, string2, l);
        }

        @NotNull
        public String toString() {
            return "Operation(group=" + this.group + ", label=" + this.label + ", duration=" + this.duration + ')';
        }

        public int hashCode() {
            int result = this.group.hashCode();
            result = result * 31 + this.label.hashCode();
            result = result * 31 + Long.hashCode(this.duration);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Operation)) {
                return false;
            }
            Operation operation = (Operation)other;
            if (!Intrinsics.areEqual((Object)this.group, (Object)operation.group)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.label, (Object)operation.label)) {
                return false;
            }
            return this.duration == operation.duration;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/interlocsolutions/maximo/notify/util/TimeReporter$Timer;", "", "group", "", "label", "(Lcom/interlocsolutions/maximo/notify/util/TimeReporter;Ljava/lang/String;Ljava/lang/String;)V", "getGroup", "()Ljava/lang/String;", "getLabel", "mark", "", "finish", "", "start", "isinformer"})
    public final class Timer {
        @NotNull
        private final String group;
        @NotNull
        private final String label;
        private long mark;

        public Timer(@NotNull String group, String label) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            this.group = group;
            this.label = label;
        }

        @NotNull
        public final String getGroup() {
            return this.group;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public final void start() {
            this.mark = System.currentTimeMillis();
        }

        public final void finish() {
            long duration = System.currentTimeMillis() - this.mark;
            TimeReporter.this.operations.add(new Operation(this.group, this.label, duration));
        }
    }
}

