/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtils {
    public static String join(Iterable iterable, String separator) {
        return StringUtils.join(iterable, null, separator, null);
    }

    public static String join(Iterable iterable, String startCap, String separator, String endCap) {
        return StringUtils.join(iterable, startCap, null, separator, null, endCap);
    }

    public static String join(Iterable iterable, String startCap, String startEach, String separator, String endEach, String endCap) {
        StringBuilder sb = new StringBuilder();
        StringUtils.join(sb, iterable, startCap, startEach, separator, endEach, endCap);
        return sb.toString();
    }

    public static String join(Object[] array, String startCap, String separator, String endCap) {
        StringBuilder sb = new StringBuilder();
        StringUtils.join(sb, array, startCap, separator, endCap);
        return sb.toString();
    }

    public static void join(StringBuilder sb, Object[] array, String startCap, String separator, String endCap) {
        StringUtils.join(sb, Arrays.asList(array), startCap, separator, endCap);
    }

    public static void join(StringBuilder sb, Iterable iterable, String startCap, String separator, String endCap) {
        StringUtils.join(sb, iterable, startCap, null, separator, null, endCap);
    }

    public static void join(StringBuilder sb, Iterable iterable, String startCap, String startEach, String separator, String endEach, String endCap) {
        if (startCap != null) {
            sb.append(startCap);
        }
        boolean first = true;
        for (Object item : iterable) {
            if (first) {
                first = false;
            } else if (separator != null) {
                sb.append(separator);
            }
            if (startEach != null) {
                sb.append(startEach);
            }
            sb.append(item);
            if (endEach == null) continue;
            sb.append(endEach);
        }
        if (endCap != null) {
            sb.append(endCap);
        }
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static List<String> newListNoBlanks(String ... values) {
        ArrayList<String> result = new ArrayList<String>(values.length);
        for (String profileName : values) {
            if (StringUtils.isEmpty(profileName)) continue;
            result.add(profileName);
        }
        return result;
    }

    public static Set<String> newSetNoBlanks(String ... values) {
        HashSet<String> result = new HashSet<String>(values.length);
        for (String profileName : values) {
            if (StringUtils.isEmpty(profileName)) continue;
            result.add(profileName);
        }
        return result;
    }

    @NotNull
    public static Set<String> splitSetByDelimiter(@Nullable String serializedSet, @NotNull String delimiter) {
        if (serializedSet == null) {
            return StringUtils.newSetNoBlanks(new String[0]);
        }
        return StringUtils.newSetNoBlanks(serializedSet.split(delimiter));
    }

    @NotNull
    public static List<String> splitListByDelimiter(@Nullable String serializedSet, @NotNull String delimiter) {
        if (serializedSet == null) {
            return StringUtils.newListNoBlanks(new String[0]);
        }
        return StringUtils.newListNoBlanks(serializedSet.split(delimiter));
    }

    public static String sortedConcat(@NotNull Collection<String> sourceCollection, @Nullable String startCap, @NotNull String separator, @Nullable String endCap) {
        Object[] arrVersion = sourceCollection.toArray(new String[sourceCollection.size()]);
        Arrays.sort(arrVersion);
        return StringUtils.join(arrVersion, startCap, separator, endCap);
    }
}

