/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.commands.CommandUtilities;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import psdi.app.system.CrontaskParamInfo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.server.SimpleCronTask;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class StatsSummaryCronTask
extends SimpleCronTask {
    public static final String RETENTION_PERIOD = "RetentionPeriod";
    private static CrontaskParamInfo[] params;
    private static int retPeriod;
    private boolean initialized = false;

    public void init() throws MXException {
        MXLogger logger2 = this.getCronTaskLogger();
        logger2.info((Object)"Initializing the Informer stats summary cron task");
        super.init();
        try {
            retPeriod = this.getParamAsInt(RETENTION_PERIOD);
        }
        catch (RemoteException e) {
            logger2.error((Object)("An error occurred while reading the stats retention period; " + e.getMessage() + ", the CronTask will not run."));
            this.initialized = false;
            return;
        }
        this.initialized = true;
        logger2.info((Object)"Initialized the Informer stats summary cron task");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void cronAction() {
        logger = this.getCronTaskLogger();
        if (this.initialized) {
            logger.info((Object)"Summarizing Informer performance statistics.");
            notifySet = null;
            try {
                block22: {
                    notifySet = MXServer.getMXServer().getMboSet("ISNOTIFY", MXServer.getMXServer().getSystemUserInfo());
                    notifySet.setFlag(39L, true);
                    notify = notifySet.moveFirst();
                    while (notify != null) {
                        c = Calendar.getInstance();
                        c.set(11, 0);
                        c.set(12, 0);
                        c.set(13, 0);
                        c.set(14, 0);
                        this.updateStatistics(c, notify.getUniqueIDValue());
                        c.add(6, -1);
                        this.updateStatistics(c, notify.getUniqueIDValue());
                        lastRun = this.getCrontaskInstance().getDate("LASTRUN");
                        c2 = Calendar.getInstance();
                        c2.setTime(lastRun);
                        c2.set(11, 0);
                        c2.set(12, 0);
                        c2.set(13, 0);
                        c2.set(14, 0);
                        while (c2.before(c)) {
                            c2.add(6, 1);
                            this.updateStatistics(c2, notify.getUniqueIDValue());
                        }
                        notify = notifySet.moveNext();
                    }
                    StatsSummaryCronTask.retPeriod = this.getParamAsInt("RetentionPeriod");
                    c = Calendar.getInstance();
                    c.add(6, -1 * StatsSummaryCronTask.retPeriod);
                    s = null;
                    key = MXServer.getMXServer().getDBManager().getSystemConnectionKey();
                    try {
                        date = SqlFormat.getDateFunction((Date)c.getTime());
                        delete = "delete istracking where started < " + date;
                        cnn = MXServer.getMXServer().getDBManager().getConnection(key);
                        s = cnn.createStatement();
                        s.execute(delete);
                        cnn.commit();
                        s.close();
                        NotifyUtil.close(s);
                        ** if (key == null) goto lbl-1000
                    }
                    catch (SQLException e) {
                        logger.error((Object)("An error occured while purging informer statistics;" + e.getMessage()));
                        break block22;
                    }
                    finally {
                        NotifyUtil.close(s);
                        if (key != null) {
                            try {
                                MXServer.getMXServer().getDBManager().freeConnection(key);
                            }
                            catch (RemoteException e) {
                                logger.error((Object)("An error occured while purging informer statistics;" + e.getMessage()));
                            }
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            MXServer.getMXServer().getDBManager().freeConnection(key);
                        }
                        catch (RemoteException e) {
                            logger.error((Object)("An error occured while purging informer statistics;" + e.getMessage()));
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                logger.info((Object)"Purged expired Informer statistics.");
            }
            catch (MXException e) {
                logger.error((Object)("An error occured while purging informer statistics;" + e.getMessage()));
                NotifyUtil.closeAndCleanup(notifySet);
            }
            catch (RemoteException e) {
                logger.error((Object)("An error occured while purging informer statistics;" + e.getMessage()));
                {
                    catch (Throwable var11_16) {
                        NotifyUtil.closeAndCleanup(notifySet);
                        throw var11_16;
                    }
                }
                NotifyUtil.closeAndCleanup(notifySet);
            }
            NotifyUtil.closeAndCleanup(notifySet);
        }
    }

    public CrontaskParamInfo[] getParameters() {
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatistics(Calendar c, long notifyUid) {
        MXLogger logger2 = this.getCronTaskLogger();
        if (c == null) {
            c = Calendar.getInstance();
        }
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(c.getTime());
        c2.add(6, 1);
        try {
            SqlFormat sqlf;
            int userCount = 0;
            int userCountAvg = 0;
            long total = 0L;
            MboSetRemote trackingSet = null;
            try {
                SqlFormat sqlf2 = new SqlFormat("started > :1 and started < :2 and type = :3 and (totalelapsed > 0 and totalelapsed is not null) and notifyid = :4");
                sqlf2.setDate(1, c.getTime());
                sqlf2.setDate(2, c2.getTime());
                sqlf2.setObject(3, "ISTRACKING", "TYPE", "USER");
                sqlf2.setLong(4, notifyUid);
                trackingSet = MXServer.getMXServer().getMboSet("ISTRACKING", MXServer.getMXServer().getSystemUserInfo());
                trackingSet.setFlag(39L, true);
                trackingSet.setWhere(sqlf2.format());
                trackingSet.reset();
                MboRemote mbo = trackingSet.moveFirst();
                while (mbo != null) {
                    total += (long)mbo.getInt("TOTALELAPSED");
                    ++userCount;
                    mbo = trackingSet.moveNext();
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(trackingSet);
                throw throwable;
            }
            NotifyUtil.closeAndCleanup(trackingSet);
            if (userCount > 0) {
                userCountAvg = Math.round(total / (long)userCount / 1000L);
            }
            int notifyCount = 0;
            int notifyCountAvg = 0;
            int totalAvg = 0;
            long total2 = 0L;
            int totalCount = 0;
            MboSetRemote trackingSet2 = null;
            try {
                sqlf = new SqlFormat("started > :1 and started < :2 and type = :3 and (elapsedtime > 0 and elapsedtime is not null) and notifyid = :4");
                sqlf.setDate(1, c.getTime());
                sqlf.setDate(2, c2.getTime());
                sqlf.setObject(3, "ISTRACKING", "TYPE", "NOTIFY");
                sqlf.setLong(4, notifyUid);
                trackingSet2 = MXServer.getMXServer().getMboSet("ISTRACKING", MXServer.getMXServer().getSystemUserInfo());
                trackingSet2.setFlag(39L, true);
                trackingSet2.setWhere(sqlf.format());
                trackingSet2.reset();
                MboRemote mbo = trackingSet2.moveFirst();
                while (mbo != null) {
                    ++notifyCount;
                    total2 += (long)mbo.getInt("ELAPSEDTIME");
                    int tempAvg = this.getAverageTotalTime(mbo);
                    if (tempAvg > 0) {
                        totalAvg += tempAvg;
                        ++totalCount;
                    }
                    mbo = trackingSet2.moveNext();
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(trackingSet2);
                throw throwable;
            }
            NotifyUtil.closeAndCleanup(trackingSet2);
            if (totalCount > 0) {
                totalAvg = Math.round(totalAvg / totalCount / 1000);
            }
            if (notifyCount > 0) {
                notifyCountAvg = Math.round(total2 / (long)notifyCount / 1000L);
            }
            int pushCount = 0;
            int pushCountAvg = 0;
            long total3 = 0L;
            MboSetRemote trackingSet3 = null;
            try {
                SqlFormat sqlf3 = new SqlFormat("started > :1 and started < :2 and pushelapsed is not null and notifyid = :3");
                sqlf3.setDate(1, c.getTime());
                sqlf3.setDate(2, c2.getTime());
                sqlf3.setLong(3, notifyUid);
                trackingSet3 = MXServer.getMXServer().getMboSet("ISTRACKING", MXServer.getMXServer().getSystemUserInfo());
                trackingSet3.setFlag(39L, true);
                trackingSet3.setWhere(sqlf3.format());
                trackingSet3.reset();
                MboRemote mbo = trackingSet3.moveFirst();
                while (mbo != null) {
                    ++pushCount;
                    total3 += (long)mbo.getInt("PUSHELAPSED");
                    trackingSet3.remove(0);
                    mbo = trackingSet3.moveNext();
                }
                if (pushCount > 0) {
                    pushCountAvg = Math.round(total3 / (long)pushCount / 1000L);
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(trackingSet3);
                throw throwable;
            }
            NotifyUtil.closeAndCleanup(trackingSet3);
            int commandCount = 0;
            MboSetRemote commandHistorySet = null;
            try {
                sqlf = new SqlFormat("executiondate > :1 and executiondate <:2 and notifyid = :3 and inexecution = :4");
                sqlf.setDate(1, c.getTime());
                sqlf.setDate(2, c2.getTime());
                sqlf.setLong(3, notifyUid);
                sqlf.setInt(4, CommandUtilities.ExecutionStatus.SUCCEEDED.getValue());
                commandHistorySet = MXServer.getMXServer().getMboSet("ISCOMMANDHISTORY", MXServer.getMXServer().getSystemUserInfo());
                commandHistorySet.setFlag(39L, true);
                commandHistorySet.setWhere(sqlf.format());
                commandCount = commandHistorySet.count();
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(commandHistorySet);
                throw throwable;
            }
            NotifyUtil.closeAndCleanup(commandHistorySet);
            MboSetRemote trackingSummarySet = null;
            try {
                MboRemote trackingSummary;
                sqlf = new SqlFormat("PERIOD = :1 and notifyid = :2");
                sqlf.setDate(1, c.getTime());
                sqlf.setLong(2, notifyUid);
                trackingSummarySet = MXServer.getMXServer().getMboSet("ISTRACKINGSUMMARY", MXServer.getMXServer().getSystemUserInfo());
                trackingSummarySet.setWhere(sqlf.format());
                trackingSummarySet.reset();
                if (trackingSummarySet.isEmpty()) {
                    trackingSummary = trackingSummarySet.add();
                    trackingSummary.setValue("PERIOD", c.getTime());
                } else {
                    trackingSummary = trackingSummarySet.getMbo(0);
                }
                trackingSummary.setValue("PUSHCOUNT", pushCount);
                trackingSummary.setValue("PUSHAVG", pushCountAvg);
                trackingSummary.setValue("NOTIFICATIONCOUNT", notifyCount);
                trackingSummary.setValue("NOTIFICATIONAVG", notifyCountAvg);
                trackingSummary.setValue("USERREFRESHCOUNT", userCount);
                trackingSummary.setValue("USERREFRESHAVG", userCountAvg);
                trackingSummary.setValue("TOTALAVG", totalAvg);
                trackingSummary.setValue("UPDATED", MXServer.getMXServer().getDate());
                trackingSummary.setValue("COMMANDCOUNT", commandCount);
                trackingSummary.setValue("NOTIFYID", notifyUid);
                trackingSummarySet.save();
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(trackingSummarySet);
                throw throwable;
            }
            NotifyUtil.closeAndCleanup(trackingSummarySet);
        }
        catch (RemoteException e) {
            logger2.error((Object)e);
        }
        catch (MXException e) {
            logger2.error((Object)e);
        }
    }

    private int getAverageTotalTime(MboRemote userRefreshStat) throws RemoteException, MXException {
        if (userRefreshStat != null && !userRefreshStat.isNull("STARTED") && !userRefreshStat.isNull("STOPPED")) {
            Date start = userRefreshStat.getDate("STARTED");
            long totalTime = 0L;
            long totalCount = 0L;
            MboSetRemote notificationSet = userRefreshStat.getMboSet("$notifications", "ISTRACKING", "notifyrefreshqueueid = :notifyrefreshqueueid");
            notificationSet.setFlag(39L, true);
            MboRemote notification = notificationSet.moveFirst();
            while (notification != null) {
                MboSetRemote pushSet = notification.getMboSet("$pushes", "ISTRACKING", "notifyrefreshqueueid = :notifyrefreshqueueid and type = 'PUSHQUEUE' and pushreceived is not null");
                pushSet.setFlag(39L, true);
                MboRemote push = pushSet.moveFirst();
                while (push != null) {
                    totalTime += push.getDate("PUSHRECEIVED").getTime() - start.getTime();
                    ++totalCount;
                    push = pushSet.moveNext();
                }
                notification = notificationSet.moveNext();
            }
            if (totalCount > 0L && totalTime > 0L) {
                return Math.round(totalTime / totalCount);
            }
        }
        return -1;
    }

    static {
        retPeriod = 7;
        params = new CrontaskParamInfo[1];
        CrontaskParamInfo retentionPeriod = new CrontaskParamInfo();
        retentionPeriod.setName(RETENTION_PERIOD);
        retentionPeriod.setDescription("informer", "retentionPeriodStats");
        retentionPeriod.setDefault(Integer.toString(retPeriod));
        StatsSummaryCronTask.params[0] = retentionPeriod;
    }
}

