/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import psdi.app.system.CrontaskParamInfo;
import psdi.mbo.SqlFormat;
import psdi.security.ConnectionKey;
import psdi.server.MXServer;
import psdi.server.SimpleCronTask;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class SessionHistoryPurgeCronTask
extends SimpleCronTask {
    private static CrontaskParamInfo[] params;
    private static int retPeriod;
    private boolean initialized = false;
    public static final String RETENTION_PERIOD = "sessionRetPeriod";

    public void init() throws MXException {
        MXLogger logger2 = this.getCronTaskLogger();
        logger2.info((Object)"Initializing the Informer session history purge cron task");
        super.init();
        try {
            String retentionPeriod = this.getParamAsString(RETENTION_PERIOD);
            try {
                retPeriod = Integer.parseInt(retentionPeriod);
            }
            catch (Exception e) {
                logger2.warn((Object)("Error parsing retention period value, using default of " + retPeriod + " day" + (retPeriod > 1 ? "s" : "") + "."));
                logger2.warn((Object)e.getMessage());
            }
        }
        catch (RemoteException e) {
            logger2.error((Object)("An error occurred while reading the session history retention period; " + e.getMessage() + ", the CronTask will not run."));
            this.initialized = false;
            return;
        }
        this.initialized = true;
        logger2.info((Object)"Initialized the Informer session history purge cron task");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cronAction() {
        MXLogger logger2 = this.getCronTaskLogger();
        if (!this.initialized) return;
        logger2.info((Object)"Purging expired Informer session history data.");
        try {
            try {
                String retentionPeriod = this.getParamAsString(RETENTION_PERIOD);
                retPeriod = Integer.parseInt(retentionPeriod);
            }
            catch (Exception e) {
                logger2.warn((Object)("Error parsing retention period value, using default of " + retPeriod + " day" + (retPeriod > 1 ? "s" : "") + "."));
                logger2.warn((Object)e.getMessage());
            }
            Calendar c = Calendar.getInstance();
            c.add(6, -1 * retPeriod);
            String date = SqlFormat.getDateFunction((Date)c.getTime());
            Statement s = null;
            ConnectionKey key = MXServer.getMXServer().getDBManager().getSystemConnectionKey();
            try {
                String delete = "delete issessionhistory where active < " + date;
                Connection cnn = MXServer.getMXServer().getDBManager().getConnection(key);
                s = cnn.createStatement();
                s.execute(delete);
                cnn.commit();
                NotifyUtil.close(s);
                if (key == null) return;
            }
            catch (SQLException e) {
                logger2.error((Object)e.getMessage(), (Throwable)e);
                return;
            }
            try {
                MXServer.getMXServer().getDBManager().freeConnection(key);
                return;
            }
            catch (RemoteException e) {
                logger2.warn((Object)e);
                return;
            }
            finally {
                NotifyUtil.close(s);
                if (key != null) {
                    try {
                        MXServer.getMXServer().getDBManager().freeConnection(key);
                    }
                    catch (RemoteException e) {
                        logger2.warn((Object)e);
                    }
                }
            }
        }
        catch (RemoteException e) {
            logger2.error((Object)("An error occured while purging session history;" + e.getMessage()));
        }
    }

    public CrontaskParamInfo[] getParameters() {
        return params;
    }

    static {
        retPeriod = 30;
        params = new CrontaskParamInfo[1];
        CrontaskParamInfo retentionPeriod = new CrontaskParamInfo();
        retentionPeriod.setName(RETENTION_PERIOD);
        retentionPeriod.setDescription("informer", RETENTION_PERIOD);
        retentionPeriod.setDefault(Integer.toString(retPeriod));
        SessionHistoryPurgeCronTask.params[0] = retentionPeriod;
    }
}

