/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.CatalogRemote;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalFlags;
import com.interlocsolutions.maximo.notify.util.MaximoVersion;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import java.rmi.RemoteException;
import psdi.app.system.CrontaskParamInfo;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.server.SimpleCronTask;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class ReconcileCatalogCronTask
extends SimpleCronTask {
    public static final String CATALOG_NAMES = "CatalogNames";
    public static final String PROFILE_NAME = "ProfileName";
    private static CrontaskParamInfo[] params = new CrontaskParamInfo[2];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cronAction() {
        block13: {
            MXLogger logger2 = this.getCronTaskLogger();
            try {
                String profileName = this.getParamAsString(PROFILE_NAME);
                String catalogNameParam = this.getParamAsString(CATALOG_NAMES);
                String[] catalogNames = catalogNameParam != null && catalogNameParam.length() > 0 ? catalogNameParam.split(",") : new String[]{};
                if (profileName == null || profileName.length() <= 0 || catalogNames.length <= 0) {
                    logger2.warn((Object)"Unable to reconcile catalogs because either the profile name of catalog names were not configured.");
                    return;
                }
                logger2.info((Object)"Starting catalog reconciliations.");
                UserInfo userInfo = this.getRunasUserInfo();
                MboSetRemote catalogSet = MXServer.getMXServer().getMboSet("ISCATALOG", userInfo);
                try {
                    SqlFormat sqlf = new SqlFormat("notifyid = (select notifyid from isnotify where notifynum = :1) and catalog = :2");
                    for (String catalog : catalogNames) {
                        sqlf.setObject(1, "ISNOTIFY", "NOTIFYNUM", profileName);
                        sqlf.setObject(2, "ISCATALOG", "CATALOG", catalog);
                        catalogSet.setWhere(sqlf.format());
                        catalogSet.reset();
                        if (!catalogSet.isEmpty()) {
                            logger2.info((Object)String.format("Trigger reconciliation of Catalog %s on Profile %s", catalog, profileName));
                            EvalContext evalContext = new EvalContext(userInfo).setFlag(EvalFlags.SCHEDULED);
                            ((CatalogRemote)catalogSet.getMbo(0)).reload(evalContext);
                            catalogSet.save();
                            continue;
                        }
                        logger2.warn((Object)String.format("Unable to reconcile catalog %s on profile %s because it was not found in the system.", catalog, profileName));
                    }
                }
                finally {
                    NotifyUtil.closeAndCleanup(catalogSet);
                }
                logger2.info((Object)"Completed catalog reconciliations.");
            }
            catch (MXException e) {
                logger2.error((Object)("An error occurred while reconciling catalog data;" + e.getMessage()), (Throwable)e);
                if (MaximoVersion.Companion.getSystemVersion().handlesCronExceptions()) {
                    throw new RuntimeException(e);
                }
            }
            catch (RemoteException e) {
                logger2.error((Object)("An error occurred while reconciling catalog data;" + e.getMessage()), (Throwable)e);
                if (MaximoVersion.Companion.getSystemVersion().handlesCronExceptions()) {
                    throw new RuntimeException(e);
                }
            }
            catch (RuntimeException e) {
                logger2.error((Object)("An error occurred while reconciling catalog data;" + e.getMessage()), (Throwable)e);
                if (!MaximoVersion.Companion.getSystemVersion().handlesCronExceptions()) break block13;
                throw e;
            }
        }
    }

    public CrontaskParamInfo[] getParameters() {
        return params;
    }

    static {
        CrontaskParamInfo profileName = new CrontaskParamInfo();
        profileName.setName(PROFILE_NAME);
        profileName.setDescription("informer", "reconcileProfileNames");
        ReconcileCatalogCronTask.params[0] = profileName;
        CrontaskParamInfo catalogNames = new CrontaskParamInfo();
        catalogNames.setName(CATALOG_NAMES);
        catalogNames.setDescription("informer", "reconcileCatalogNames");
        ReconcileCatalogCronTask.params[1] = catalogNames;
    }
}

