/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import javax.xml.ws.WebServiceException;
import psdi.mbo.MaxMessageCache;
import psdi.server.MXServer;
import psdi.util.MXException;
import psdi.util.Message;
import psdi.util.logging.MXLogger;

public class NotifyFault
extends WebServiceException {
    private static final long serialVersionUID = -4923168192265067726L;
    static MXLogger logger = NotifyConstants.INFORMER_LOGGER;
    static String serverinfo = "";
    private String errorgroup;
    private String errorkey;
    private String message;
    private String errorCode;
    private Throwable detail;
    private String langCode;
    private Object[] params;

    public static NotifyFault from(Exception e) {
        if (e instanceof NotifyFault) {
            return (NotifyFault)((Object)e);
        }
        if (e instanceof MXException) {
            return new NotifyFault((MXException)((Object)e));
        }
        return new NotifyFault(e);
    }

    public NotifyFault(MXException exception) {
        this(exception.getErrorGroup(), exception.getErrorKey(), (Exception)((Object)exception));
    }

    public NotifyFault(String group, String key) {
        this.setErrorByGroupAndKey(group, key);
    }

    public NotifyFault(String group, String key, String message2) {
        this(group, key);
        this.message = message2;
    }

    public NotifyFault(String group, String key, Exception exception) {
        this(exception);
        this.setErrorByGroupAndKey(group, key);
    }

    public NotifyFault(Exception e) {
        this((Throwable)e);
    }

    public NotifyFault(Throwable e) {
        super(e);
        this.detail = e;
    }

    public NotifyFault(String message2) {
        this.message = message2;
    }

    private void setErrorByGroupAndKey(String group, String key) {
        this.errorgroup = group;
        this.errorkey = key;
        if (this.errorCode == null || this.errorCode.isEmpty()) {
            this.setErrorCode(group + '#' + key);
        }
    }

    public void setLangCode(String langCode) {
        this.langCode = langCode;
    }

    public void setFaultCodeAsString(String faultCode) {
        this.setErrorCode(faultCode);
    }

    public String getFaultString() {
        return this.getMessage();
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.errorCode != null) {
            sb.append('[').append(this.errorCode).append(']');
        }
        if (serverinfo != null) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append('{').append(serverinfo).append('}');
        }
        if (this.message != null) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(this.message);
        }
        if (this.errorgroup != null) {
            if (sb.length() > 0) {
                sb.append("\n\t");
            }
            try {
                MaxMessageCache msgCache = MXServer.getMXServer().getMaxMessageCache();
                Message taggedMessage = this.langCode != null ? msgCache.getTaggedMessage(this.errorgroup, this.errorkey, this.langCode) : msgCache.getTaggedMessage(this.errorgroup, this.errorkey);
                String msg = this.params != null ? taggedMessage.getMessage(this.params) : taggedMessage.getMessage();
                sb.append(msg);
            }
            catch (Throwable t) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Failed to fetch message %1$s#%2$s: %3$s", this.errorgroup, this.errorkey, t));
                }
                sb.append(this.errorgroup).append('#').append(this.errorkey);
            }
        }
        if (this.detail != null) {
            if (sb.length() > 0) {
                sb.append("\n\tCaused by: ").append(this.detail.getClass().getName()).append(": ");
            }
            sb.append(this.detail.getMessage());
        }
        return sb.toString();
    }

    static {
        try {
            serverinfo = MXServer.getMXServer().getRegistryHostName() + " : " + MXServer.getMXServer().getName();
        }
        catch (Throwable t) {
            logger.warn((Object)"Unable to determine the server host and name");
        }
    }
}

