/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.err.NoSuchRecordException;
import com.interlocsolutions.maximo.notify.util.ImmutableLongSet;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.db.DataUtils;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.MaximoDD;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetInfo;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.util.MXRowUpdateException;
import psdi.util.MXUnknownObjectException;

public class MboUtil {
    public static ImmutableLongSet collectUniqueIds(@NotNull UserInfo userInfo, @NotNull String mboName, @NotNull String whereClause) throws RemoteException, MXException {
        try {
            MboSetInfo msi = ((MaximoDD)MXServer.getMXServer().getFromMaximoCache("MAXIMODD")).getMboSetInfo(mboName);
            if (msi == null) {
                throw new MXUnknownObjectException("system", "unknownobject", new Object[]{mboName});
            }
            return MboUtil.collectUniqueLongs(userInfo, mboName, msi.getUniqueIDName(), whereClause);
        }
        catch (SQLException e) {
            throw new MXApplicationException("informer", "sqlError", (Object[])new String[]{"ID collection failed"}, (Throwable)e);
        }
    }

    public static ImmutableLongSet collectUniqueLongs(@NotNull UserInfo userInfo, @NotNull String mboName, final @NotNull String targetAttribute, @NotNull String whereClause) throws RemoteException, MXException, SQLException {
        return MboUtil.mboQuery(userInfo, mboName, new String[]{targetAttribute}, whereClause, null, new DataUtils.ResultSetHandler<ImmutableLongSet>(){

            @Override
            public ImmutableLongSet useResultSet(@NotNull ResultSet rs) throws SQLException {
                ImmutableLongSet.Builder longSetBuilder = new ImmutableLongSet.Builder();
                int idxId = rs.findColumn(targetAttribute);
                while (rs.next()) {
                    longSetBuilder.add(rs.getLong(idxId));
                }
                return longSetBuilder.build();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int visitMbosReadOnly(@NotNull UserInfo userInfo, @NotNull String mboName, @NotNull String whereClause, @NotNull NotifyUtil.MboVisitor visitor) throws RemoteException, MXException {
        int recordsVisited = 0;
        MboSetRemote mboSet = MXServer.getMXServer().getMboSet(mboName, userInfo);
        try {
            mboSet.setFlag(39L, true);
            mboSet.setWhere(new SqlFormat(userInfo, whereClause).format());
            MboRemote mbo = mboSet.moveFirst();
            while (mbo != null) {
                visitor.visit(mbo);
                ++recordsVisited;
                mbo = mboSet.moveNext();
            }
        }
        finally {
            NotifyUtil.closeAndCleanup(mboSet);
        }
        return recordsVisited;
    }

    /*
     * Exception decompiling
     */
    public static <T> T mboQuery(@NotNull UserInfo userInfo, @NotNull String mboName, @Nullable String[] attrs, @Nullable String whereClause, @Nullable String orderBy, @NotNull DataUtils.ResultSetHandler<T> resultSetHandler) throws RemoteException, MXException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ResultSet directMboQuery(@NotNull Statement statement, @NotNull String mboName, @Nullable String[] attrs, @Nullable String whereClause, @Nullable String orderBy) throws MXException, RemoteException, SQLException {
        MboSetInfo msi = ((MaximoDD)MXServer.getMXServer().getFromMaximoCache("MAXIMODD")).getMboSetInfo(mboName);
        if (msi == null) {
            throw new MXUnknownObjectException("system", "unknownobject", new Object[]{mboName});
        }
        String entityName = msi.getEntityName();
        return DataUtils.directQuery(statement, entityName, attrs, whereClause, orderBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> mapMbos(@NotNull UserInfo userInfo, @NotNull String mboName, @NotNull String whereClause, @NotNull MboMapper<T> mapper) throws RemoteException, MXException {
        ArrayList<T> resultingList = new ArrayList<T>();
        MboSetRemote mboSet = MXServer.getMXServer().getMboSet(mboName, userInfo);
        try {
            mboSet.setFlag(39L, true);
            mboSet.setWhere(new SqlFormat(userInfo, whereClause).format());
            MboRemote mbo = mboSet.moveFirst();
            while (mbo != null) {
                resultingList.add(mapper.map(mbo));
                mbo = mboSet.moveNext();
            }
        }
        finally {
            NotifyUtil.closeAndCleanup(mboSet);
        }
        return resultingList;
    }

    public static int visitMbos(@NotNull UserInfo userInfo, @NotNull String mboName, @NotNull String whereClause, @NotNull NotifyUtil.MboVisitor visitor) throws RemoteException, MXException {
        ImmutableLongSet uniqueIds = MboUtil.collectUniqueIds(userInfo, mboName, whereClause);
        if (uniqueIds.isEmpty()) {
            return 0;
        }
        return MboUtil.visitMbos(userInfo, mboName, (Iterable<Long>)uniqueIds, visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int visitMbos(@NotNull UserInfo userInfo, @NotNull String mboName, @NotNull Iterable<Long> uniqueIds, @NotNull NotifyUtil.MboVisitor visitor) throws RemoteException, MXException {
        int recordsVisited = 0;
        MboSetRemote mboSet = MXServer.getMXServer().getMboSet(mboName, userInfo);
        try {
            for (Long uniqueId : uniqueIds) {
                if (uniqueId == null) continue;
                visitor.visit(mboSet.getMboForUniqueId(uniqueId.longValue()));
                ++recordsVisited;
                mboSet.save();
                mboSet.clear();
            }
        }
        finally {
            NotifyUtil.closeAndCleanup(mboSet);
        }
        return recordsVisited;
    }

    public static int visitMbosWithRetry(@NotNull UserInfo userInfo, @NotNull String mboName, @NotNull String whereClause, @NotNull NotifyUtil.MboVisitor visitor, int concurrentModificationRetries) throws RemoteException, MXException {
        ImmutableLongSet uniqueIds = MboUtil.collectUniqueIds(userInfo, mboName, whereClause);
        if (uniqueIds.isEmpty()) {
            return 0;
        }
        return MboUtil.visitMbosWithRetry(userInfo, mboName, (Iterable<Long>)uniqueIds, visitor, concurrentModificationRetries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int visitMbosWithRetry(@NotNull UserInfo userInfo, @NotNull String mboName, @NotNull Iterable<Long> uniqueIds, @NotNull NotifyUtil.MboVisitor visitor, int concurrentModificationRetries) throws RemoteException, MXException {
        MXRowUpdateException rowUpdateExceptionToReport = null;
        int recordsVisited = 0;
        for (Long uniqueId : uniqueIds) {
            if (uniqueId == null) continue;
            MboSetRemote mboSet = MXServer.getMXServer().getMboSet(mboName, userInfo);
            try {
                boolean successful = false;
                MXRowUpdateException rowUpdateExceptionThisTime = null;
                for (int attempts = 0; !successful && attempts <= concurrentModificationRetries; ++attempts) {
                    if (attempts > 0) {
                        mboSet.cleanup();
                        mboSet.clear();
                    }
                    try {
                        MboRemote mbo = mboSet.getMboForUniqueId(uniqueId.longValue());
                        if (mbo != null) {
                            visitor.visit(mbo);
                            mboSet.save();
                            ++recordsVisited;
                        }
                        successful = true;
                        rowUpdateExceptionThisTime = null;
                        continue;
                    }
                    catch (MXRowUpdateException e) {
                        rowUpdateExceptionThisTime = e;
                    }
                }
                if (rowUpdateExceptionThisTime == null) continue;
                rowUpdateExceptionToReport = rowUpdateExceptionThisTime;
            }
            finally {
                NotifyUtil.closeAndCleanup(mboSet);
            }
        }
        if (rowUpdateExceptionToReport != null) {
            throw rowUpdateExceptionToReport;
        }
        return recordsVisited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean visitSingleMboReadOnly(@NotNull UserInfo userInfo, @NotNull String mboName, long uniqueId, @NotNull NotifyUtil.MboVisitor visitor) throws RemoteException, MXException {
        boolean found;
        MboSetRemote mboSet = MXServer.getMXServer().getMboSet(mboName, userInfo);
        try {
            mboSet.setFlag(7L, true);
            MboRemote mbo = mboSet.getMboForUniqueId(uniqueId);
            if (mbo == null) {
                found = false;
            } else {
                visitor.visit(mbo);
                found = true;
            }
        }
        finally {
            NotifyUtil.closeAndCleanup(mboSet);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visitSingleMboReadOnlyOrThrow(@NotNull UserInfo userInfo, @NotNull String mboName, long uniqueId, @NotNull NotifyUtil.MboVisitor visitor) throws RemoteException, MXException {
        MboSetRemote mboSet = MXServer.getMXServer().getMboSet(mboName, userInfo);
        try {
            mboSet.setFlag(7L, true);
            MboRemote mbo = mboSet.getMboForUniqueId(uniqueId);
            if (mbo == null) {
                throw new NoSuchRecordException(mboName, uniqueId);
            }
            visitor.visit(mbo);
        }
        finally {
            NotifyUtil.closeAndCleanup(mboSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean visitSingleMbo(@NotNull UserInfo userInfo, @NotNull String mboName, long uniqueId, @NotNull NotifyUtil.MboVisitor visitor) throws RemoteException, MXException {
        boolean found;
        MboSetRemote mboSet = MXServer.getMXServer().getMboSet(mboName, userInfo);
        try {
            MboRemote mbo = mboSet.getMboForUniqueId(uniqueId);
            if (mbo == null) {
                found = false;
            } else {
                visitor.visit(mbo);
                mboSet.save();
                found = true;
            }
        }
        finally {
            NotifyUtil.closeAndCleanup(mboSet);
        }
        return found;
    }

    public static boolean visitSingleMboWithRetry(@NotNull UserInfo userInfo, @NotNull String mboName, long uniqueId, @NotNull NotifyUtil.MboVisitor visitor, int concurrentModificationRetries) throws RemoteException, MXException {
        MXRowUpdateException rowUpdateExceptionToReport = null;
        boolean successful = false;
        MXRowUpdateException rowUpdateExceptionThisTime = null;
        for (int attempts = 0; !successful && attempts <= concurrentModificationRetries; ++attempts) {
            try {
                successful = MboUtil.visitSingleMbo(userInfo, mboName, uniqueId, visitor);
                rowUpdateExceptionThisTime = null;
                continue;
            }
            catch (MXRowUpdateException e) {
                rowUpdateExceptionThisTime = e;
            }
        }
        if (rowUpdateExceptionThisTime != null) {
            rowUpdateExceptionToReport = rowUpdateExceptionThisTime;
        }
        if (rowUpdateExceptionToReport != null) {
            throw rowUpdateExceptionToReport;
        }
        return successful;
    }

    public static boolean exists(@NotNull UserInfo userInfo, @NotNull String mboName, @NotNull String whereClause) throws RemoteException, MXException, SQLException {
        MboSetInfo msi = MXServer.getMXServer().getMaximoDD().getMboSetInfo(mboName);
        if (msi == null) {
            throw new MXUnknownObjectException("system", "unknownobject", new Object[]{mboName});
        }
        return DataUtils.existsQuery(userInfo, "SELECT 1 FROM " + msi.getEntityName() + " WHERE " + MboUtil.formCompleteWhere(userInfo, mboName, whereClause));
    }

    public static MboIterationResults visitMbosExhaustively(@NotNull UserInfo userInfo, @NotNull String mboName, @NotNull String whereClause, @NotNull NotifyUtil.MboVisitor visitor) throws RemoteException, MXException {
        ImmutableLongSet uniqueIds = MboUtil.collectUniqueIds(userInfo, mboName, whereClause);
        return MboUtil.visitMbosExhaustively(userInfo, mboName, (Iterable<Long>)uniqueIds, visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MboIterationResults visitMbosExhaustively(@NotNull UserInfo userInfo, @NotNull String mboName, @NotNull Iterable<Long> uniqueIds, @NotNull NotifyUtil.MboVisitor visitor) throws RemoteException, MXException {
        ArrayList<ErrorInfo> errorList = new ArrayList<ErrorInfo>();
        ImmutableLongSet.Builder successfulIds = new ImmutableLongSet.Builder();
        ImmutableLongSet.Builder errorIds = new ImmutableLongSet.Builder();
        String uniqueIDName = MXServer.getMXServer().getMaximoDD().getMboSetInfo(mboName).getUniqueIDName();
        MboSetRemote mboSet = MXServer.getMXServer().getMboSet(mboName, userInfo);
        try {
            for (Long uniqueId : uniqueIds) {
                if (uniqueId == null) continue;
                try {
                    visitor.visit(mboSet.getMboForUniqueId(uniqueId.longValue()));
                    mboSet.save();
                    successfulIds.add(uniqueId.longValue());
                }
                catch (Exception e) {
                    errorIds.add(uniqueId.longValue());
                    errorList.add(new ErrorInfo(mboName, uniqueIDName, uniqueId, e));
                }
                mboSet.clear();
            }
        }
        finally {
            NotifyUtil.closeAndCleanup(mboSet);
        }
        return new MboIterationResults(mboName, uniqueIDName, successfulIds.build(), errorIds.build(), errorList);
    }

    public static int deleteIteratively(@NotNull UserInfo userInfo, @NotNull String mboName, @NotNull String whereClause) throws RemoteException, MXException {
        return MboUtil.visitMbos(userInfo, mboName, whereClause, (NotifyUtil.MboVisitor)new MboDeleter());
    }

    public static MboIterationResults deleteExhaustively(@NotNull UserInfo userInfo, @NotNull String mboName, @NotNull String whereClause, long flags) throws RemoteException, MXException {
        return MboUtil.visitMbosExhaustively(userInfo, mboName, whereClause, (NotifyUtil.MboVisitor)new MboDeleter(flags));
    }

    public static boolean deleteSingleMbo(@NotNull UserInfo userInfo, @NotNull String mboName, long uniqueId) throws RemoteException, MXException {
        return MboUtil.visitSingleMbo(userInfo, mboName, uniqueId, new MboDeleter());
    }

    @NotNull
    public static String getUniqueIdAttribute(@NotNull String mboName) throws RemoteException, MXUnknownObjectException {
        MboSetInfo msi = ((MaximoDD)MXServer.getMXServer().getFromMaximoCache("MAXIMODD")).getMboSetInfo(mboName);
        if (msi == null) {
            throw new MXUnknownObjectException("system", "unknownobject", new Object[]{mboName});
        }
        return msi.getUniqueIDName();
    }

    @Nullable
    public static MboRemote findOwnerOfType(@Nullable MboRemote mbo, @NotNull String ownerType) throws RemoteException {
        if (mbo == null) {
            return null;
        }
        MboRemote current = mbo.getOwner();
        while (current != null) {
            if (current.isBasedOn(ownerType)) {
                return current;
            }
            MboRemote next = current.getOwner();
            if (next != current && next != mbo) continue;
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String formCompleteWhere(@NotNull UserInfo userInfo, @NotNull String mboName, @Nullable String whereClause) throws MXException, RemoteException {
        String completeWhereFormatted;
        try (MboSetRemote tempSet = MXServer.getMXServer().getMboSet(mboName, userInfo);){
            tempSet.setWhere(whereClause);
            String completeWhere = tempSet.getCompleteWhere();
            completeWhereFormatted = new SqlFormat(userInfo, completeWhere).format();
        }
        return completeWhereFormatted;
    }

    public static interface MboMapper<ReturnType> {
        public ReturnType map(@NotNull MboRemote var1) throws RemoteException, MXException;
    }

    public static class MboIterationResults {
        @NotNull
        private final String mboName;
        @NotNull
        private final String uniqueIdName;
        @NotNull
        private final ImmutableLongSet mboIdsSuccessful;
        @NotNull
        private final ImmutableLongSet mboIdsUnsuccessful;
        @NotNull
        private final List<ErrorInfo> errors;

        public MboIterationResults(@NotNull String mboName, @NotNull String uniqueIdName, @NotNull ImmutableLongSet mboIdsSuccessful, @NotNull ImmutableLongSet mboIdsUnsuccessful, @NotNull List<ErrorInfo> errors) {
            this.mboName = mboName;
            this.uniqueIdName = uniqueIdName;
            this.mboIdsSuccessful = mboIdsSuccessful;
            this.mboIdsUnsuccessful = mboIdsUnsuccessful;
            this.errors = Collections.unmodifiableList(errors);
        }

        @NotNull
        public String getMboName() {
            return this.mboName;
        }

        @NotNull
        public String getUniqueIdName() {
            return this.uniqueIdName;
        }

        @NotNull
        public ImmutableLongSet getMboIdsSuccessful() {
            return this.mboIdsSuccessful;
        }

        @NotNull
        public ImmutableLongSet getMboIdsUnsuccessful() {
            return this.mboIdsUnsuccessful;
        }

        @NotNull
        public List<ErrorInfo> getErrors() {
            return this.errors;
        }

        public long getNumberSuccessful() {
            return this.getMboIdsSuccessful().size();
        }

        public long getNumberUnsuccessful() {
            return this.getMboIdsUnsuccessful().size();
        }

        public long getNumberAttempted() {
            return this.getNumberSuccessful() + this.getNumberUnsuccessful();
        }

        public boolean hasErrors() {
            return this.errors.size() > 0;
        }
    }

    public static class ErrorInfo {
        @NotNull
        private final String mboName;
        @NotNull
        private final String uniqueIdName;
        @NotNull
        private final long uniqueIdValue;
        @NotNull
        private final Exception exception;

        public ErrorInfo(@NotNull String mboName, @NotNull String uniqueIdName, long uniqueIdValue, @NotNull Exception exception) {
            this.mboName = mboName;
            this.uniqueIdName = uniqueIdName;
            this.uniqueIdValue = uniqueIdValue;
            this.exception = exception;
        }

        public ErrorInfo(@NotNull MboRemote mbo, @NotNull Exception exception) {
            long uniqueIDValue;
            String uniqueIdName;
            String mboName;
            try {
                mboName = mbo.getName();
                uniqueIdName = mbo.getUniqueIDName();
                uniqueIDValue = mbo.getUniqueIDValue();
            }
            catch (RemoteException e) {
                mboName = "unknown";
                uniqueIdName = "unknown";
                uniqueIDValue = -1L;
            }
            catch (MXException e) {
                mboName = "unknown";
                uniqueIdName = "unknown";
                uniqueIDValue = -1L;
            }
            this.mboName = mboName;
            this.uniqueIdName = uniqueIdName;
            this.uniqueIdValue = uniqueIDValue;
            this.exception = exception;
        }

        public String toString() {
            return String.format("Error(on %s: %s)", this.getMboIdentifier(), this.getException().getMessage());
        }

        @NotNull
        public String getMboName() {
            return this.mboName;
        }

        @NotNull
        public String getUniqueIdName() {
            return this.uniqueIdName;
        }

        @NotNull
        public long getUniqueIdValue() {
            return this.uniqueIdValue;
        }

        public String getMboIdentifier() {
            return String.format("%s(%s=%d)", this.getMboName(), this.getUniqueIdName(), this.getUniqueIdValue());
        }

        @NotNull
        public Exception getException() {
            return this.exception;
        }
    }

    public static class MboDeleter
    implements NotifyUtil.MboVisitor {
        private final long flags;

        public MboDeleter() {
            this(0L);
        }

        public MboDeleter(long flags) {
            this.flags = flags;
        }

        @Override
        public void visit(MboRemote mbo) throws RemoteException, MXException {
            if (mbo != null) {
                mbo.delete(this.flags);
            }
        }
    }
}

