/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.NotificationEventListenerManager;
import com.interlocsolutions.maximo.notify.util.CachedCatalog;
import com.interlocsolutions.maximo.notify.util.ISO8601Formatter;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import java.rmi.RemoteException;
import java.text.ParseException;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.util.MXException;
import psdi.util.MXRowUpdateException;

public class InformerTracking {
    public static void notificationUserAdd(MboRemote parent, long refreshQueueId, long notifyId) throws RemoteException, MXException {
        if (NotifyUtil.isTrackingNotification() && parent != null) {
            MboRemote tracking = parent.getMboSet("$istracking", "ISTRACKING").add();
            tracking.setValue("NOTIFYREFRESHQUEUEID", refreshQueueId);
            tracking.setValue("NOTIFYID", notifyId);
            tracking.setValue("TYPE", "USER");
        }
    }

    public static void notificationAdd(MboRemote parent, long id, long refreshQueueId, long notifyId, long recordId) throws RemoteException, MXException {
        if (NotifyUtil.isTrackingNotification() && parent != null) {
            MboRemote tracking = parent.getMboSet("$istracking", "ISTRACKING").add();
            tracking.setValue("NOTIFYREFRESHQUEUEID", id);
            tracking.setValue("PARENT", refreshQueueId);
            tracking.setValue("NOTIFYID", notifyId);
            tracking.setValue("TYPE", "NOTIFY");
            tracking.setValue("RECORDID", recordId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notificationStop(long refreshQueueId) throws RemoteException, MXException {
        if (NotifyUtil.isTrackingNotification()) {
            MboSetRemote trackingSet;
            block3: {
                trackingSet = null;
                try {
                    trackingSet = MXServer.getMXServer().getMboSet("ISTRACKING", MXServer.getMXServer().getSystemUserInfo());
                    SqlFormat sqlf = new SqlFormat("NOTIFYREFRESHQUEUEID = :1");
                    sqlf.setLong(1, refreshQueueId);
                    trackingSet.setWhere(sqlf.format());
                    if (trackingSet.isEmpty()) break block3;
                    trackingSet.getMbo(0).setValue("STOPPED", MXServer.getMXServer().getDate());
                    trackingSet.save();
                }
                catch (Throwable throwable) {
                    NotifyUtil.closeAndCleanup(trackingSet);
                    throw throwable;
                }
            }
            NotifyUtil.closeAndCleanup(trackingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notificationStop(long refreshQueueId, long notifyid, long recordid) throws RemoteException, MXException {
        block11: {
            MboSetRemote trackingSet;
            block10: {
                if (!NotifyUtil.isTrackingNotification()) break block11;
                trackingSet = null;
                try {
                    SqlFormat sqlf = new SqlFormat("(NOTIFYREFRESHQUEUEID = :1 or (notifyid = :2  and recordid = :3)) and stopped is null");
                    sqlf.setLong(1, refreshQueueId);
                    sqlf.setLong(2, notifyid);
                    sqlf.setLong(3, recordid);
                    trackingSet = MXServer.getMXServer().getMboSet("ISTRACKING", MXServer.getMXServer().getSystemUserInfo());
                    trackingSet.setWhere(sqlf.format());
                    if (trackingSet.isEmpty()) break block10;
                    MboRemote tracking = null;
                    while ((tracking = trackingSet.getMbo(0)) != null) {
                        MboSetRemote updateTrackingSet = null;
                        try {
                            updateTrackingSet = MXServer.getMXServer().getMboSet("ISTRACKING", MXServer.getMXServer().getSystemUserInfo());
                            boolean saved = false;
                            while (!saved) {
                                MboRemote updateTracking = updateTrackingSet.getMboForUniqueId(tracking.getUniqueIDValue());
                                if (updateTracking != null) {
                                    updateTracking.setValue("STOPPED", MXServer.getMXServer().getDate());
                                    if (updateTracking.getLong("NOTIFYREFRESHQUEUEID") != refreshQueueId) {
                                        updateTracking.setValue("COLLAPSED", true);
                                    }
                                    try {
                                        updateTrackingSet.save();
                                        saved = true;
                                    }
                                    catch (MXRowUpdateException e) {
                                        NotifyConstants.INFORMER_NRQP_LOGGER.warn((Object)("The record was updated and will now be requeried and saved again for refresh queue Id: " + refreshQueueId));
                                        updateTrackingSet.reset();
                                    }
                                    continue;
                                }
                                saved = true;
                            }
                        }
                        catch (Throwable throwable) {
                            NotifyUtil.closeAndCleanup(updateTrackingSet);
                            throw throwable;
                        }
                        NotifyUtil.closeAndCleanup(updateTrackingSet);
                        trackingSet.remove(0);
                    }
                }
                catch (Throwable throwable) {
                    NotifyUtil.closeAndCleanup(trackingSet);
                    throw throwable;
                }
            }
            NotifyUtil.closeAndCleanup(trackingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long catalogReloadStart(long catalogId, long catalogqueueid) throws RemoteException, MXException {
        if (NotifyUtil.isTrackingCatalog()) {
            long l;
            MboSetRemote trackingSet = null;
            try {
                trackingSet = MXServer.getMXServer().getMboSet("ISTRACKING", MXServer.getMXServer().getSystemUserInfo());
                MboRemote tracking = trackingSet.add();
                tracking.setValue("CATALOGID", catalogId);
                tracking.setValue("ISCATALOGREFRESHQUEUEID", catalogqueueid);
                tracking.setValue("TYPE", "RELOAD");
                CachedCatalog cachedCatalog = NotificationEventListenerManager.CatalogCache.getCatalogOrNull(catalogId);
                tracking.setValue("NOTIFYID", cachedCatalog != null ? cachedCatalog.notifyId : -1L);
                trackingSet.save();
                l = tracking.getUniqueIDValue();
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(trackingSet);
                throw throwable;
            }
            NotifyUtil.closeAndCleanup(trackingSet);
            return l;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void catalogReloadStop(long trackingId) throws RemoteException, MXException {
        if (NotifyUtil.isTrackingCatalog()) {
            MboSetRemote trackingSet = null;
            try {
                trackingSet = MXServer.getMXServer().getMboSet("ISTRACKING", MXServer.getMXServer().getSystemUserInfo());
                MboRemote tracking = trackingSet.getMboForUniqueId(trackingId);
                if (tracking != null) {
                    tracking.setValue("STOPPED", MXServer.getMXServer().getDate());
                }
                trackingSet.save();
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(trackingSet);
                throw throwable;
            }
            NotifyUtil.closeAndCleanup(trackingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long catalogInitStart(long catalogId, long catalogqueueid) throws RemoteException, MXException {
        if (NotifyUtil.isTrackingCatalog()) {
            long l;
            MboSetRemote trackingSet = null;
            try {
                trackingSet = MXServer.getMXServer().getMboSet("ISTRACKING", MXServer.getMXServer().getSystemUserInfo());
                MboRemote tracking = trackingSet.add();
                tracking.setValue("CATALOGID", catalogId);
                tracking.setValue("ISCATALOGREFRESHQUEUEID", catalogqueueid);
                tracking.setValue("TYPE", "INITIALIZE");
                CachedCatalog cachedCatalog = NotificationEventListenerManager.CatalogCache.getCatalogOrNull(catalogId);
                tracking.setValue("NOTIFYID", cachedCatalog != null ? cachedCatalog.notifyId : -1L);
                trackingSet.save();
                l = tracking.getUniqueIDValue();
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(trackingSet);
                throw throwable;
            }
            NotifyUtil.closeAndCleanup(trackingSet);
            return l;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void catalogInitStop(long catalogid) throws RemoteException, MXException {
        if (NotifyUtil.isTrackingCatalog()) {
            MboSetRemote trackingSet;
            block4: {
                trackingSet = null;
                try {
                    trackingSet = MXServer.getMXServer().getMboSet("ISTRACKING", MXServer.getMXServer().getSystemUserInfo());
                    SqlFormat sqlf = new SqlFormat("catalogid = :1 and type = 'INITIALIZE'");
                    sqlf.setLong(1, catalogid);
                    trackingSet.setWhere(sqlf.format());
                    if (trackingSet.isEmpty()) break block4;
                    MboRemote tracking = trackingSet.getMbo(0);
                    if (tracking != null) {
                        tracking.setValue("STOPPED", MXServer.getMXServer().getDate());
                    }
                    trackingSet.save();
                }
                catch (Throwable throwable) {
                    NotifyUtil.closeAndCleanup(trackingSet);
                    throw throwable;
                }
            }
            NotifyUtil.closeAndCleanup(trackingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long catalogPregenStart(long notifyId, long catalogId, long catalogqueueid) throws RemoteException, MXException {
        if (NotifyUtil.isTrackingCatalog()) {
            long l;
            MboSetRemote trackingSet = null;
            try {
                trackingSet = MXServer.getMXServer().getMboSet("ISTRACKING", MXServer.getMXServer().getSystemUserInfo());
                MboRemote tracking = trackingSet.add();
                tracking.setValue("CATALOGID", catalogId);
                tracking.setValue("ISCATALOGREFRESHQUEUEID", catalogqueueid);
                tracking.setValue("TYPE", "PRELOAD");
                tracking.setValue("NOTIFYID", notifyId);
                trackingSet.save();
                l = tracking.getUniqueIDValue();
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(trackingSet);
                throw throwable;
            }
            NotifyUtil.closeAndCleanup(trackingSet);
            return l;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void catalogPregenStop(long trackingId) throws RemoteException, MXException {
        if (NotifyUtil.isTrackingCatalog()) {
            MboSetRemote trackingSet = null;
            try {
                trackingSet = MXServer.getMXServer().getMboSet("ISTRACKING", MXServer.getMXServer().getSystemUserInfo());
                MboRemote tracking = trackingSet.getMboForUniqueId(trackingId);
                if (tracking != null) {
                    tracking.setValue("STOPPED", MXServer.getMXServer().getDate());
                }
                trackingSet.save();
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(trackingSet);
                throw throwable;
            }
            NotifyUtil.closeAndCleanup(trackingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void catalogRefreshStart(long catalogqueueid, long notifyid, long catalogid, long recordid, String langcode) throws RemoteException, MXException {
        if (NotifyUtil.isTrackingCatalog()) {
            MboSetRemote trackingSet = null;
            try {
                trackingSet = MXServer.getMXServer().getMboSet("ISTRACKING", MXServer.getMXServer().getSystemUserInfo());
                MboRemote tracking = trackingSet.add();
                tracking.setValue("TYPE", "CATALOG");
                tracking.setValue("NOTIFYID", notifyid);
                tracking.setValue("CATALOGID", catalogid);
                tracking.setValue("RECORDID", recordid);
                tracking.setValue("ISCATALOGREFRESHQUEUEID", catalogqueueid);
                tracking.setValue("LANGCODE", langcode);
                trackingSet.save();
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(trackingSet);
                throw throwable;
            }
            NotifyUtil.closeAndCleanup(trackingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void catalogRefreshStopped(long catalogqueueid) throws MXException, RemoteException {
        if (NotifyUtil.isTrackingCatalog()) {
            MboSetRemote trackingSet = null;
            try {
                boolean saved = false;
                while (!saved) {
                    try {
                        trackingSet = MXServer.getMXServer().getMboSet("ISTRACKING", MXServer.getMXServer().getSystemUserInfo());
                        SqlFormat sqlf = new SqlFormat("iscatalogrefreshqueueid = :1");
                        sqlf.setLong(1, catalogqueueid);
                        trackingSet.setWhere(sqlf.format());
                        trackingSet.reset();
                        MboRemote tracking = null;
                        if (!trackingSet.isEmpty()) {
                            tracking = trackingSet.getMbo(0);
                            tracking.setValue("STOPPED", MXServer.getMXServer().getDate());
                            trackingSet.save();
                            long catalogid = tracking.getLong("CATALOGID");
                            long recordid = tracking.getLong("RECORDID");
                            String langCode = tracking.getString("LANGCODE");
                            sqlf = new SqlFormat("type = 'CATALOG' and catalogid = :1 and stopped is null and recordid = :2 and langcode = :3");
                            sqlf.setLong(1, catalogid);
                            sqlf.setLong(2, recordid);
                            sqlf.setObject(3, "ISTRACKING", "LANGCODE", langCode);
                            trackingSet.setWhere(sqlf.format());
                            trackingSet.setOrderBy("trackingid desc");
                            trackingSet.reset();
                            tracking = trackingSet.moveFirst();
                            while (tracking != null) {
                                tracking.setValue("STOPPED", MXServer.getMXServer().getDate());
                                tracking.setValue("COLLAPSED", true);
                                tracking = trackingSet.moveNext();
                            }
                        }
                        trackingSet.save();
                        saved = true;
                    }
                    catch (MXRowUpdateException mXRowUpdateException) {}
                }
            }
            finally {
                NotifyUtil.closeAndCleanup(trackingSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long pushStart(long pushQueueId, long pushDeviceId, String pushType, long recordId, long notifyId, long catalogId, long notifyRefreshQueueId) throws RemoteException, MXException {
        if (NotifyUtil.isTrackingPush()) {
            long l;
            MboSetRemote trackingSet = null;
            try {
                trackingSet = MXServer.getMXServer().getMboSet("ISTRACKING", MXServer.getMXServer().getSystemUserInfo());
                MboRemote tracking = trackingSet.add();
                tracking.setValue("PUSHQUEUEID", pushQueueId);
                tracking.setValue("PUSHDEVICEID", pushDeviceId);
                tracking.setValue("PUSHTYPE", pushType);
                tracking.setValue("RECORDID", recordId);
                tracking.setValue("NOTIFYID", notifyId);
                tracking.setValue("CATALOGID", catalogId);
                tracking.setValue("STARTED", MXServer.getMXServer().getDate());
                tracking.setValue("TYPE", "PUSHQUEUE");
                tracking.setValue("NOTIFYREFRESHQUEUEID", notifyRefreshQueueId);
                trackingSet.save();
                l = tracking.getUniqueIDValue();
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(trackingSet);
                throw throwable;
            }
            NotifyUtil.closeAndCleanup(trackingSet);
            return l;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushSent(long trackingId) throws RemoteException, MXException {
        if (NotifyUtil.isTrackingPush()) {
            MboSetRemote trackingSet;
            block3: {
                trackingSet = null;
                try {
                    trackingSet = MXServer.getMXServer().getMboSet("ISTRACKING", MXServer.getMXServer().getSystemUserInfo());
                    MboRemote tracking = trackingSet.getMboForUniqueId(trackingId);
                    if (tracking == null) break block3;
                    tracking.setValue("PUSHSENT", MXServer.getMXServer().getDate());
                    trackingSet.save();
                }
                catch (Throwable throwable) {
                    NotifyUtil.closeAndCleanup(trackingSet);
                    throw throwable;
                }
            }
            NotifyUtil.closeAndCleanup(trackingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushStop(long queueid) throws RemoteException, MXException {
        if (NotifyUtil.isTrackingPush()) {
            MboSetRemote trackingSet;
            block3: {
                trackingSet = null;
                try {
                    trackingSet = MXServer.getMXServer().getMboSet("ISTRACKING", MXServer.getMXServer().getSystemUserInfo());
                    SqlFormat sqlf = new SqlFormat("pushqueueid = :1");
                    sqlf.setLong(1, queueid);
                    trackingSet.setWhere(sqlf.format());
                    if (trackingSet.isEmpty()) break block3;
                    MboRemote tracking = trackingSet.getMbo(0);
                    tracking.setValue("STOPPED", MXServer.getMXServer().getDate());
                    trackingSet.save();
                }
                catch (Throwable throwable) {
                    NotifyUtil.closeAndCleanup(trackingSet);
                    throw throwable;
                }
            }
            NotifyUtil.closeAndCleanup(trackingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushConfirm(long trackingId, String receivedDate, String sessionId, long deviceId) throws RemoteException, MXException {
        if (NotifyUtil.isTrackingPush()) {
            MboSetRemote trackingSet;
            block6: {
                trackingSet = null;
                try {
                    trackingSet = MXServer.getMXServer().getMboSet("ISTRACKING", MXServer.getMXServer().getSystemUserInfo());
                    MboRemote tracking = trackingSet.getMboForUniqueId(trackingId);
                    if (tracking == null) break block6;
                    try {
                        tracking.setValue("PUSHRECEIVED", ISO8601Formatter.parse(receivedDate));
                        if ("TEST".equals(tracking.getString("TYPE"))) {
                            tracking.setValue("STOPPED", MXServer.getMXServer().getDate());
                        }
                        tracking.setValue("DEVICEID", deviceId);
                    }
                    catch (ParseException e) {
                        NotifyConstants.INFORMER_LOGGER.warn((Object)("Client for session id " + sessionId + " sent an invalid timestamp: " + receivedDate + " using current time."));
                        tracking.setValue("PUSHRECEIVED", MXServer.getMXServer().getDate());
                    }
                    trackingSet.save();
                    tracking.setValue("STOPPED", MXServer.getMXServer().getDate());
                    trackingSet.save();
                }
                catch (Throwable throwable) {
                    NotifyUtil.closeAndCleanup(trackingSet);
                    throw throwable;
                }
            }
            NotifyUtil.closeAndCleanup(trackingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long pushTest() throws RemoteException, MXException {
        long l;
        if (!NotifyUtil.isTrackingPush()) {
            return -1L;
        }
        MboSetRemote trackingSet = null;
        try {
            trackingSet = MXServer.getMXServer().getMboSet("ISTRACKING", MXServer.getMXServer().getSystemUserInfo());
            MboRemote tracking = trackingSet.add();
            tracking.setValue("TYPE", "TEST");
            tracking.setValue("PUSHSENT", MXServer.getMXServer().getDate());
            trackingSet.save();
            l = tracking.getUniqueIDValue();
        }
        catch (Throwable throwable) {
            NotifyUtil.closeAndCleanup(trackingSet);
            throw throwable;
        }
        NotifyUtil.closeAndCleanup(trackingSet);
        return l;
    }
}

