/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.util.DaemonUtil;
import com.interlocsolutions.maximo.notify.util.InformerMonitorThread;
import com.interlocsolutions.maximo.notify.util.InformerMonitorThread$runRecurringInformerTask$;
import com.interlocsolutions.maximo.notify.util.InformerThread;
import com.interlocsolutions.maximo.notify.util.InformerThreadGroup;
import com.interlocsolutions.maximo.notify.util.InformerThreadIndefinite;
import com.interlocsolutions.maximo.notify.util.MboInterface;
import com.interlocsolutions.maximo.notify.util.MboSetRemoteClosableWrapper;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.ProcessorInfo;
import com.interlocsolutions.maximo.notify.util.ProcessorMonitorable;
import com.interlocsolutions.maximo.notify.util.ResultSetCloseableWrapper;
import com.interlocsolutions.maximo.notify.util.RuntimeInfo;
import com.interlocsolutions.maximo.notify.util.StatementCloseableWrapper;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionAccessor;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionManager;
import com.interlocsolutions.maximo.notify.util.db.DbServerType;
import java.io.Closeable;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.security.UserInfo;
import psdi.server.MXServer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0014J#\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0082\bJ\b\u0010\u0013\u001a\u00020\fH\u0014J\b\u0010\u0014\u001a\u00020\fH\u0014J\b\u0010\u0015\u001a\u00020\fH\u0014J\u001e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002R\u0014\u0010\u0005\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/interlocsolutions/maximo/notify/util/InformerMonitorThread;", "Lcom/interlocsolutions/maximo/notify/util/InformerThreadIndefinite;", "name", "", "(Ljava/lang/String;)V", "loggableName", "getLoggableName", "()Ljava/lang/String;", "allThreads", "Lkotlin/sequences/Sequence;", "Lcom/interlocsolutions/maximo/notify/util/InformerThread;", "cleanUpTask", "", "findThreads", "", "predicate", "Lkotlin/Function1;", "Ljava/lang/Thread;", "", "initTask", "onIntervalPause", "runRecurringInformerTask", "updateProcessorListForCategory", "processorCategory", "processorsRunning", "", "Lcom/interlocsolutions/maximo/notify/util/ProcessorInfo;", "isinformer"})
public final class InformerMonitorThread
extends InformerThreadIndefinite {
    @NotNull
    private final String loggableName;

    public InformerMonitorThread(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name, DaemonUtil.getMonitorSleepTime(), false, true, NotifyConstants.INFORMER_LOGGER);
        this.setPriority(1);
        this.loggableName = "Informer Process Monitor Thread";
    }

    @NotNull
    public final String getLoggableName() {
        return this.loggableName;
    }

    @Override
    protected void initTask() {
        this.setInterval(DaemonUtil.getMonitorSleepTime());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Starting " + this.loggableName));
        }
    }

    @Override
    protected void cleanUpTask() {
    }

    @Override
    protected void onIntervalPause() {
        super.onIntervalPause();
        this.setInterval(DaemonUtil.getMonitorSleepTime());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Pausing " + this.loggableName));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<InformerThread> findThreads(Function1<? super Thread, Boolean> predicate2) {
        void $this$filterTo$iv$iv;
        boolean $i$f$findThreads = false;
        List<InformerThread> list = InformerThreadGroup.getInformerThreadGroup().getInformerThreads();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getInformerThreadGroup().informerThreads");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)predicate2.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<InformerThread> allThreads() {
        void $this$filterTo$iv$iv$iv;
        InformerMonitorThread this_$iv = this;
        boolean $i$f$findThreads = false;
        List<InformerThread> list = InformerThreadGroup.getInformerThreadGroup().getInformerThreads();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getInformerThreadGroup().informerThreads");
        Iterable $this$filter$iv$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
            Thread it = (Thread)element$iv$iv$iv;
            boolean bl = false;
            if (!true) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        return CollectionsKt.asSequence((Iterable)((List)destination$iv$iv$iv));
    }

    @Override
    protected void runRecurringInformerTask() {
        Sequence<InformerThread> $this$filterIsInstance$iv = this.allThreads();
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter($this$filterIsInstance$iv, (Function1)runRecurringInformerTask$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence threads = sequence;
        Iterable $this$forEach$iv = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)threads, (Function1)runRecurringInformerTask.1.INSTANCE));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String category = (String)element$iv;
            boolean bl = false;
            List processorInfos2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)threads, (Function1)((Function1)new Function1<ProcessorMonitorable, Boolean>(category){
                final /* synthetic */ String $category;
                {
                    this.$category = $category;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ProcessorMonitorable thread) {
                    Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
                    return Intrinsics.areEqual((Object)thread.getProcessorCategory(), (Object)this.$category);
                }
            })), (Function1)runRecurringInformerTask.2.processorInfos.2.INSTANCE));
            this.updateProcessorListForCategory(category, processorInfos2);
        }
        $this$forEach$iv = threads;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProcessorMonitorable thread = (ProcessorMonitorable)element$iv;
            boolean bl = false;
            thread.logAdditionalInformation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void updateProcessorListForCategory(String processorCategory, Collection<ProcessorInfo> processorsRunning) {
        Object item$iv$iv2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void query$iv;
        Iterable $this$queryRaw_u24default$iv;
        DbConnectionAccessor dbConnectionAccessor = DbConnectionManager.getInstance().getQueueConnection();
        Intrinsics.checkNotNullExpressionValue((Object)dbConnectionAccessor, (String)"getInstance().queueConnection");
        DbConnectionAccessor qConn = dbConnectionAccessor;
        RuntimeInfo runtimeInfo = RuntimeInfo.getRuntimeInfo();
        DbConnectionAccessor dbConnectionAccessor2 = qConn;
        String string = StringsKt.trimIndent((String)("\n                SELECT name\n                FROM isqueueprocessorstate\n                WHERE host = '" + runtimeInfo.host + "' \n                  AND mxname = '" + runtimeInfo.mxName + "' \n                  AND category = '" + processorCategory + "'\n                "));
        List bindArgs$iv = null;
        boolean $i$f$queryRaw = false;
        List processorNamesInTable = (List)$this$queryRaw_u24default$iv.useConn((Function1)new Function1<Connection, List<String>>((String)query$iv, bindArgs$iv){
            final /* synthetic */ String $query;
            final /* synthetic */ List $bindArgs;
            {
                this.$query = $query;
                this.$bindArgs = $bindArgs;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final List<String> invoke(@NotNull Connection conn) {
                List list;
                void sqlStr$iv;
                void $this$usePrepStatement_u24default$iv;
                Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
                Connection connection = conn;
                String string = this.$query;
                List bindArgs$iv = this.$bindArgs;
                Object resultSetType$iv = null;
                Object resultSetConcurrency$iv = null;
                Object resultSetHoldability$iv = null;
                Object generatedKeys$iv = null;
                boolean $i$f$usePrepStatement = false;
                PreparedStatement stmt$iv = $this$usePrepStatement_u24default$iv.prepareStatement((String)sqlStr$iv);
                Statement $this$use$iv$iv = stmt$iv;
                boolean $i$f$use = false;
                Closeable closeable = (Closeable)new StatementCloseableWrapper($this$use$iv$iv);
                Throwable throwable = null;
                try {
                    List list2;
                    StatementCloseableWrapper it$iv$iv = (StatementCloseableWrapper)closeable;
                    boolean bl = false;
                    PreparedStatement prepStmt$iv = (PreparedStatement)$this$use$iv$iv;
                    boolean bl2 = false;
                    List list3 = bindArgs$iv;
                    if (list3 != null) {
                        Iterable $this$forEachIndexed$iv$iv = list3;
                        boolean $i$f$forEachIndexed = false;
                        int index$iv$iv = 0;
                        for (T item$iv$iv : $this$forEachIndexed$iv$iv) {
                            void arg$iv;
                            int n;
                            if ((n = index$iv$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            T t = item$iv$iv;
                            int index$iv = n;
                            boolean bl3 = false;
                            void var28_33 = arg$iv;
                            if (var28_33 instanceof Boolean) {
                                if (DbServerType.identify((Connection)$this$usePrepStatement_u24default$iv) == DbServerType.POSTGRESQL) {
                                    prepStmt$iv.setInt(index$iv + 1, (Boolean)arg$iv != false ? 1 : 0);
                                    continue;
                                }
                                prepStmt$iv.setBoolean(index$iv + 1, (Boolean)arg$iv);
                                continue;
                            }
                            if (var28_33 instanceof Integer) {
                                prepStmt$iv.setInt(index$iv + 1, ((Number)arg$iv).intValue());
                                continue;
                            }
                            if (var28_33 instanceof Long) {
                                prepStmt$iv.setLong(index$iv + 1, ((Number)arg$iv).longValue());
                                continue;
                            }
                            if (var28_33 instanceof Date) {
                                prepStmt$iv.setDate(index$iv + 1, (Date)arg$iv);
                                continue;
                            }
                            if (var28_33 instanceof java.util.Date) {
                                prepStmt$iv.setTimestamp(index$iv + 1, new Timestamp(((java.util.Date)arg$iv).getTime()));
                                continue;
                            }
                            if (var28_33 instanceof Timestamp) {
                                prepStmt$iv.setTimestamp(index$iv + 1, (Timestamp)arg$iv);
                                continue;
                            }
                            if (var28_33 instanceof String) {
                                prepStmt$iv.setString(index$iv + 1, (String)arg$iv);
                                continue;
                            }
                            if (var28_33 instanceof Clob) {
                                prepStmt$iv.setClob(index$iv + 1, (Clob)arg$iv);
                                continue;
                            }
                            if (var28_33 instanceof Reader) {
                                prepStmt$iv.setClob(index$iv + 1, (Reader)arg$iv);
                                continue;
                            }
                            prepStmt$iv.setObject(index$iv + 1, arg$iv);
                        }
                    }
                    Statement $this$use$iv$iv2 = prepStmt$iv;
                    boolean $i$f$use2 = false;
                    Closeable closeable2 = (Closeable)new StatementCloseableWrapper($this$use$iv$iv2);
                    Object object = null;
                    try {
                        List list4;
                        StatementCloseableWrapper it$iv$iv2 = (StatementCloseableWrapper)closeable2;
                        $i$a$-use-JDBCExtensionsKt$use$2$iv$iv = false;
                        PreparedStatement it$iv = (PreparedStatement)$this$use$iv$iv2;
                        boolean bl4 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it$iv, (String)"it");
                        PreparedStatement stmt = it$iv;
                        boolean bl5 = false;
                        ResultSet $this$use$iv = stmt.executeQuery();
                        boolean $i$f$use3 = false;
                        Closeable closeable3 = (Closeable)new ResultSetCloseableWrapper($this$use$iv);
                        Throwable throwable2 = null;
                        try {
                            ResultSetCloseableWrapper it$iv2 = (ResultSetCloseableWrapper)closeable3;
                            boolean bl6 = false;
                            ResultSet resultSet = $this$use$iv;
                            boolean bl7 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"resultSet");
                            ResultSet rs = resultSet;
                            boolean bl8 = false;
                            List names = new ArrayList<E>();
                            while (rs.next()) {
                                String string2 = rs.getString(1);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"rs.getString(1)");
                                names.add(string2);
                            }
                            list4 = names;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable2);
                        }
                        list2 = list4;
                    }
                    catch (Throwable throwable4) {
                        try {
                            object = throwable4;
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            CloseableKt.closeFinally((Closeable)closeable2, object);
                            throw throwable5;
                        }
                    }
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
                    list = list2;
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return list;
            }
        });
        $this$queryRaw_u24default$iv = processorsRunning;
        Iterable iterable = processorNamesInTable;
        boolean $i$f$map = false;
        bindArgs$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void it;
            ProcessorInfo processorInfo = (ProcessorInfo)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        Iterable $this$forEach$iv = CollectionsKt.minus((Iterable)iterable, (Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String defunctProcessorName = (String)element$iv;
            boolean bl = false;
            item$iv$iv2 = new Object[]{runtimeInfo.host, runtimeInfo.mxName, defunctProcessorName};
            qConn.executeUpdate("DELETE FROM isqueueprocessorstate\nWHERE host = ? AND mxname = ? AND name = ?", item$iv$iv2);
        }
        $this$forEach$iv = processorsRunning;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProcessorInfo runningProcessor = (ProcessorInfo)element$iv;
            boolean bl = false;
            item$iv$iv2 = new Object[]{runningProcessor.getState(), MXServer.getMXServer().getDate(), runtimeInfo.host, runtimeInfo.mxName, runningProcessor.getName()};
            int rowsUpdated = qConn.executeUpdate("UPDATE isqueueprocessorstate\nSET state = ?, lastupdated = ?\nWHERE host = ? AND mxname = ? AND name = ?", item$iv$iv2);
            if (rowsUpdated >= 1) continue;
            if (qConn.isMaximoDB()) {
                void this_$iv$iv;
                UserInfo userInfo$iv;
                String mboName$iv = "ISQUEUEPROCESSORSTATE";
                Intrinsics.checkNotNullExpressionValue((Object)MXServer.getMXServer().getSystemUserInfo(), (String)"getMXServer().systemUserInfo");
                boolean $i$f$createMbo = false;
                MboInterface mboInterface = MboInterface.Companion.obtain(userInfo$iv);
                boolean $i$f$createMbo2 = false;
                MboSetRemote $this$use$iv$iv$iv = MXServer.getMXServer().getMboSet(mboName$iv, this_$iv$iv.getUserInfo());
                boolean $i$f$use = false;
                Closeable closeable = new MboSetRemoteClosableWrapper($this$use$iv$iv$iv);
                Throwable throwable = null;
                try {
                    MboSetRemoteClosableWrapper it$iv$iv$iv = (MboSetRemoteClosableWrapper)closeable;
                    boolean bl2 = false;
                    MboSetRemote mboSet$iv$iv = $this$use$iv$iv$iv;
                    boolean bl3 = false;
                    MboRemote $this$updateProcessorListForCategory_u24lambda_u247_u24lambda_u246 = mboSet$iv$iv.add();
                    boolean bl4 = false;
                    $this$updateProcessorListForCategory_u24lambda_u247_u24lambda_u246.setValue("HOST", runtimeInfo.host);
                    $this$updateProcessorListForCategory_u24lambda_u247_u24lambda_u246.setValue("MXNAME", runtimeInfo.mxName);
                    $this$updateProcessorListForCategory_u24lambda_u247_u24lambda_u246.setValue("NAME", runningProcessor.getName());
                    $this$updateProcessorListForCategory_u24lambda_u247_u24lambda_u246.setValue("CATEGORY", processorCategory);
                    $this$updateProcessorListForCategory_u24lambda_u247_u24lambda_u246.setValue("TYPE", runningProcessor.getProcessorType());
                    $this$updateProcessorListForCategory_u24lambda_u247_u24lambda_u246.setValue("STATE", runningProcessor.getState());
                    $this$updateProcessorListForCategory_u24lambda_u247_u24lambda_u246.setValue("LASTUPDATED", MXServer.getMXServer().getDate());
                    mboSet$iv$iv.save();
                    Unit unit = Unit.INSTANCE;
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    continue;
                }
            }
            Object[] objectArray = new Object[]{runtimeInfo.host, runtimeInfo.mxName, runningProcessor.getName(), processorCategory, runningProcessor.getProcessorType(), runningProcessor.getState(), MXServer.getMXServer().getDate()};
            qConn.executeUpdate("INSERT INTO isqueueprocessorstate (host, mxname, name, category, type, state, lastupdated)\nVALUES (?, ?, ?, ?, ?, ?, ?)", objectArray);
        }
    }
}

