/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.classloader.InformerClass;
import com.interlocsolutions.maximo.notify.classloader.InformerClassesService;
import com.interlocsolutions.maximo.notify.util.SemanticVersion;
import java.rmi.RemoteException;
import java.text.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

public class InformerClassUtils {
    public static <T> Class<T> loadClass(String className) throws RemoteException, MXException, ClassNotFoundException, ClassCastException {
        InformerClassesService classSvc = InformerClassUtils.getInformerClassesService();
        Class<?> result = classSvc != null ? classSvc.getClassLoader().loadClass(className) : ClassLoader.getSystemClassLoader().loadClass(className);
        if (result == null) {
            throw new ClassNotFoundException(className);
        }
        return result;
    }

    public static <T> T noArgInstantiate(String className) throws RemoteException, MXException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        return InformerClassUtils.loadClass(className).newInstance();
    }

    public static InformerClassesService getInformerClassesService() throws RemoteException, MXException {
        return (InformerClassesService)MXServer.getMXServer().lookupLocal("NOTIFYCLASSES");
    }

    public static InformerClassesService getInformerClassesServiceOrFail() throws RemoteException, MXException {
        InformerClassesService service = InformerClassUtils.getInformerClassesService();
        if (service == null) {
            throw new MXApplicationException("informer", "ClassServiceUnavail");
        }
        return service;
    }

    @Nullable
    public static SemanticVersion getClassVersion(@NotNull Object o) throws ParseException {
        String versionStr = InformerClassUtils.getClassVersionStr(o);
        return versionStr == null ? null : SemanticVersion.Companion.parse(versionStr);
    }

    @Nullable
    public static String getClassVersionStr(@NotNull Object o) {
        Class<?> clazz = o instanceof Class ? (Class<?>)o : o.getClass();
        InformerClass classAnnotation = clazz.getAnnotation(InformerClass.class);
        return classAnnotation == null ? null : classAnnotation.version();
    }
}

