/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class IOUtils {
    public static long streamCopy(InputStream source, OutputStream sink, int buffersize) throws IOException {
        int bytesRead;
        long totalRead = 0L;
        byte[] buffer = new byte[buffersize];
        while ((bytesRead = source.read(buffer)) > 0) {
            sink.write(buffer, 0, bytesRead);
            totalRead += (long)bytesRead;
        }
        return totalRead;
    }

    public static long streamCopy(Reader source, Writer sink, int buffersize) throws IOException {
        int bytesRead;
        long totalRead = 0L;
        char[] buffer = new char[buffersize];
        while ((bytesRead = source.read(buffer)) > 0) {
            sink.write(buffer, 0, bytesRead);
            totalRead += (long)bytesRead;
        }
        return totalRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long fileToWriter(File sourcefile, Writer writer, int buffersize) throws IOException {
        long l;
        FileReader r = new FileReader(sourcefile);
        try {
            l = IOUtils.streamCopy(r, writer, buffersize);
        }
        catch (Throwable throwable) {
            try {
                r.close();
            }
            catch (IOException e) {
                System.err.printf("Error closing file:%s%n", e);
            }
            throw throwable;
        }
        try {
            r.close();
        }
        catch (IOException e) {
            System.err.printf("Error closing file:%s%n", e);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fileToBytes(File sourcefile, int buffersize) throws IOException {
        byte[] byArray;
        FileInputStream r = new FileInputStream(sourcefile);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int bytesRead;
            byte[] buffer = new byte[buffersize];
            while ((bytesRead = r.read(buffer)) > 0) {
                baos.write(buffer, 0, bytesRead);
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                r.close();
            }
            catch (IOException e) {
                System.err.printf("Error closing file:%s%n", e);
            }
            throw throwable;
        }
        try {
            r.close();
        }
        catch (IOException e) {
            System.err.printf("Error closing file:%s%n", e);
        }
        return byArray;
    }

    public static String fileToString(File sourcefile, int buffersize) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtils.fileToWriter(sourcefile, sw, buffersize);
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long stringToFile(String source, File dest) throws IOException {
        long l;
        FileWriter sink = new FileWriter(dest);
        try {
            sink.write(source);
            l = source.length();
        }
        catch (Throwable throwable) {
            try {
                ((Writer)sink).close();
            }
            catch (IOException e) {
                System.err.printf("Error closing file:%s%n", e);
            }
            throw throwable;
        }
        try {
            ((Writer)sink).close();
        }
        catch (IOException e) {
            System.err.printf("Error closing file:%s%n", e);
        }
        return l;
    }
}

