/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.err.InformerSqlException;
import com.interlocsolutions.maximo.notify.util.MaximoVersion;
import com.interlocsolutions.maximo.notify.util.MboUtil;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.db.DataUtils;
import com.interlocsolutions.maximo.notify.util.db.DbServerType;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.app.system.CrontaskParamInfo;
import psdi.mbo.MboRemote;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.server.SimpleCronTask;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class DeviceCleanupCronTask
extends SimpleCronTask {
    public static final String CATALOG_DELTA_THRESHOLD = "catalogDeltaThreshold";
    public static final String DAYS_INACTIVE_THRESHOLD = "daysInactiveThreshold";
    public static final String CATALOG_DELTA_OVERRIDE = "catalogDeltaOverride";
    private static final CrontaskParamInfo[] params;

    public CrontaskParamInfo[] getParameters() throws MXException, RemoteException {
        return params;
    }

    public void cronAction() {
        block6: {
            MXLogger logger2 = this.getCronTaskLogger();
            logger2.info((Object)"Resetting obsolete Informer devices and registrations");
            try {
                int maxDrift;
                UserInfo userInfo = this.getRunasUserInfo();
                int maxDays = this.getParamAsInt(DAYS_INACTIVE_THRESHOLD);
                if (maxDays >= 0) {
                    this.cleanupAbandonedDevices(userInfo, maxDays);
                }
                if ((maxDrift = this.getParamAsInt(CATALOG_DELTA_THRESHOLD)) >= 0) {
                    this.resetOutOfSyncCatalogDevices(userInfo, maxDrift, this.parseCatalogDeltaOverride());
                }
                logger2.info((Object)"Finished resetting obsolete Informer devices and registrations");
            }
            catch (RemoteException | MXException e) {
                logger2.error((Object)"An error occurred while resetting obsolete Informer devices and registrations", e);
                if (MaximoVersion.Companion.getSystemVersion().handlesCronExceptions()) {
                    throw new RuntimeException(e);
                }
            }
            catch (RuntimeException e) {
                logger2.error((Object)"An error occurred while resetting obsolete Informer devices and registrations", (Throwable)e);
                if (!MaximoVersion.Companion.getSystemVersion().handlesCronExceptions()) break block6;
                throw e;
            }
        }
    }

    private void cleanupAbandonedDevices(UserInfo userInfo, final int cutoffNumDays) throws RemoteException, MXException {
        final MXLogger logger2 = this.getCronTaskLogger();
        SqlFormat sqlf = new SqlFormat("deviceid IN (SELECT deviceid FROM (SELECT deviceid, MAX(active) last_active FROM issessionhistory WHERE deviceid IN (SELECT deviceid FROM isdevice WHERE active = 1) GROUP BY deviceid ) dev_last_active WHERE last_active < :1 UNION ALL SELECT deviceid FROM isdevice d WHERE NOT EXISTS (SELECT * FROM ISSESSIONHISTORY i WHERE d.DEVICEID = i.DEVICEID) and active = 1 )");
        Date nowDate = MXServer.getMXServer().getDate();
        long cutoffMillis = TimeUnit.MILLISECONDS.convert(cutoffNumDays, TimeUnit.DAYS);
        Date cutoffDate = new Date(nowDate.getTime() - cutoffMillis);
        sqlf.setDate(1, cutoffDate);
        String whereClause = sqlf.format();
        NotifyUtil.visitMbos(userInfo, "ISDEVICE", whereClause, new NotifyUtil.MboVisitor(){

            @Override
            public void visit(@NotNull MboRemote mbo) throws RemoteException, MXException {
                if (logger2.isInfoEnabled()) {
                    logger2.info((Object)String.format("Informer Device %s=%d (serialnum %s, last_user \"%s\") has not logged in for %d days. This device is now considered abandoned and its Informer registrations will be reset. If the device does try to log in again, a full re-provisioning should occur.", mbo.getUniqueIDName(), mbo.getUniqueIDValue(), mbo.getString("SERIALNUM"), mbo.getString("DEVICEUSER.PERSON.DISPLAYNAME"), cutoffNumDays));
                }
                mbo.setValueNull("PROFILES");
                mbo.delete();
            }
        });
    }

    private void resetOutOfSyncCatalogDevices(UserInfo userInfo, final long maxDelta, final Map<String, Long> overrides) throws RemoteException, MXException {
        Collection<CatalogThresholds> catInfos;
        final MXLogger logger2 = this.getCronTaskLogger();
        try {
            String catalogSql = "SELECT DISTINCT icd.catalogid, icd.revision, icd.langcode, n.NOTIFYNUM , ic.CATALOG, icd.partitionname  FROM iscatalogdevice icd    INNER JOIN iscatalog ic ON icd.CATALOGID  = ic.CATALOGID   INNER JOIN isnotify n ON ic.NOTIFYID = n.NOTIFYID ";
            catInfos = DataUtils.systemRawQuery(catalogSql, new DataUtils.ResultSetHandler<Collection<CatalogThresholds>>(){

                @Override
                public Collection<CatalogThresholds> useResultSet(@NotNull ResultSet rs) throws SQLException {
                    int colCatalogId = rs.findColumn("CATALOGID");
                    int colCatalogRev = rs.findColumn("REVISION");
                    int colCatalogLang = rs.findColumn("LANGCODE");
                    int colProfileName = rs.findColumn("NOTIFYNUM");
                    int colCatalogName = rs.findColumn("CATALOG");
                    int colCatalogPartition = rs.findColumn("PARTITIONNAME");
                    ArrayList<CatalogThresholds> catInfo = new ArrayList<CatalogThresholds>();
                    while (rs.next()) {
                        CatalogThresholds thisEntry = new CatalogThresholds(rs.getLong(colCatalogId), rs.getLong(colCatalogRev), rs.getString(colCatalogLang), rs.getString(colProfileName), rs.getString(colCatalogName), rs.getString(colCatalogPartition));
                        catInfo.add(thisEntry);
                    }
                    return catInfo;
                }
            });
            DataUtils.systemDbConn(new DataUtils.DbConnectionCallback<Void>(){

                @Override
                public Void useConnection(@NotNull Connection conn, @NotNull DbServerType dbServerType) throws SQLException {
                    String fullSql = new SqlFormat("SELECT sequence FROM (SELECT ROW_NUMBER() OVER (ORDER BY sequence DESC) AS rownumber, sequence FROM iscatalogdata WHERE catalogid = ? AND revision = ? AND langcode = ? AND mainrecord = :yes) a WHERE a.rownumber = ?").format();
                    String partitionSql = new SqlFormat("SELECT sequence FROM (SELECT ROW_NUMBER() OVER (ORDER BY sequence DESC) AS rownumber, sequence FROM iscatalogdata WHERE catalogid = ? AND revision = ? AND langcode = ? AND partitionname = ?) a WHERE a.rownumber = ?").format();
                    try (PreparedStatement preparedStatementFull = conn.prepareStatement(fullSql);
                         PreparedStatement preparedStatementPartitioned = conn.prepareStatement(partitionSql);){
                        for (CatalogThresholds catInfo : catInfos) {
                            PreparedStatement statement;
                            catInfo.delta = overrides.getOrDefault(DeviceCleanupCronTask.this.formatName(catInfo.profile, catInfo.catalogName, catInfo.partition), maxDelta);
                            preparedStatementFull.setLong(4, catInfo.delta);
                            preparedStatementPartitioned.setLong(5, catInfo.delta);
                            if (catInfo.partition == null) {
                                statement = preparedStatementFull;
                            } else {
                                preparedStatementPartitioned.setString(4, catInfo.partition);
                                statement = preparedStatementPartitioned;
                            }
                            statement.setLong(1, catInfo.catalogId);
                            statement.setLong(2, catInfo.revision);
                            statement.setString(3, catInfo.langCode);
                            ResultSet resultSet = statement.executeQuery();
                            try {
                                if (resultSet.next()) {
                                    catInfo.thresholdSeq = resultSet.getLong("sequence");
                                    continue;
                                }
                                if (logger2.isDebugEnabled()) {
                                    logger2.debug((Object)String.format("%s has less than %d records. Its devices will not be cleaned up.", catInfo, catInfo.delta));
                                }
                                catInfo.thresholdSeq = -1L;
                            }
                            finally {
                                if (resultSet == null) continue;
                                resultSet.close();
                            }
                        }
                    }
                    return null;
                }
            });
        }
        catch (SQLException e) {
            throw new InformerSqlException(e);
        }
        for (final CatalogThresholds catInfo : catInfos) {
            String whereClause;
            SqlFormat outOfSyncDevicesSqlf;
            if (catInfo.thresholdSeq < 1L) continue;
            if (catInfo.partition == null) {
                outOfSyncDevicesSqlf = new SqlFormat("catalogid = :1 AND revision = :2 AND langcode = :3 AND partitionname IS NULL AND sequence < :4");
                outOfSyncDevicesSqlf.setLong(1, catInfo.catalogId);
                outOfSyncDevicesSqlf.setLong(2, catInfo.revision);
                outOfSyncDevicesSqlf.setObject(3, "ISCATALOGDEVICE", "LANGCODE", catInfo.langCode);
                outOfSyncDevicesSqlf.setLong(4, catInfo.thresholdSeq);
                whereClause = outOfSyncDevicesSqlf.format();
            } else {
                outOfSyncDevicesSqlf = new SqlFormat("catalogid = :1 AND revision = :2 AND langcode = :3 AND partitionname = :4 AND sequence < :5");
                outOfSyncDevicesSqlf.setLong(1, catInfo.catalogId);
                outOfSyncDevicesSqlf.setLong(2, catInfo.revision);
                outOfSyncDevicesSqlf.setObject(3, "ISCATALOGDEVICE", "LANGCODE", catInfo.langCode);
                outOfSyncDevicesSqlf.setObject(4, "ISCATALOGDEVICE", "PARTITIONNAME", catInfo.partition);
                outOfSyncDevicesSqlf.setLong(5, catInfo.thresholdSeq);
                whereClause = outOfSyncDevicesSqlf.format();
            }
            if (logger2.isDebugEnabled()) {
                logger2.debug((Object)("Selecting ISCATALOGDEVICE where" + whereClause));
            }
            MboUtil.visitMbos(userInfo, "ISCATALOGDEVICE", whereClause, new NotifyUtil.MboVisitor(){

                @Override
                public void visit(@NotNull MboRemote catDev) throws RemoteException, MXException {
                    if (logger2.isInfoEnabled()) {
                        logger2.info((Object)String.format("Informer Device %s=%d (serialnum %s, last_user \"%s\") is > %d records behind in synchronization of Catalog %s:%s, partition %s, langcode %s. This device's Catalog registration will be reset, and re-provisioning of this specific Catalog should occur when synchronization is next attempted.", catDev.getUniqueIDName(), catDev.getUniqueIDValue(), catDev.getString("DEVICE.SERIALNUM"), catDev.getString("DEVICE.DEVICEUSER.PERSON.DISPLAYNAME"), catInfo.delta, catDev.getString("CATALOG.NOTIFY.NOTIFYNUM"), catDev.getString("CATALOG.CATALOG"), catInfo.partition, catInfo.langCode));
                    }
                    catDev.delete();
                }
            });
        }
    }

    private Map<String, Long> parseCatalogDeltaOverride() throws RemoteException, MXException {
        MXLogger logger2 = this.getCronTaskLogger();
        HashMap<String, Long> rc2 = new HashMap<String, Long>();
        Pattern breakOverride = Pattern.compile("^([^.]+\\.[^.]+):([0-9]+)$");
        String parameter = this.getParamAsString(CATALOG_DELTA_OVERRIDE);
        if (!parameter.trim().contentEquals("")) {
            String[] overrides;
            for (String override : overrides = this.getParamAsString(CATALOG_DELTA_OVERRIDE).split(";")) {
                Matcher matcher = breakOverride.matcher(override);
                if (matcher.find()) {
                    rc2.put(matcher.group(1), Long.parseLong(matcher.group(2)));
                    continue;
                }
                logger2.warn((Object)String.format("Unable to parse %s.", override));
            }
        }
        return rc2;
    }

    private String formatName(String profile, String catalog, String partition) {
        StringBuilder sb = new StringBuilder();
        sb.append(profile).append(".").append(catalog);
        if (partition != null) {
            sb.append("_").append(partition);
        }
        return sb.toString();
    }

    static {
        CrontaskParamInfo retentionPeriod = new CrontaskParamInfo();
        retentionPeriod.setName(CATALOG_DELTA_THRESHOLD);
        retentionPeriod.setDescription("informer", CATALOG_DELTA_THRESHOLD);
        retentionPeriod.setDefault(Integer.toString(20000));
        CrontaskParamInfo daysSinceLastLogin = new CrontaskParamInfo();
        daysSinceLastLogin.setName(DAYS_INACTIVE_THRESHOLD);
        daysSinceLastLogin.setDescription("informer", DAYS_INACTIVE_THRESHOLD);
        daysSinceLastLogin.setDefault(Integer.toString(30));
        CrontaskParamInfo retentionPeriodOverride = new CrontaskParamInfo();
        retentionPeriodOverride.setName(CATALOG_DELTA_OVERRIDE);
        retentionPeriodOverride.setDescription("informer", CATALOG_DELTA_OVERRIDE);
        retentionPeriodOverride.setDefault("");
        params = new CrontaskParamInfo[]{retentionPeriod, daysSinceLastLogin, retentionPeriodOverride};
    }

    private static class CatalogThresholds {
        final long catalogId;
        final long revision;
        @NotNull
        final String langCode;
        final String profile;
        final String catalogName;
        @Nullable
        final String partition;
        long thresholdSeq = -1L;
        long delta = -1L;

        public CatalogThresholds(long catalogId, long revision, @NotNull String langCode, @NotNull String profile, @NotNull String catalogName, @Nullable String partition) {
            this.catalogId = catalogId;
            this.revision = revision;
            this.langCode = langCode;
            this.profile = profile;
            this.partition = partition;
            this.catalogName = catalogName;
        }

        public String toString() {
            return String.format(Locale.US, "CatalogForLang(id=%d, rev=%d, langcode=%s)", this.catalogId, this.revision, this.langCode);
        }
    }
}

