/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.util.AttachedDocumentProvider;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyFault;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.attachment.IAttachmentService;
import com.interlocsolutions.maximo.notify.xml.AttachedDocumentFragment;
import java.io.IOException;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.server.MXServer;
import psdi.util.MXException;

public class DefaultAttachedDocumentProvider
implements AttachedDocumentProvider {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AttachedDocumentFragment getAttachedDocumentFragment(long docInfoId, long offset, int length) throws NotifyFault {
        AttachedDocumentFragment attachedDocumentFragment;
        MboSetRemote docinfoSet = null;
        try {
            docinfoSet = MXServer.getMXServer().getMboSet("DOCINFO", MXServer.getMXServer().getSystemUserInfo());
            MboRemote docinfo = docinfoSet.getMboForUniqueId(docInfoId);
            if (docinfo == null) {
                NotifyFault nf = new NotifyFault(AttachedDocumentProvider.ERROR_CODE.DOCINFO_NOT_FOUND.toString());
                nf.setErrorCode(AttachedDocumentProvider.ERROR_CODE.DOCINFO_NOT_FOUND.toString());
                throw nf;
            }
            String urlType = MXServer.getMXServer().getMaximoDD().getTranslator().toExternalDefaultValue("URLTYPE", "FILE", docinfo);
            if (!docinfo.getString("URLTYPE").equals(urlType)) {
                throw new NotifyFault(String.format("The provided DOCINFO's URLTYPE is not `%s`.", urlType));
            }
            IAttachmentService attachmentService = IAttachmentService.getInstance();
            attachedDocumentFragment = attachmentService.getAttachedDocument(docinfo, offset, length);
        }
        catch (IOException e) {
            try {
                NotifyConstants.INFORMER_LOGGER.error((Object)("An error occurred getting file for docinfoid " + docInfoId), (Throwable)e);
                throw new NotifyFault(e);
                catch (MXException e2) {
                    throw new NotifyFault(e2);
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(docinfoSet);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(docinfoSet);
        return attachedDocumentFragment;
    }
}

