/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.util.MXServerFactory;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import psdi.app.system.CrontaskParamInfo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.server.SimpleCronTask;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class CatalogUpdateTriggerCronTask
extends SimpleCronTask {
    public static final String UPDATE_OBJECT = "updateObject";
    public static final String TRIGGER_FIELD = "triggerField";
    public static final String EVAL_DATE_FIELD = "evalDateField";
    public static final String EVAL_OFFSET = "evalOffSet";
    private static CrontaskParamInfo[] params = new CrontaskParamInfo[4];
    private boolean initialized = false;
    private int offset;
    private String objName;
    private String attrName;
    private String trigName;

    public void init() throws MXException {
        MXLogger logger2 = this.getCronTaskLogger();
        logger2.info((Object)"Initializing the Informer catalog update trigger cron task");
        super.init();
        try {
            this.objName = this.getParamAsString(UPDATE_OBJECT);
            this.attrName = this.getParamAsString(EVAL_DATE_FIELD);
            this.trigName = this.getParamAsString(TRIGGER_FIELD);
            try {
                this.offset = this.getParamAsInt(EVAL_OFFSET);
            }
            catch (Exception e) {
                logger2.warn((Object)("Error parsing duration period value, using default of " + this.offset + " day" + (this.offset > 1 ? "s" : "") + "."));
                logger2.warn((Object)e.getMessage());
            }
        }
        catch (RemoteException e) {
            logger2.error((Object)("An error occurred while reading the catalog update trigger parameters; " + e.getMessage() + ", the CronTask will not run."));
            this.initialized = false;
            return;
        }
        this.initialized = true;
        logger2.info((Object)"Initialized the Informer catalog update trigger cron task");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cronAction() {
        MboSetRemote targetSet;
        MboSetRemote updateSet;
        block23: {
            block22: {
                block21: {
                    MXLogger logger2 = this.getCronTaskLogger();
                    if (!this.initialized) return;
                    logger2.info((Object)"Updating objects to trigger informer catalogs.");
                    updateSet = null;
                    targetSet = null;
                    try {
                        this.objName = this.getParamAsString(UPDATE_OBJECT);
                        this.attrName = this.getParamAsString(EVAL_DATE_FIELD);
                        this.trigName = this.getParamAsString(TRIGGER_FIELD);
                        try {
                            this.offset = this.getParamAsInt(EVAL_OFFSET);
                        }
                        catch (Exception e) {
                            logger2.warn((Object)("Error parsing duration period value, using default of " + this.offset + " day" + (this.offset > 1 ? "s" : "") + "."));
                            logger2.warn((Object)e.getMessage());
                        }
                        Calendar c = Calendar.getInstance();
                        c.add(6, this.offset);
                        Date upperDate = c.getTime();
                        Date lastRunTime = this.getLastRunDate();
                        if (lastRunTime == null) {
                            return;
                        }
                        long window = lastRunTime.getTime() - MXServer.getMXServer().getDate().getTime();
                        c = Calendar.getInstance();
                        c.add(6, -1 * this.offset);
                        c.add(14, (int)window);
                        Date lowerDate = c.getTime();
                        updateSet = MXServerFactory.getMXServer().getMboSet(this.objName, this.getRunasUserInfo());
                        boolean isDate = updateSet.getMboSetInfo().getMboValueInfo(this.attrName).getMaxType().startsWith("DATE");
                        if (!isDate) {
                            logger2.error((Object)("The attribute field " + this.attrName + " is not of DATE or DATETIME type, cannot perform update."));
                            NotifyUtil.closeAndCleanup(updateSet);
                            break block21;
                        }
                        boolean isYorn = "YORN".equalsIgnoreCase(updateSet.getMboSetInfo().getMboValueInfo(this.trigName).getMaxType());
                        if (!isYorn) {
                            logger2.error((Object)"Update field is not YORN type, cannot perform update.");
                            NotifyUtil.closeAndCleanup(updateSet);
                            break block22;
                        }
                        SqlFormat sqlf = new SqlFormat(this.attrName + " < :1 and " + this.attrName + " > :2");
                        sqlf.setTimestamp(1, upperDate);
                        sqlf.setTimestamp(2, lowerDate);
                        updateSet.setWhere(sqlf.format());
                        updateSet.reset();
                        if (logger2.isInfoEnabled()) {
                            try {
                                int count = updateSet.count();
                                logger2.info((Object)("Updating " + this.trigName + " on " + count + " " + this.objName + " objects"));
                            }
                            catch (MXException count) {
                            }
                            catch (RemoteException count) {
                                // empty catch block
                            }
                        }
                        ArrayList<Long> ids = new ArrayList<Long>();
                        MboRemote update = null;
                        updateSet.setFlag(39L, true);
                        update = updateSet.moveFirst();
                        while (update != null) {
                            ids.add(update.getUniqueIDValue());
                            update = updateSet.moveNext();
                        }
                        targetSet = MXServerFactory.getMXServer().getMboSet(this.objName, this.getRunasUserInfo());
                        Iterator iterator = ids.iterator();
                        while (iterator.hasNext()) {
                            long id = (Long)iterator.next();
                            targetSet.reset();
                            update = targetSet.getMboForUniqueId(id);
                            if (update == null) continue;
                            update.setValue(this.trigName, !update.getBoolean(this.trigName), 3L);
                            targetSet.save();
                        }
                        logger2.info((Object)"Updated timed catalogs.");
                        NotifyUtil.closeAndCleanup(updateSet);
                        break block23;
                    }
                    catch (MXException e) {
                        logger2.error((Object)("An error occured while updating the catalog set;" + e.getMessage()));
                        return;
                    }
                    catch (RemoteException e) {
                        logger2.error((Object)("An error occured while updating the catalog set;" + e.getMessage()));
                        return;
                    }
                }
                NotifyUtil.closeAndCleanup(targetSet);
                return;
            }
            NotifyUtil.closeAndCleanup(targetSet);
            return;
        }
        NotifyUtil.closeAndCleanup(targetSet);
        return;
        finally {
            NotifyUtil.closeAndCleanup(updateSet);
            NotifyUtil.closeAndCleanup(targetSet);
        }
    }

    public CrontaskParamInfo[] getParameters() {
        return params;
    }

    static {
        CrontaskParamInfo updateObject = new CrontaskParamInfo();
        updateObject.setName(UPDATE_OBJECT);
        updateObject.setDescription("informer", UPDATE_OBJECT);
        CatalogUpdateTriggerCronTask.params[0] = updateObject;
        CrontaskParamInfo triggerField = new CrontaskParamInfo();
        triggerField.setName(TRIGGER_FIELD);
        triggerField.setDescription("informer", TRIGGER_FIELD);
        CatalogUpdateTriggerCronTask.params[1] = triggerField;
        CrontaskParamInfo evalDateField = new CrontaskParamInfo();
        evalDateField.setName(EVAL_DATE_FIELD);
        evalDateField.setDescription("informer", EVAL_DATE_FIELD);
        CatalogUpdateTriggerCronTask.params[2] = evalDateField;
        CrontaskParamInfo evalDuration = new CrontaskParamInfo();
        evalDuration.setName(EVAL_OFFSET);
        evalDuration.setDescription("informer", EVAL_OFFSET);
        CatalogUpdateTriggerCronTask.params[3] = evalDuration;
    }
}

