/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.Catalog;
import com.interlocsolutions.maximo.notify.err.InformerException;
import com.interlocsolutions.maximo.notify.queue.catalog.CatalogPartitioner;
import com.interlocsolutions.maximo.notify.queue.catalog.CatalogPartitioners;
import com.interlocsolutions.maximo.notify.util.InformerClassUtils;
import com.interlocsolutions.maximo.notify.util.MboSetIterator;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.util.MXException;

public class CachedCatalog {
    public final long notifyId;
    public final String notifyNum;
    public final long notifyRevision;
    public final long catalogId;
    public final long catalogRevision;
    public final String catalogName;
    public final String objectName;
    public final String whereClause;
    public final String conditionName;
    public final String conditionClass;
    public final String conditionExpr;
    public final String[] attributes;
    public final String[] filterAttributes;
    public final boolean preloadSupported;
    @NotNull
    public final Catalog.PartitionType partitionType;
    @NotNull
    public final CatalogPartitioner partitioner;
    @NotNull
    public final Catalog.Strategy strategy;
    public final boolean dispatch;

    public CachedCatalog(MboRemote catalog) throws RemoteException, MXException {
        this.notifyId = catalog.getLong("NOTIFYID");
        this.notifyNum = catalog.getString("NOTIFY.NOTIFYNUM");
        this.notifyRevision = catalog.getLong("NOTIFY.REVISION");
        this.catalogId = catalog.getLong("CATALOGID");
        this.catalogRevision = catalog.getLong("REVISION");
        this.catalogName = catalog.getString("CATALOG");
        this.objectName = catalog.getString("OBJECTNAME");
        this.whereClause = catalog.getString("WHERECLAUSE");
        this.conditionName = catalog.getString("CONDITIONNAME");
        this.conditionClass = catalog.getString("CONDITIONCLASS");
        this.conditionExpr = catalog.getString("CONDITIONEXPR");
        this.preloadSupported = catalog.getBoolean("PRELOAD");
        this.partitionType = Catalog.PartitionType.valueOf(catalog.getString("PARTITIONTYPE"));
        this.strategy = Catalog.Strategy.valueOf(catalog.getString("STRATEGY"));
        this.dispatch = catalog.getBoolean("DISPATCH");
        MboSetRemote attributeSet = catalog.getMboSet("CATALOGATTRIBUTES");
        ArrayList<String> attributes = new ArrayList<String>();
        ArrayList<String> filterAttributes = new ArrayList<String>();
        MboSetIterator attrSetItr = new MboSetIterator(attributeSet);
        MboRemote mbo = attrSetItr.moveFirst();
        while (mbo != null) {
            if (mbo.getBoolean("INCATALOG")) {
                attributes.add(mbo.getString("ATTRIBUTENAME"));
            }
            if (mbo.getBoolean("INFILTER")) {
                filterAttributes.add(mbo.getString("ATTRIBUTENAME"));
            }
            mbo = attrSetItr.moveNext();
        }
        this.attributes = attributes.toArray(new String[attributes.size()]);
        this.filterAttributes = filterAttributes.toArray(new String[filterAttributes.size()]);
        if (!catalog.isNull("PARTITIONERCLASS")) {
            String partitionerClass = catalog.getString("PARTITIONERCLASS");
            try {
                this.partitioner = (CatalogPartitioner)InformerClassUtils.loadClass(partitionerClass).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new InformerException("cannotCreatePartitioner", new Object[]{this.notifyNum, this.catalogName, partitionerClass}, e);
            }
            catch (IllegalAccessException e) {
                throw new InformerException("cannotCreatePartitioner", new Object[]{this.notifyNum, this.catalogName, partitionerClass}, e);
            }
            catch (InstantiationException e) {
                throw new InformerException("cannotCreatePartitioner", new Object[]{this.notifyNum, this.catalogName, partitionerClass}, e);
            }
        } else {
            this.partitioner = !catalog.isNull("PARTITIONBYATTR") ? CatalogPartitioners.forAttribute(catalog.getString("PARTITIONBYATTR")) : CatalogPartitioners.defaultPartitioner();
        }
        if (!this.partitioner.validForObject(this.objectName)) {
            throw new InformerException("partitionerInapplicable", new String[]{this.partitioner.getClass().getName(), this.objectName});
        }
    }

    public String getPrefix() {
        if (this.catalogName.contains("_")) {
            return this.catalogName.split("_")[0];
        }
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof CachedCatalog && ((CachedCatalog)obj).catalogId == this.catalogId;
    }

    public int hashCode() {
        return (int)(this.catalogId ^ this.catalogId >>> 32);
    }

    public String toString() {
        return String.format("Catalog(%s:%s, rev %d)", this.notifyNum, this.catalogName, this.catalogRevision);
    }
}

