/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.util.InformerThreadIndefinite;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.jetbrains.annotations.NotNull;
import psdi.security.AdminModeManager;
import psdi.security.ConnectionKey;
import psdi.server.MXServer;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class AdminModeMonitor
extends InformerThreadIndefinite {
    public static final MXLogger LOGGER = NotifyConstants.INFORMER_LOGGER;
    @NotNull
    private AdminModeManager ad;

    public AdminModeMonitor(String name) {
        super(name, 10000L, false, false, NotifyConstants.INFORMER_LOGGER);
    }

    @Override
    protected void initTask() throws MXException, RemoteException {
        AdminModeManager manager = (AdminModeManager)MXServer.getMXServer().getFromMaximoCache("ADMINMODE");
        if (manager == null) {
            throw new RuntimeException(String.format("A reference to the %s (MaxCache \"%s\") could not be obtained.", AdminModeManager.class.getSimpleName(), "ADMINMODE"));
        }
        this.ad = manager;
    }

    @Override
    protected void cleanUpTask() {
    }

    @Override
    protected void runRecurringInformerTask() throws RemoteException, MXException, InformerThreadIndefinite.InformerTaskException {
        if (this.ad.isAdminModePendingThisInstance() || this.ad.isAdminModeOnThisInstance()) {
            Statement s = null;
            ConnectionKey key = MXServer.getMXServer().getDBManager().getSystemConnectionKey();
            try {
                String deleteSession = "delete issession";
                String deleteSessionCatalog = "delete issessioncatalog";
                String deleteSessionCatalogPage = "delete issessioncatpage";
                Connection cnn = MXServer.getMXServer().getDBManager().getConnection(key);
                s = cnn.createStatement();
                s.execute(deleteSession);
                s.execute(deleteSessionCatalog);
                s.execute(deleteSessionCatalogPage);
                cnn.commit();
                s.close();
            }
            catch (SQLException e) {
                try {
                    throw new InformerThreadIndefinite.InformerTaskException("Failed to clean up Informer session info during Admin Mode", e);
                }
                catch (Throwable throwable) {
                    NotifyUtil.close(s);
                    if (key != null) {
                        try {
                            MXServer.getMXServer().getDBManager().freeConnection(key);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            NotifyUtil.close(s);
            if (key != null) {
                try {
                    MXServer.getMXServer().getDBManager().freeConnection(key);
                }
                catch (RemoteException deleteSession) {}
            }
        }
    }
}

