/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.selftest;

import com.interlocsolutions.maximo.notify.selftest.BaseSelfTestDriver;
import com.interlocsolutions.maximo.notify.selftest.HttpClientKt;
import com.interlocsolutions.maximo.notify.selftest.OslcSelfTestDriver;
import com.interlocsolutions.maximo.notify.xml.CatalogObjects;
import com.interlocsolutions.maximo.notify.xml.NotificationId;
import com.interlocsolutions.maximo.notify.xml.NotificationIds;
import com.interlocsolutions.maximo.notify.xml.NotificationSession;
import com.interlocsolutions.maximo.notify.xml.ProfileResource;
import com.interlocsolutions.maximo.notify.xml.ProfileResourceList;
import com.interlocsolutions.maximo.notify.xml.UserProfile;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J0\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J0\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020*H\u0002J \u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0003H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u0010\u0013\u001a\u00020\u0014H\u0016JC\u00101\u001a\u0002H2\"\u0004\b\u0000\u001022\u0006\u00103\u001a\u00020\u00032\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u000206052\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u0002H208H\u0002\u00a2\u0006\u0002\u00109R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/interlocsolutions/maximo/notify/selftest/OslcSelfTestDriver;", "Lcom/interlocsolutions/maximo/notify/selftest/BaseSelfTestDriver;", "maximoUrl", "", "useHttpAuth", "", "useMaxAuth", "(Ljava/lang/String;ZZ)V", "client", "Lokhttp3/OkHttpClient;", "credential", "formatter", "Lkotlinx/serialization/json/Json;", "jsonMediaType", "Lokhttp3/MediaType;", "kotlin.jvm.PlatformType", "maxAuth", "getAvailableResources", "Lcom/interlocsolutions/maximo/notify/xml/ProfileResourceList;", "session", "Lcom/interlocsolutions/maximo/notify/xml/NotificationSession;", "profile", "getCatalogBaseline", "Lcom/interlocsolutions/maximo/notify/xml/CatalogObjects;", "catalog", "langCode", "partitionName", "getNotificationId", "Lcom/interlocsolutions/maximo/notify/xml/NotificationId;", "notificationId", "", "getNotificationIds", "Lcom/interlocsolutions/maximo/notify/xml/NotificationIds;", "getResource", "Lcom/interlocsolutions/maximo/notify/xml/ProfileResource;", "resource", "version", "", "getUserProfile", "Lcom/interlocsolutions/maximo/notify/xml/UserProfile;", "handleResponse", "response", "Lokhttp3/Response;", "login", "userName", "password", "extras", "logout", "", "makeCall", "R", "action", "body", "", "Lkotlinx/serialization/json/JsonElement;", "block", "Lkotlin/Function1;", "(Ljava/lang/String;Ljava/util/Map;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "isinformer"})
public final class OslcSelfTestDriver
extends BaseSelfTestDriver {
    @NotNull
    private final String maximoUrl;
    private final boolean useHttpAuth;
    private final boolean useMaxAuth;
    @NotNull
    private final OkHttpClient client;
    private final MediaType jsonMediaType;
    private String credential;
    private String maxAuth;
    @NotNull
    private final Json formatter;

    public OslcSelfTestDriver(@NotNull String maximoUrl, boolean useHttpAuth, boolean useMaxAuth) {
        Intrinsics.checkNotNullParameter((Object)maximoUrl, (String)"maximoUrl");
        this.maximoUrl = maximoUrl;
        this.useHttpAuth = useHttpAuth;
        this.useMaxAuth = useMaxAuth;
        this.client = HttpClientKt.newHttpClient();
        this.jsonMediaType = MediaType.get((String)"application/json");
        this.formatter = JsonKt.Json$default(null, (Function1)formatter.1.INSTANCE, (int)1, null);
    }

    @Override
    @NotNull
    public NotificationSession login(@NotNull String userName, @NotNull String password, @NotNull String extras) {
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        String string = Credentials.basic((String)userName, (String)password);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"basic(userName, password)");
        this.credential = string;
        String string2 = ByteString.encodeString((String)(userName + ':' + password), (Charset)StandardCharsets.ISO_8859_1).base64();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeString(\"$userName:\u2026sets.ISO_8859_1).base64()");
        this.maxAuth = string2;
        Map map = new LinkedHashMap();
        map.put("userName", JsonElementKt.JsonPrimitive((String)userName));
        map.put("password", JsonElementKt.JsonPrimitive((String)password));
        map.put("deviceName", JsonElementKt.JsonPrimitive((String)"Informer Self Test"));
        map.put("deviceSerialNumber", JsonElementKt.JsonPrimitive((String)"0001"));
        map.put("deviceOS", JsonElementKt.JsonPrimitive((String)"Java"));
        map.put("compressionSupported", JsonElementKt.JsonPrimitive((Boolean)false));
        map.put("extras", JsonElementKt.JsonPrimitive((String)extras));
        return (NotificationSession)this.makeCall("wsmethod:login", map, (Function1)new Function1<Response, NotificationSession>(this){
            final /* synthetic */ OslcSelfTestDriver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final NotificationSession invoke(@NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Object object = this.this$0.deserialize(OslcSelfTestDriver.access$handleResponse(this.this$0, response));
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.xml.NotificationSession");
                return (NotificationSession)object;
            }
        });
    }

    @Override
    public void logout(@NotNull NotificationSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Map map = new LinkedHashMap();
        map.put("sessionId", JsonElementKt.JsonPrimitive((String)session.getSessionId()));
        this.makeCall("wsmethod:logout", map, (Function1)new Function1<Response, Unit>(this){
            final /* synthetic */ OslcSelfTestDriver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                OslcSelfTestDriver.access$handleResponse(this.this$0, response);
            }
        });
    }

    @Override
    @NotNull
    public NotificationIds getNotificationIds(@NotNull NotificationSession session, @NotNull String profile) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Map map = new LinkedHashMap();
        map.put("notificationName", JsonElementKt.JsonPrimitive((String)profile));
        map.put("sessionId", JsonElementKt.JsonPrimitive((String)session.getSessionId()));
        return (NotificationIds)this.makeCall("wsmethod:getNotificationIds", map, (Function1)new Function1<Response, NotificationIds>(this){
            final /* synthetic */ OslcSelfTestDriver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final NotificationIds invoke(@NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Object object = this.this$0.deserialize(OslcSelfTestDriver.access$handleResponse(this.this$0, response));
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.xml.NotificationIds");
                return (NotificationIds)object;
            }
        });
    }

    @Override
    @NotNull
    public NotificationId getNotificationId(@NotNull NotificationSession session, long notificationId) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Map map = new LinkedHashMap();
        map.put("notificationId", JsonElementKt.JsonPrimitive((Number)notificationId));
        map.put("sessionId", JsonElementKt.JsonPrimitive((String)session.getSessionId()));
        return (NotificationId)this.makeCall("wsmethod:getNotification", map, (Function1)new Function1<Response, NotificationId>(this){
            final /* synthetic */ OslcSelfTestDriver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final NotificationId invoke(@NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Object object = this.this$0.deserialize(OslcSelfTestDriver.access$handleResponse(this.this$0, response));
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.xml.NotificationId");
                return (NotificationId)object;
            }
        });
    }

    @Override
    @NotNull
    public CatalogObjects getCatalogBaseline(@NotNull NotificationSession session, @NotNull String profile, @NotNull String catalog, @NotNull String langCode, @NotNull String partitionName) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)catalog, (String)"catalog");
        Intrinsics.checkNotNullParameter((Object)langCode, (String)"langCode");
        Intrinsics.checkNotNullParameter((Object)partitionName, (String)"partitionName");
        Map map = new LinkedHashMap();
        map.put("sessionId", JsonElementKt.JsonPrimitive((String)session.getSessionId()));
        map.put("notificationName", JsonElementKt.JsonPrimitive((String)profile));
        map.put("catalogName", JsonElementKt.JsonPrimitive((String)catalog));
        map.put("langCode", JsonElementKt.JsonPrimitive((String)langCode));
        map.put("partitionName", JsonElementKt.JsonPrimitive((String)partitionName));
        map.put("sequence", JsonElementKt.JsonPrimitive((Number)-1));
        return (CatalogObjects)this.makeCall("wsmethod:getCatalogBaseline", map, (Function1)new Function1<Response, CatalogObjects>(this){
            final /* synthetic */ OslcSelfTestDriver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CatalogObjects invoke(@NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Object object = this.this$0.deserialize(OslcSelfTestDriver.access$handleResponse(this.this$0, response));
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.xml.CatalogObjects");
                return (CatalogObjects)object;
            }
        });
    }

    @Override
    @NotNull
    public UserProfile getUserProfile(@NotNull NotificationSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Map map = new LinkedHashMap();
        map.put("sessionId", JsonElementKt.JsonPrimitive((String)session.getSessionId()));
        return (UserProfile)this.makeCall("wsmethod:getUserProfile", map, (Function1)new Function1<Response, UserProfile>(this){
            final /* synthetic */ OslcSelfTestDriver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final UserProfile invoke(@NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Object object = this.this$0.deserialize(OslcSelfTestDriver.access$handleResponse(this.this$0, response));
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.xml.UserProfile");
                return (UserProfile)object;
            }
        });
    }

    @Override
    @NotNull
    public ProfileResourceList getAvailableResources(@NotNull NotificationSession session, @NotNull String profile) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Map map = new LinkedHashMap();
        map.put("sessionId", JsonElementKt.JsonPrimitive((String)session.getSessionId()));
        map.put("profile", JsonElementKt.JsonPrimitive((String)profile));
        return (ProfileResourceList)this.makeCall("wsmethod:getAvailableResources", map, (Function1)new Function1<Response, ProfileResourceList>(this){
            final /* synthetic */ OslcSelfTestDriver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ProfileResourceList invoke(@NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Object object = this.this$0.deserialize(OslcSelfTestDriver.access$handleResponse(this.this$0, response));
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.xml.ProfileResourceList");
                return (ProfileResourceList)object;
            }
        });
    }

    @Override
    @NotNull
    public ProfileResource getResource(@NotNull NotificationSession session, @NotNull String profile, @NotNull String resource, @NotNull String langCode, int version) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)langCode, (String)"langCode");
        Map map = new LinkedHashMap();
        map.put("sessionId", JsonElementKt.JsonPrimitive((String)session.getSessionId()));
        map.put("profile", JsonElementKt.JsonPrimitive((String)profile));
        map.put("resource", JsonElementKt.JsonPrimitive((String)resource));
        map.put("langCode", JsonElementKt.JsonPrimitive((String)langCode));
        map.put("version", JsonElementKt.JsonPrimitive((Number)version));
        map.put("offset", JsonElementKt.JsonPrimitive((Number)0));
        map.put("length", JsonElementKt.JsonPrimitive((Number)10));
        return (ProfileResource)this.makeCall("wsmethod:getResource", map, (Function1)new Function1<Response, ProfileResource>(this){
            final /* synthetic */ OslcSelfTestDriver this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ProfileResource invoke(@NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Object object = this.this$0.deserialize(OslcSelfTestDriver.access$handleResponse(this.this$0, response));
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.xml.ProfileResource");
                return (ProfileResource)object;
            }
        });
    }

    private final String handleResponse(Response response) {
        String responseTxt;
        ResponseBody responseBody = response.body();
        String string = responseBody != null ? responseBody.string() : null;
        if (string == null) {
            string = responseTxt = "";
        }
        if (response.code() == 200) {
            String string2;
            if (((CharSequence)responseTxt).length() == 0) {
                string2 = "";
            } else {
                JsonElement body = Json.Default.parseToJsonElement(responseTxt);
                string2 = (JsonElement)JsonElementKt.getJsonObject((JsonElement)body).get((Object)"return");
                if (string2 == null || (string2 = JsonElementKt.getJsonPrimitive((JsonElement)string2)) == null || (string2 = string2.getContent()) == null) {
                    string2 = "";
                }
            }
            return string2;
        }
        if (response.code() == 401) {
            Object object = (JsonElement)JsonElementKt.getJsonObject((JsonElement)Json.Default.parseToJsonElement(responseTxt)).get((Object)"Error");
            if (object == null || (object = JsonElementKt.getJsonObject((JsonElement)object)) == null || (object = (JsonElement)object.get((Object)"message")) == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = object.getContent()) == null) {
                object = "";
            }
            Object faultString = object;
            throw new IllegalStateException(("Received an unexpected code: " + response.code() + ": " + (String)faultString + '.').toString());
        }
        throw new IllegalStateException(("Unhandled response code: " + response.code()).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R makeCall(String action2, Map<String, ? extends JsonElement> body, Function1<? super Response, ? extends R> block) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.maximoUrl);
        Object httpBuilder = httpUrl != null ? httpUrl.newBuilder() : null;
        if (httpBuilder == null) {
            boolean $i$a$-checkNotNull-OslcSelfTestDriver$makeCall$22 = false;
            String $i$a$-checkNotNull-OslcSelfTestDriver$makeCall$22 = "Error wil maximo url: " + this.maximoUrl;
            throw new IllegalStateException($i$a$-checkNotNull-OslcSelfTestDriver$makeCall$22.toString());
        }
        httpBuilder.addQueryParameter("lean", "1");
        httpBuilder.addQueryParameter("action", action2);
        StringFormat $this$encodeToString$iv = (StringFormat)this.formatter;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(Map.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(JsonElement.class))));
        boolean $i$f$cast = false;
        Request.Builder request = new Request.Builder().url(httpBuilder.build()).post(RequestBody.create((MediaType)this.jsonMediaType, (String)$this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, body)));
        if (this.useHttpAuth) {
            String string = this.credential;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"credential");
                string = null;
            }
            request.addHeader("Authorization", string);
        }
        if (this.useMaxAuth) {
            String string = this.maxAuth;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"maxAuth");
                string = null;
            }
            request.addHeader("MAXAUTH", string);
        }
        Closeable closeable = (Closeable)this.client.newCall(request.build()).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
            Object object = block.invoke((Object)response);
            return (R)object;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final /* synthetic */ String access$handleResponse(OslcSelfTestDriver $this, Response response) {
        return $this.handleResponse(response);
    }
}

