/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.selftest;

import com.interlocsolutions.maximo.notify.NotifyService;
import com.interlocsolutions.maximo.notify.selftest.BaseSelfTestDriver;
import com.interlocsolutions.maximo.notify.util.MaximoExtensionsKt;
import com.interlocsolutions.maximo.notify.xml.CatalogObjects;
import com.interlocsolutions.maximo.notify.xml.NotificationId;
import com.interlocsolutions.maximo.notify.xml.NotificationIds;
import com.interlocsolutions.maximo.notify.xml.NotificationSession;
import com.interlocsolutions.maximo.notify.xml.ProfileResource;
import com.interlocsolutions.maximo.notify.xml.ProfileResourceList;
import com.interlocsolutions.maximo.notify.xml.UserProfile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import psdi.security.UserInfo;
import psdi.server.MXServer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J0\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\fH\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/interlocsolutions/maximo/notify/selftest/DirectSelfTestDriver;", "Lcom/interlocsolutions/maximo/notify/selftest/BaseSelfTestDriver;", "()V", "service", "Lcom/interlocsolutions/maximo/notify/NotifyService;", "userInfo", "Lpsdi/security/UserInfo;", "getAvailableResources", "Lcom/interlocsolutions/maximo/notify/xml/ProfileResourceList;", "session", "Lcom/interlocsolutions/maximo/notify/xml/NotificationSession;", "profile", "", "getCatalogBaseline", "Lcom/interlocsolutions/maximo/notify/xml/CatalogObjects;", "catalog", "langCode", "partitionName", "getNotificationId", "Lcom/interlocsolutions/maximo/notify/xml/NotificationId;", "notificationId", "", "getNotificationIds", "Lcom/interlocsolutions/maximo/notify/xml/NotificationIds;", "getResource", "Lcom/interlocsolutions/maximo/notify/xml/ProfileResource;", "resource", "version", "", "getUserProfile", "Lcom/interlocsolutions/maximo/notify/xml/UserProfile;", "login", "userName", "password", "extras", "logout", "", "isinformer"})
public final class DirectSelfTestDriver
extends BaseSelfTestDriver {
    @NotNull
    private final NotifyService service;
    private UserInfo userInfo;

    public DirectSelfTestDriver() {
        MXServer mXServer = MXServer.getMXServer();
        Intrinsics.checkNotNullExpressionValue((Object)mXServer, (String)"getMXServer()");
        this.service = MaximoExtensionsKt.getNotifyService(mXServer);
    }

    @Override
    @NotNull
    public NotificationSession login(@NotNull String userName, @NotNull String password, @NotNull String extras) {
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        UserInfo userInfo = MXServer.getMXServer().getUserInfo(userName);
        Intrinsics.checkNotNullExpressionValue((Object)userInfo, (String)"getMXServer().getUserInfo(userName)");
        this.userInfo = userInfo;
        UserInfo userInfo2 = this.userInfo;
        if (userInfo2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userInfo");
            userInfo2 = null;
        }
        String string = this.service.login(userName, password, "maximo-self-test", "STS-41G", "java", false, extras, userInfo2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"service.login(\n         \u2026   userInfo\n            )");
        Object object = this.deserialize(string);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.xml.NotificationSession");
        return (NotificationSession)object;
    }

    @Override
    public void logout(@NotNull NotificationSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.service.logout(session.getSessionId());
    }

    @Override
    @NotNull
    public NotificationIds getNotificationIds(@NotNull NotificationSession session, @NotNull String profile) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        String string = session.getSessionId();
        UserInfo userInfo = this.userInfo;
        if (userInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userInfo");
            userInfo = null;
        }
        String string2 = this.service.getNotificationIds(profile, string, userInfo);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"service.getNotificationI\u2026   userInfo\n            )");
        Object object = this.deserialize(string2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.xml.NotificationIds");
        return (NotificationIds)object;
    }

    @Override
    @NotNull
    public NotificationId getNotificationId(@NotNull NotificationSession session, long notificationId) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        String string = session.getSessionId();
        UserInfo userInfo = this.userInfo;
        if (userInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userInfo");
            userInfo = null;
        }
        String string2 = this.service.getNotification(notificationId, string, userInfo);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"service.getNotification(\u2026sion.sessionId, userInfo)");
        Object object = this.deserialize(string2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.xml.NotificationId");
        return (NotificationId)object;
    }

    @Override
    @NotNull
    public CatalogObjects getCatalogBaseline(@NotNull NotificationSession session, @NotNull String profile, @NotNull String catalog, @NotNull String langCode, @NotNull String partitionName) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)catalog, (String)"catalog");
        Intrinsics.checkNotNullParameter((Object)langCode, (String)"langCode");
        Intrinsics.checkNotNullParameter((Object)partitionName, (String)"partitionName");
        String string = session.getSessionId();
        UserInfo userInfo = this.userInfo;
        if (userInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userInfo");
            userInfo = null;
        }
        String string2 = this.service.getCatalogBaseline(string, profile, catalog, -1L, langCode, partitionName, userInfo);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"service.getCatalogBaseli\u2026   userInfo\n            )");
        Object object = this.deserialize(string2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.xml.CatalogObjects");
        return (CatalogObjects)object;
    }

    @Override
    @NotNull
    public UserProfile getUserProfile(@NotNull NotificationSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        String string = session.getSessionId();
        UserInfo userInfo = this.userInfo;
        if (userInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userInfo");
            userInfo = null;
        }
        String string2 = this.service.getUserProfile(string, userInfo);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"service.getUserProfile(s\u2026sion.sessionId, userInfo)");
        Object object = this.deserialize(string2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.xml.UserProfile");
        return (UserProfile)object;
    }

    @Override
    @NotNull
    public ProfileResourceList getAvailableResources(@NotNull NotificationSession session, @NotNull String profile) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        String string = session.getSessionId();
        UserInfo userInfo = this.userInfo;
        if (userInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userInfo");
            userInfo = null;
        }
        String string2 = this.service.getAvailableResources(string, profile, userInfo);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"service.getAvailableReso\u2026ionId, profile, userInfo)");
        Object object = this.deserialize(string2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.xml.ProfileResourceList");
        return (ProfileResourceList)object;
    }

    @Override
    @NotNull
    public ProfileResource getResource(@NotNull NotificationSession session, @NotNull String profile, @NotNull String resource, @NotNull String langCode, int version) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)langCode, (String)"langCode");
        String string = session.getSessionId();
        UserInfo userInfo = this.userInfo;
        if (userInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userInfo");
            userInfo = null;
        }
        String string2 = this.service.getResource(string, profile, resource, langCode, version, 0, 10, userInfo);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"service.getResource(\n   \u2026   userInfo\n            )");
        Object object = this.deserialize(string2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.interlocsolutions.maximo.notify.xml.ProfileResource");
        return (ProfileResource)object;
    }
}

