/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.selftest;

import com.interlocsolutions.maximo.notify.selftest.SelfTestDriver;
import com.interlocsolutions.maximo.notify.util.JDBCExtensionsKt;
import com.interlocsolutions.maximo.notify.util.MboExtensionsKt;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionManager;
import com.interlocsolutions.maximo.notify.xml.CatalogObjects;
import com.interlocsolutions.maximo.notify.xml.NotificationId;
import com.interlocsolutions.maximo.notify.xml.NotificationIds;
import com.interlocsolutions.maximo.notify.xml.NotificationSession;
import com.interlocsolutions.maximo.notify.xml.ProfileResource;
import com.interlocsolutions.maximo.notify.xml.ProfileResourceList;
import com.interlocsolutions.maximo.notify.xml.ProfileResourceListValue;
import com.interlocsolutions.maximo.notify.xml.UserProfile;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.util.Message;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J5\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u0010J&\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fJ\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J5\u0010\u001a\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000f\"\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010 \u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010\"\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0018\u0010#\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/interlocsolutions/maximo/notify/selftest/BasicSelfTest;", "", "driver", "Lcom/interlocsolutions/maximo/notify/selftest/SelfTestDriver;", "(Lcom/interlocsolutions/maximo/notify/selftest/SelfTestDriver;)V", "out", "Ljava/io/PrintWriter;", "writer", "Ljava/io/StringWriter;", "appendMessage", "", "msgGroup", "", "msgKey", "params", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V", "execute", "profile", "userName", "password", "langCode", "getCatalogPartitions", "", "catalogMbo", "Lpsdi/mbo/MboRemote;", "getMessage", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "loginExtras", "logout", "session", "Lcom/interlocsolutions/maximo/notify/xml/NotificationSession;", "testCatalogRetrieval", "testGetUserProfile", "testNotificationRetrieval", "testResources", "isinformer"})
public final class BasicSelfTest {
    @NotNull
    private final SelfTestDriver driver;
    @NotNull
    private final StringWriter writer;
    @NotNull
    private final PrintWriter out;

    public BasicSelfTest(@NotNull SelfTestDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        this.driver = driver;
        this.writer = new StringWriter();
        this.out = new PrintWriter(this.writer);
    }

    @NotNull
    public final String execute(@NotNull String profile, @NotNull String userName, @NotNull String password, @NotNull String langCode) {
        Object $this$execute_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)langCode, (String)"langCode");
        Object object = this;
        try {
            $this$execute_u24lambda_u240 = object;
            boolean bl = false;
            $this$execute_u24lambda_u240 = Result.constructor-impl((Object)((BasicSelfTest)$this$execute_u24lambda_u240).driver.login(userName, password, super.loginExtras(profile, langCode)));
        }
        catch (Throwable bl) {
            $this$execute_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$execute_u24lambda_u240;
        if (Result.isSuccess-impl((Object)object)) {
            NotificationSession session = (NotificationSession)object;
            boolean bl = false;
            if (session.isAuthenticated()) {
                this.appendMessage("informer", "selftest.loginSuccess", new Object[0]);
                this.testGetUserProfile(session);
                this.testNotificationRetrieval(session, profile);
                this.testCatalogRetrieval(session, profile, langCode);
                this.testResources(session, profile);
                this.logout(session);
            } else {
                Object[] objectArray = new Object[]{userName};
                this.appendMessage("informer", "selftest.loginNotAuthenticated", objectArray);
            }
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable throwable2;
            Throwable it = throwable2 = throwable;
            boolean bl = false;
            Object[] objectArray = new Object[]{it.getMessage()};
            this.appendMessage("informer", "selftest.loginFailure", objectArray);
        }
        String string = this.writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writer.toString()");
        return string;
    }

    private final void appendMessage(String msgGroup, String msgKey, Object ... params) {
        this.out.println(this.getMessage(msgGroup, msgKey, Arrays.copyOf(params, params.length)));
    }

    private final String getMessage(String msgGroup, String msgKey, Object ... params) {
        String string;
        Message msg = MXServer.getMXServer().getMaxMessageCache().getTaggedMessage(msgGroup, msgKey);
        if (msg == null) {
            boolean bl = false;
            String string2 = "MsgGroup: " + msgGroup + ", MsgKey: " + msgKey + " does not exist.";
            throw new IllegalStateException(string2.toString());
        }
        if (params.length == 0) {
            String string3 = msg.getMessage();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n            msg.message\n        }");
        } else {
            String string4 = msg.getMessage(params);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n            msg.getMessage(params)\n        }");
        }
        return string;
    }

    private final String loginExtras(String profile, String langCode) {
        return StringsKt.trimIndent((String)("\n            <extras xmlns=\"http://www.interlocsolutions.com/maximo/notify\">\n                <notification>" + profile + "</notification>\n                <langCode>" + langCode + "</langCode>\n            </extras>\n        "));
    }

    private final Set<String> getCatalogPartitions(MboRemote catalogMbo) {
        Collection collection;
        Set rc2 = (Set)DbConnectionManager.getInstance().getMaximoConnection().useConn((Function1)new Function1<Connection, Set<? extends String>>(catalogMbo){
            final /* synthetic */ MboRemote $catalogMbo;
            {
                this.$catalogMbo = $catalogMbo;
                super(1);
            }

            @NotNull
            public final Set<String> invoke(@NotNull Connection conn) {
                Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
                String string = new SqlFormat(this.$catalogMbo, "SELECT DISTINCT partitionname FROM iscatalogdata\nWHERE catalogid = :catalogid AND revision = :revision\nAND partitionname IS NOT NULL").format();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlFormat(\n             \u2026               ).format()");
                return JDBCExtensionsKt.collectStringSet$default((Connection)conn, (String)string, null, (int)2, null);
            }
        });
        Collection collection2 = rc2;
        if (collection2.isEmpty()) {
            boolean bl = false;
            collection = SetsKt.setOf((Object)"");
        } else {
            collection = collection2;
        }
        return (Set)collection;
    }

    private final void testGetUserProfile(NotificationSession session) {
        block3: {
            Throwable throwable;
            Object $this$testGetUserProfile_u24lambda_u245;
            Object object = this;
            try {
                $this$testGetUserProfile_u24lambda_u245 = object;
                boolean bl = false;
                $this$testGetUserProfile_u24lambda_u245 = Result.constructor-impl((Object)((BasicSelfTest)$this$testGetUserProfile_u24lambda_u245).driver.getUserProfile(session));
            }
            catch (Throwable bl) {
                $this$testGetUserProfile_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$testGetUserProfile_u24lambda_u245;
            if (Result.isSuccess-impl((Object)object)) {
                UserProfile it = (UserProfile)object;
                boolean bl = false;
                this.appendMessage("informer", "selftest.userProfileSuccess", new Object[0]);
            }
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 == null) break block3;
            Throwable it = throwable = throwable2;
            boolean bl = false;
            Object[] objectArray = new Object[]{it.getMessage()};
            this.appendMessage("informer", "selftest.userProfileFailure", objectArray);
        }
    }

    private final void testNotificationRetrieval(NotificationSession session, String profile) {
        block9: {
            Throwable throwable;
            Object object;
            Object $this$testNotificationRetrieval_u24lambda_u248;
            Object object2 = this;
            try {
                $this$testNotificationRetrieval_u24lambda_u248 = object2;
                boolean bl = false;
                $this$testNotificationRetrieval_u24lambda_u248 = Result.constructor-impl((Object)((BasicSelfTest)$this$testNotificationRetrieval_u24lambda_u248).driver.getNotificationIds(session, profile));
            }
            catch (Throwable bl) {
                $this$testNotificationRetrieval_u24lambda_u248 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = $this$testNotificationRetrieval_u24lambda_u248;
            if (Result.isSuccess-impl((Object)object2)) {
                NotificationIds notificationIds = (NotificationIds)object2;
                boolean bl = false;
                if (notificationIds.getIds() == null || notificationIds.getIds().isEmpty()) {
                    this.appendMessage("informer", "selftest.notificationIdsEmpty", new Object[0]);
                } else {
                    Object $this$testNotificationRetrieval_u24lambda_u2412_u24lambda_u249;
                    Object object3 = new Object[]{notificationIds.getIds().size()};
                    this.appendMessage("informer", "selftest.notificationIdsSuccess", object3);
                    object3 = this;
                    try {
                        $this$testNotificationRetrieval_u24lambda_u2412_u24lambda_u249 = (BasicSelfTest)object3;
                        boolean bl2 = false;
                        $this$testNotificationRetrieval_u24lambda_u2412_u24lambda_u249 = Result.constructor-impl((Object)((BasicSelfTest)$this$testNotificationRetrieval_u24lambda_u2412_u24lambda_u249).driver.getNotificationId(session, notificationIds.getIds().get(0).getId()));
                    }
                    catch (Throwable bl2) {
                        $this$testNotificationRetrieval_u24lambda_u2412_u24lambda_u249 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                    }
                    object3 = $this$testNotificationRetrieval_u24lambda_u2412_u24lambda_u249;
                    if (Result.isSuccess-impl((Object)object3)) {
                        NotificationId it = (NotificationId)object3;
                        boolean bl3 = false;
                        this.appendMessage("informer", "selftest.notificationIdSuccess", new Object[0]);
                    }
                    Throwable throwable2 = Result.exceptionOrNull-impl((Object)object3);
                    if (throwable2 != null) {
                        Object it = object = throwable2;
                        boolean bl4 = false;
                        Object[] objectArray = new Object[]{((Throwable)it).getMessage()};
                        this.appendMessage("informer", "selftest.notificationIdFailure", objectArray);
                    }
                }
            }
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object2);
            if (throwable3 == null) break block9;
            Throwable it = throwable = throwable3;
            boolean bl = false;
            object = new Object[]{it.getMessage()};
            this.appendMessage("informer", "selftest.notificationIdsFailure", (Object[])object);
        }
    }

    private final void testCatalogRetrieval(NotificationSession session, String profile, String langCode) {
        SqlFormat sf = new SqlFormat("notifyid IN (SELECT notifyid FROM isnotify WHERE notifynum = :1 ) \nand catalog <> 'ISPROPERTIES'");
        sf.setObject(1, "ISNOTIFY", "NOTIFYNUM", profile);
        MboSetRemote $this$forEach$iv = MboExtensionsKt.getNewMboSet$default("ISCATALOG", sf.format(), null, false, 12, null);
        boolean $i$f$forEach = false;
        Sequence<MboRemote> $this$forEach$iv$iv = MboExtensionsKt.asSequence($this$forEach$iv);
        boolean $i$f$forEach2 = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            MboRemote catalogMbo = (MboRemote)element$iv$iv;
            boolean bl = false;
            String catalog = catalogMbo.getString("CATALOG");
            Iterable $this$forEach$iv2 = this.getCatalogPartitions(catalogMbo);
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Object[] objectArray;
                Throwable throwable;
                Object $this$testCatalogRetrieval_u24lambda_u2418_u24lambda_u2417_u24lambda_u2414;
                String partitionName = (String)element$iv;
                boolean bl2 = false;
                Object object = this;
                try {
                    $this$testCatalogRetrieval_u24lambda_u2418_u24lambda_u2417_u24lambda_u2414 = object;
                    boolean bl3 = false;
                    SelfTestDriver selfTestDriver = ((BasicSelfTest)$this$testCatalogRetrieval_u24lambda_u2418_u24lambda_u2417_u24lambda_u2414).driver;
                    Intrinsics.checkNotNullExpressionValue((Object)catalog, (String)"catalog");
                    $this$testCatalogRetrieval_u24lambda_u2418_u24lambda_u2417_u24lambda_u2414 = Result.constructor-impl((Object)selfTestDriver.getCatalogBaseline(session, profile, catalog, langCode, partitionName));
                }
                catch (Throwable bl3) {
                    $this$testCatalogRetrieval_u24lambda_u2418_u24lambda_u2417_u24lambda_u2414 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
                }
                object = $this$testCatalogRetrieval_u24lambda_u2418_u24lambda_u2417_u24lambda_u2414;
                if (Result.isSuccess-impl((Object)object)) {
                    Object[] objectArray2;
                    CatalogObjects catalogObjects = (CatalogObjects)object;
                    boolean bl4 = false;
                    if (catalogObjects.getObjects().isEmpty()) {
                        if (Intrinsics.areEqual((Object)partitionName, (Object)"")) {
                            objectArray2 = new Object[]{catalog};
                            this.appendMessage("informer", "selftest.catalogBaselineEmptyNoPart", objectArray2);
                        } else {
                            objectArray2 = new Object[]{catalog, partitionName};
                            this.appendMessage("informer", "selftest.catalogBaselineEmpty", objectArray2);
                        }
                    } else if (Intrinsics.areEqual((Object)partitionName, (Object)"")) {
                        objectArray2 = new Object[]{catalog, partitionName};
                        this.appendMessage("informer", "selftest.catalogBaselineSuccessNoPart", objectArray2);
                    } else {
                        objectArray2 = new Object[]{catalog, partitionName};
                        this.appendMessage("informer", "selftest.catalogBaselineSuccess", objectArray2);
                    }
                }
                if (Result.exceptionOrNull-impl((Object)object) == null) continue;
                Throwable it = throwable;
                boolean bl5 = false;
                if (Intrinsics.areEqual((Object)partitionName, (Object)"")) {
                    objectArray = new Object[]{catalog, partitionName, it.getMessage()};
                    this.appendMessage("informer", "selftest.catalogBaselineFailureNoPart", objectArray);
                    continue;
                }
                objectArray = new Object[]{catalog, partitionName, it.getMessage()};
                this.appendMessage("informer", "selftest.catalogBaselineFailure", objectArray);
            }
        }
    }

    private final void testResources(NotificationSession session, String profile) {
        block7: {
            Throwable throwable;
            Object $this$testResources_u24lambda_u2419;
            Object object = this;
            try {
                $this$testResources_u24lambda_u2419 = object;
                boolean bl = false;
                $this$testResources_u24lambda_u2419 = Result.constructor-impl((Object)((BasicSelfTest)$this$testResources_u24lambda_u2419).driver.getAvailableResources(session, profile));
            }
            catch (Throwable bl) {
                $this$testResources_u24lambda_u2419 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$testResources_u24lambda_u2419;
            if (Result.isSuccess-impl((Object)object)) {
                ProfileResourceList resources = (ProfileResourceList)object;
                boolean bl = false;
                Object[] objectArray = new Object[]{resources.getValues().size()};
                this.appendMessage("informer", "selftest.resourcesSuccess", objectArray);
                ArrayList<ProfileResourceListValue> arrayList = resources.getValues();
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"resources.values");
                Iterable $this$forEach$iv = arrayList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Throwable throwable2;
                    Object $this$testResources_u24lambda_u2424_u24lambda_u2423_u24lambda_u2420;
                    ProfileResourceListValue resource = (ProfileResourceListValue)element$iv;
                    boolean bl2 = false;
                    Object object2 = this;
                    try {
                        $this$testResources_u24lambda_u2424_u24lambda_u2423_u24lambda_u2420 = object2;
                        boolean bl3 = false;
                        SelfTestDriver selfTestDriver = ((BasicSelfTest)$this$testResources_u24lambda_u2424_u24lambda_u2423_u24lambda_u2420).driver;
                        String string = resource.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resource.name");
                        String string2 = resource.getLangCode();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resource.langCode");
                        $this$testResources_u24lambda_u2424_u24lambda_u2423_u24lambda_u2420 = Result.constructor-impl((Object)selfTestDriver.getResource(session, profile, string, string2, resource.getVersion()));
                    }
                    catch (Throwable bl3) {
                        $this$testResources_u24lambda_u2424_u24lambda_u2423_u24lambda_u2420 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
                    }
                    object2 = $this$testResources_u24lambda_u2424_u24lambda_u2423_u24lambda_u2420;
                    if (Result.isSuccess-impl((Object)object2)) {
                        ProfileResource it = (ProfileResource)object2;
                        boolean bl4 = false;
                        Object[] objectArray2 = new Object[]{resource.getName(), resource.getVersion(), resource.getLangCode()};
                        this.appendMessage("informer", "selftest.resourceSuccess", objectArray2);
                    }
                    if (Result.exceptionOrNull-impl((Object)object2) == null) continue;
                    Throwable it = throwable2;
                    boolean bl5 = false;
                    Object[] objectArray3 = new Object[]{resource.getName(), resource.getVersion(), resource.getLangCode(), it.getMessage()};
                    this.appendMessage("informer", "selftest.resourceFailure", objectArray3);
                }
            }
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
            if (throwable3 == null) break block7;
            Throwable it = throwable = throwable3;
            boolean bl = false;
            Object[] objectArray = new Object[]{it.getMessage()};
            this.appendMessage("informer", "selftest.resourcesFailure", objectArray);
        }
    }

    private final void logout(NotificationSession session) {
        block3: {
            Throwable throwable;
            Object $this$logout_u24lambda_u2426;
            Object object = this;
            try {
                $this$logout_u24lambda_u2426 = object;
                boolean bl = false;
                ((BasicSelfTest)$this$logout_u24lambda_u2426).driver.logout(session);
                $this$logout_u24lambda_u2426 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$logout_u24lambda_u2426 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$logout_u24lambda_u2426;
            if (Result.isSuccess-impl((Object)object)) {
                Unit it = (Unit)object;
                boolean bl = false;
                this.appendMessage("informer", "selftest.logoutSuccess", new Object[0]);
            }
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 == null) break block3;
            Throwable it = throwable = throwable2;
            boolean bl = false;
            Object[] objectArray = new Object[]{it.getMessage()};
            this.appendMessage("informer", "selftest.logoutFailure", objectArray);
        }
    }
}

