/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.security.datavalidator;

import com.interlocsolutions.maximo.notify.security.SessionInfo;
import com.interlocsolutions.maximo.notify.security.datavalidator.GetAttachedDocumentValidator;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import java.rmi.RemoteException;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;

public class GetAttachedDocumentValidationManager {
    public static final String PUBLIC_VALIDATOR_CLASSNAME_PROPERTY = "informer.public.getattacheddocument.validator";
    public static final String VALIDATOR_CLASSNAME_PROPERTY = "informer.getattacheddocument.validator";

    public static void validateGetAttachedDocument(SessionInfo session, long docInfoId) throws MXApplicationException {
        GetAttachedDocumentValidator validator = GetAttachedDocumentValidationManager.getGetAttachedDocumentValidator(session);
        if (validator != null) {
            if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)("Validating getAttachedDocument request for DOCINFOID " + docInfoId + " with validator " + validator.getClass().getName() + " for session " + session.getSessionKey()));
            }
            validator.validateGetAttachedDocument(session, docInfoId);
            if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)("Completed validation of getAttachedDocument request for DOCINFOID " + docInfoId + " with validator " + validator.getClass().getName() + " for session " + session.getSessionKey()));
            }
        }
    }

    public static GetAttachedDocumentValidator getGetAttachedDocumentValidator(SessionInfo session) throws MXApplicationException {
        try {
            String getAttachedDocumentValidatorClassname = null;
            if (session.isAnonymous()) {
                getAttachedDocumentValidatorClassname = MXServer.getMXServer().getProperty(PUBLIC_VALIDATOR_CLASSNAME_PROPERTY);
            }
            if (getAttachedDocumentValidatorClassname == null || getAttachedDocumentValidatorClassname.trim().length() == 0) {
                getAttachedDocumentValidatorClassname = MXServer.getMXServer().getProperty(VALIDATOR_CLASSNAME_PROPERTY);
            }
            if (getAttachedDocumentValidatorClassname != null && getAttachedDocumentValidatorClassname.trim().length() > 0) {
                try {
                    Class<?> validatorClass = Class.forName(getAttachedDocumentValidatorClassname.trim());
                    if (GetAttachedDocumentValidator.class.isAssignableFrom(validatorClass)) {
                        return (GetAttachedDocumentValidator)validatorClass.newInstance();
                    }
                    if (NotifyConstants.INFORMER_LOGGER.isErrorEnabled()) {
                        NotifyConstants.INFORMER_LOGGER.error((Object)("Get Attached Document validator class: " + getAttachedDocumentValidatorClassname + " is of incorrect type.  It must implement " + GetAttachedDocumentValidator.class.getName()));
                    }
                    throw new MXApplicationException("informer", "invalidGetAttachedDocumentValidator");
                }
                catch (ClassNotFoundException e) {
                    if (NotifyConstants.INFORMER_LOGGER.isErrorEnabled()) {
                        NotifyConstants.INFORMER_LOGGER.error((Object)("Error instantiating get attached document validator class: " + getAttachedDocumentValidatorClassname), (Throwable)e);
                    }
                    throw new MXApplicationException("informer", "invalidGetAttachedDocumentValidator");
                }
                catch (InstantiationException e) {
                    if (NotifyConstants.INFORMER_LOGGER.isErrorEnabled()) {
                        NotifyConstants.INFORMER_LOGGER.error((Object)("Error instantiating get attached document validator class: " + getAttachedDocumentValidatorClassname), (Throwable)e);
                    }
                    throw new MXApplicationException("informer", "invalidGetAttachedDocumentValidator");
                }
                catch (IllegalAccessException e) {
                    if (NotifyConstants.INFORMER_LOGGER.isErrorEnabled()) {
                        NotifyConstants.INFORMER_LOGGER.error((Object)("Error instantiating get attached document validator class: " + getAttachedDocumentValidatorClassname), (Throwable)e);
                    }
                    throw new MXApplicationException("informer", "invalidGetAttachedDocumentValidator");
                }
            }
            return null;
        }
        catch (RemoteException e) {
            if (NotifyConstants.INFORMER_LOGGER.isErrorEnabled()) {
                NotifyConstants.INFORMER_LOGGER.error((Object)"Error obtaining get attached document validator class", (Throwable)e);
            }
            throw new MXApplicationException("informer", "invalidGetAttachedDocumentValidator", (Throwable)e);
        }
    }
}

